/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.metamodelquery;

import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.UtilSetup;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client7
extends UtilSetup {
    private static final System.Logger logger = System.getLogger(Client7.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client7.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_metamodelquery7.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void getCorrelatedJoinsTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(Order.class);
            Set cJoins = sq.getCorrelatedJoins();
            if (cJoins != null) {
                if (cJoins.size() == 0) {
                    logger.log(System.Logger.Level.ERROR, "Received expected 0 correlated joins from subquery.getCorrelatedJoins() when none exist");
                    CollectionJoin sqo = sq.correlate(customer.join(Customer_.orders));
                    sq.select((Expression)sqo);
                    cJoins = sq.getCorrelatedJoins();
                    if (cJoins != null) {
                        if (cJoins.size() == 1) {
                            logger.log(System.Logger.Level.TRACE, "Received expected 1 correlated join from subquery.getCorrelatedJoins()");
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received " + cJoins.size() + " correlated joins from subquery.getCorrelatedJoins() when 1 exist");
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Received null from subquery.getCorrelatedJoins() when 1 correlated join exists");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received " + cJoins.size() + " unexpected correlated joins from subquery.getCorrelatedJoins() when non exist");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Received null from subquery.getCorrelatedJoins() instead of empty set when non exist");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception(" getCorrelatedJoinsTest failed");
        }
    }
}

