/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.cascadeall.oneXone;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.cascadeall.oneXone.A;
import ee.jakarta.tck.persistence.core.entitytest.cascadeall.oneXone.B;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_cascadeall_oneXone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Entering Setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("1", "a1", 1);
            B bRef = new B("1", "bean1", 1, a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "getA1");
            A a2 = bRef.getA1();
            if (a1 == a2 && this.getEntityManager().contains((Object)bRef)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results - test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1X1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("2", "a2", 2);
            B bRef = new B("2", "b2", 2, a1);
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            if (this.getInstanceStatus(this.findB("2"))) {
                try {
                    logger.log(System.Logger.Level.TRACE, "entity is managed, remove it ");
                    this.getEntityManager().remove((Object)this.findB("2"));
                    this.getEntityManager().flush();
                    logger.log(System.Logger.Level.TRACE, "Persist a removed entity");
                    this.getEntityManager().persist((Object)bRef);
                    pass = this.getInstanceStatus(bRef);
                }
                catch (Exception ee) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception trying to persist a removed entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1X1Test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("3", "a3", 3);
            B bRef = new B("3", "bean3", 3, a1);
            this.getEntityManager().persist((Object)bRef);
            A a2 = bRef.getA1();
            if (a1 == a2 && this.getEntityManager().contains((Object)a2)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results received - test failed");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1X1Test3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test4");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("4", "a4", 4);
            B bRef = new B("4", "bean4", 4, a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "bref created, try find");
            A newA = this.findA("4");
            if (null != newA) {
                pass = this.getEntityManager().contains((Object)newA);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1X1Test4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test5");
        boolean pass1 = true;
        boolean pass2 = true;
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            B b1 = new B("5", "b5", 5);
            A aRef = new A("5", "bean5", 5, b1);
            pass1 = this.getEntityManager().contains((Object)b1);
            pass2 = this.getEntityManager().contains((Object)aRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (pass1 || pass2 || !pass) {
            logger.log(System.Logger.Level.ERROR, "pass=" + pass + ", pass1=" + pass1 + ", pass2=" + pass2);
            throw new Exception("cascadeAll1X1Test5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test6");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("6", "a6", 6);
            B bRef = new B("6", "bean6", 6);
            this.getEntityManager().persist((Object)bRef);
            if (this.getEntityManager().contains((Object)bRef)) {
                B bRef1 = this.findB("6");
                bRef1.setA1(a1);
                this.getEntityManager().persist((Object)bRef1);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "try to find A");
                A a2 = this.findA("6");
                if (null != a2) {
                    logger.log(System.Logger.Level.TRACE, "A2 is not null");
                    pass = this.getEntityManager().contains((Object)a2);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1X1Test6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test7() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test7");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            B b1 = new B("7", "b7", 7);
            A aRef = new A("7", "bean7", 7, b1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException caught as expected:" + e);
            pass = true;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (IllegalStateException fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1X1Test7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test8() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test8");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("8", "a8", 8);
            B bRef = new B("8", "a8", 8, a1);
            this.getEntityManager().persist((Object)bRef);
            A a2 = bRef.getA1();
            if (this.getInstanceStatus(bRef) && a2 == a1) {
                try {
                    A stillExists;
                    logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                    this.getEntityManager().remove((Object)this.findB("8"));
                    logger.log(System.Logger.Level.TRACE, "Remove is immediately visible to the contains method");
                    if (!this.getEntityManager().contains((Object)a2) && !this.getEntityManager().contains((Object)bRef)) {
                        this.getEntityManager().flush();
                    }
                    if ((stillExists = this.findA("8")) == null) {
                        pass = true;
                    }
                }
                catch (Exception onfe) {
                    logger.log(System.Logger.Level.TRACE, "Expected Exception :" + onfe);
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1X1Test8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test9() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test9");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("9", "a9", 9);
            B bRef = new B("9", "a9", 9, a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get Instance ");
            A a2 = bRef.getA1();
            if (this.getInstanceStatus(bRef) && a2 == a1) {
                try {
                    logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                    B newB = this.findB("9");
                    this.getEntityManager().remove((Object)newB);
                    if (!this.getEntityManager().contains((Object)a2)) {
                        pass = true;
                    }
                }
                catch (Exception onfe) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected Exception :" + onfe);
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1X1Test9 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cascadeAll1X1Test10() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin cascadeAll1X1Test10");
        boolean pass = false;
        boolean status = true;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("10", "a10", 10);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("10", "b10", 10, a1);
            if (this.getInstanceStatus(a1)) {
                try {
                    logger.log(System.Logger.Level.TRACE, "entity is new, remove ignored on bRef, a1 should be removed");
                    this.getEntityManager().remove((Object)bRef);
                    status = this.getEntityManager().contains((Object)a1);
                    this.getEntityManager().flush();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
                pass = false;
            }
            A stillExists = this.findA("10");
            if (!status && stillExists == null) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1X1Test10 failed");
        }
    }

    private A findA(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        logger.log(System.Logger.Level.TRACE, "Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

