/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.attribute;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.attribute.Order;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.reflect.Member;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_metamodelapi_attribute.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getName() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    if (attrib.getName() != null) {
                        if (attrib.getName().equals("total")) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + attrib.getName());
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: " + Attribute.PersistentAttributeType.BASIC.toString() + ", actual:" + attrib.getName());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getName Test  failed");
        }
    }

    @Test
    public void getPersistentAttributeType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    Attribute.PersistentAttributeType pAttribType = attrib.getPersistentAttributeType();
                    if (pAttribType == Attribute.PersistentAttributeType.BASIC) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + pAttribType);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: " + Attribute.PersistentAttributeType.BASIC.toString() + ", actual:" + pAttribType);
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistentAttributeType Test  failed");
        }
    }

    @Test
    public void getDeclaringType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                    ManagedType newTypeOrder = attrib.getDeclaringType();
                    if (newTypeOrder != null) {
                        Class javaType = newTypeOrder.getJavaType();
                        if (javaType.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.attribute.Order")) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + javaType.getName());
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.attribute.Order, actual:" + javaType.getName());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaringType Test  failed");
        }
    }

    @Test
    public void getJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute JavaType = " + attrib.getJavaType());
                    Class pAttribJavaType = attrib.getJavaType();
                    if (pAttribJavaType.getName().equals("int")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + pAttribJavaType);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: int, actual:" + pAttribJavaType);
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaType Test  failed");
        }
    }

    @Test
    public void getJavaMember() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute JavaMember = " + attrib.getJavaMember().getName());
                    Member javaMember = attrib.getJavaMember();
                    if (javaMember.getName().equals("getTotal")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + javaMember.getName());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: getTotal, actual:" + javaMember.getName());
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaMember Test  failed");
        }
    }

    @Test
    public void isAssociation() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute IsAssociation = " + attrib.isAssociation());
                    if (!attrib.isAssociation()) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + attrib.isAssociation());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected result: " + attrib.isAssociation());
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isAssociation Test  failed");
        }
    }

    @Test
    public void isCollection() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                if (attrib != null) {
                    logger.log(System.Logger.Level.TRACE, "attribute IsCollection = " + attrib.isCollection());
                    if (!attrib.isCollection()) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result:" + attrib.isCollection());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected result: " + attrib.isCollection());
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isCollection Test  failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

