/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.embeddable;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.embeddable.Applicant;
import ee.jakarta.tck.persistence.core.override.embeddable.Book;
import ee.jakarta.tck.persistence.core.override.embeddable.BookStore;
import ee.jakarta.tck.persistence.core.override.embeddable.Complaint;
import ee.jakarta.tck.persistence.core.override.embeddable.Film;
import ee.jakarta.tck.persistence.core.override.embeddable.MovieTicket;
import ee.jakarta.tck.persistence.core.override.embeddable.Publisher;
import ee.jakarta.tck.persistence.core.override.embeddable.Publisher1;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final Integer BOOKSTORE_ID = 12345;
    private static final String PUBLISHER_NAME = "Sun";
    private static final String PUBLISHER_LOCATION = "Santa Clara";
    private static final int COMPLAINT_NUMBER = 24680;
    private static final String APPLICANT_NAME = "Sunny";
    private static final String APPLICANT_ADDRESS = "Menlo Park";
    private static final Integer COMPLAINT_ID = 9;
    private static final Integer MOVIETICKET_ID = 6;
    private static final String FILM_CODE = "007";
    private static final String FILM_NAME = "Network is Computer";
    private static final Integer BOOK_ID = 5;
    private static final String PUBLISHER1_NAME = "Penguin";
    private static final String PUBLISHER1_STATE = "California";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFiles = new String[]{"orm.xml"};
        String[] classes = new String[]{pkgName + "Applicant", pkgName + "Book", pkgName + "BookStore", pkgName + "Complaint", pkgName + "Film", pkgName + "MovieTicket", pkgName + "Publisher", pkgName + "Publisher1"};
        return this.createDeploymentJar("jpa_core_override_embeddable.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception:test failed ", (Throwable)e);
        }
    }

    @Test
    public void testOverrideTransient() throws Exception {
        block7: {
            this.getEntityTransaction().begin();
            Publisher publisher = new Publisher();
            publisher.setName(PUBLISHER_NAME);
            publisher.setLocation(PUBLISHER_LOCATION);
            BookStore bookstore = new BookStore();
            bookstore.setId(BOOKSTORE_ID);
            bookstore.setPublisher(publisher);
            this.getEntityManager().persist((Object)bookstore);
            this.getEntityManager().flush();
            try {
                BookStore retrieveBook = (BookStore)this.getEntityManager().find(BookStore.class, (Object)BOOKSTORE_ID);
                retrieveBook.setPublisher(new Publisher());
                this.getEntityManager().refresh((Object)retrieveBook);
                Publisher retrievePublisher = retrieveBook.getPublisher();
                if (retrievePublisher.getName().equals(PUBLISHER_NAME)) {
                    if (retrievePublisher.getLocation() == null) {
                        logger.log(System.Logger.Level.TRACE, "Test Passed");
                        break block7;
                    }
                    throw new Exception("The Location fields was expected to be empty, expected Length - null, actual - " + retrievePublisher.getLocation());
                }
                throw new Exception("Incorrect BookStore object obtained from the database");
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testOverrideTransient" + e);
            }
            finally {
                this.getEntityManager().remove((Object)bookstore);
                this.getEntityTransaction().commit();
            }
        }
    }

    @Test
    public void testOverrideEmbeddable() throws Exception {
        block6: {
            this.getEntityTransaction().begin();
            Applicant applicant = new Applicant();
            applicant.setName(APPLICANT_NAME);
            applicant.setAddress(APPLICANT_ADDRESS);
            Complaint complaint = new Complaint();
            complaint.setId(COMPLAINT_ID);
            complaint.setComplaintNumber(24680);
            complaint.setApplicant(applicant);
            this.getEntityManager().persist((Object)complaint);
            this.getEntityManager().flush();
            try {
                Complaint retrieveComplaint = (Complaint)this.getEntityManager().find(Complaint.class, (Object)COMPLAINT_ID);
                Applicant retrieveApplicant = retrieveComplaint.getApplicant();
                if (retrieveComplaint.getComplaintNumber() == 24680 && retrieveApplicant.getName().equals(APPLICANT_NAME) && retrieveApplicant.getAddress().equals(APPLICANT_ADDRESS)) {
                    logger.log(System.Logger.Level.TRACE, "Test Passed");
                    break block6;
                }
                throw new Exception("Expected Complaint Number COMPLAINT_NUMBER to be retrieved; complaint in DB - " + retrieveComplaint.getComplaintNumber());
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testOverrideEmbeddable" + e);
            }
            finally {
                this.getEntityManager().remove((Object)complaint);
                this.getEntityTransaction().commit();
            }
        }
    }

    @Test
    public void testOverrideEmbedded() throws Exception {
        block6: {
            this.getEntityTransaction().begin();
            Film film = new Film();
            film.setFilmCode(FILM_CODE);
            film.setFilmName(FILM_NAME);
            MovieTicket ticket = new MovieTicket();
            ticket.setId(MOVIETICKET_ID);
            ticket.setFilm(film);
            this.getEntityManager().persist((Object)ticket);
            this.getEntityManager().flush();
            try {
                MovieTicket retrieveTicket = (MovieTicket)this.getEntityManager().find(MovieTicket.class, (Object)MOVIETICKET_ID);
                Film retrieveFilm = retrieveTicket.getFilm();
                if (retrieveFilm.getFilmName().equals(FILM_NAME) && retrieveFilm.getFilmCode().equals(FILM_CODE)) {
                    logger.log(System.Logger.Level.TRACE, "Test Passed");
                    break block6;
                }
                throw new Exception("Expected MovieTicket(FILM_NAME) to be retrieved; film in DB - " + retrieveFilm.getFilmName());
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testOverrideEmbedded" + e);
            }
            finally {
                this.getEntityManager().remove((Object)ticket);
                this.getEntityTransaction().commit();
            }
        }
    }

    @Test
    public void testMetadataCompleteness() throws Exception {
        block6: {
            this.getEntityTransaction().begin();
            Book book = new Book();
            Publisher1 publisher1 = new Publisher1();
            book.setId(BOOK_ID);
            publisher1.setName(PUBLISHER1_NAME);
            publisher1.setState(PUBLISHER1_STATE);
            book.setPublisher1(publisher1);
            this.getEntityManager().persist((Object)book);
            this.getEntityManager().flush();
            try {
                Book retrieveBook = (Book)this.getEntityManager().find(Book.class, (Object)BOOK_ID);
                retrieveBook.setPublisher1(new Publisher1());
                this.getEntityManager().refresh((Object)retrieveBook);
                Publisher1 retrievePublisher1 = retrieveBook.getPublisher1();
                if (retrievePublisher1.getName().equals(PUBLISHER1_NAME) && retrievePublisher1.getState().equals(PUBLISHER1_STATE)) {
                    logger.log(System.Logger.Level.TRACE, "Test Passed");
                    break block6;
                }
                throw new Exception("Publisher1's name and state were not persisted as expected -- metadata-complete=true is not read from orm.xml");
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testMetadataCompleteness" + e);
            }
            finally {
                this.getEntityManager().remove((Object)book);
                this.getEntityTransaction().commit();
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BOOK").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM COMPLAINT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM MOVIETICKET").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BOOKSTORE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

