/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.entitylistener;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.entitylistener.NoEntityListener;
import ee.jakarta.tck.persistence.core.override.entitylistener.NoListener;
import ee.jakarta.tck.persistence.core.override.entitylistener.OverridenListener;
import ee.jakarta.tck.persistence.core.override.util.CallBackCounts;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final Long ID = 1L;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFiles = new String[]{"orm.xml"};
        String[] classes = new String[]{pkgName + "ListenerA", pkgName + "ListenerB", pkgName + "ListenerC", pkgName + "ListenerD", pkgName + "NoEntityListener", pkgName + "NoListener", pkgName + "OverridenListener"};
        return this.createDeploymentJar("jpa_core_override_entitylistener.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void testOverrideEntityListener() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CallBackCounts.clearCountsMap();
        OverridenListener entity = new OverridenListener();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        logger.log(System.Logger.Level.TRACE, "persisted entity" + entity);
        this.getEntityManager().remove((Object)entity);
        this.getEntityManager().flush();
        logger.log(System.Logger.Level.TRACE, "Removed entity" + entity);
        this.getEntityTransaction().commit();
        try {
            pass1 = this.checkPersistCallBacks();
            pass2 = this.checkRemoveCallBacks();
            if (pass1 && pass2) {
                logger.log(System.Logger.Level.TRACE, "testOverrideEntityListener Passed");
            } else {
                if (pass1) {
                    throw new Exception("Test failed while testing preremove and postremove methods in testOverrideEntityListener ");
                }
                if (pass2) {
                    throw new Exception("Test failed while testing prepersist and postpersist methods in testOverrideEntityListener ");
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing testOverrideEntityListener" + e);
        }
    }

    @Test
    public void testEntityListenerXML() throws Exception {
        block6: {
            boolean pass = false;
            CallBackCounts.clearCountsMap();
            NoEntityListener entity = new NoEntityListener();
            entity.setId(ID);
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "persisted entity" + entity);
            try {
                pass = this.checkPersistCallBacks();
                if (pass) {
                    logger.log(System.Logger.Level.TRACE, "Test Passed");
                    break block6;
                }
                throw new Exception("TestEntityListenerXML method failed");
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testEntityListenerXML" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    @Test
    public void testNoEntityListener() throws Exception {
        block6: {
            boolean pass = false;
            CallBackCounts.clearCountsMap();
            NoListener entity = new NoListener();
            entity.setId(ID);
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)entity);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "persisted entity" + entity);
            try {
                pass = this.checkPersistCallBacks();
                if (pass) {
                    logger.log(System.Logger.Level.TRACE, "Test Passed");
                    break block6;
                }
                throw new Exception("TestNoEntityListener method failed");
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNoEntityListener" + e);
            }
            finally {
                this.getEntityManager().remove((Object)entity);
                this.getEntityTransaction().commit();
            }
        }
    }

    private boolean checkPersistCallBacks() throws Exception {
        boolean result = false;
        if (this.test("prePersist", 1) && this.test("postPersist", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkRemoveCallBacks() throws Exception {
        boolean result = false;
        if (this.test("preRemove", 1) && this.test("preRemove", 1)) {
            result = true;
        }
        return result;
    }

    private boolean test(String callBackName, int expectedCount) throws Exception {
        int count = CallBackCounts.getCount(callBackName);
        boolean result = false;
        if (count == expectedCount) {
            logger.log(System.Logger.Level.TRACE, "test passed" + callBackName);
            result = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "test failed" + callBackName);
        }
        return result;
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

