/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.flushmode;

import ee.jakarta.tck.persistence.common.schema30.CreditCard;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Spouse;
import ee.jakarta.tck.persistence.common.schema30.UtilOrderData;
import jakarta.persistence.FlushModeType;
import java.util.List;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client2
extends UtilOrderData {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_query_flushmode2.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void flushModeTest2() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute Starting flushModeTest2");
            Order o1 = (Order)this.getEntityManager().find(Order.class, (Object)"1");
            Customer cust2 = (Customer)this.getEntityManager().find(Customer.class, (Object)"2");
            o1.setCustomer(cust2);
            List result = this.getEntityManager().createQuery("SELECT o FROM Order o WHERE o.customer.name = 'Arthur D. Frechette'").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{"1", "2"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexception: " + e);
        }
        if (!pass) {
            throw new Exception("flushModeTest2 failed");
        }
    }

    @Test
    public void flushModeTest3() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute Starting flushModeTest3");
            Customer cust1 = (Customer)this.getEntityManager().find(Customer.class, (Object)"1");
            cust1.setName("Michael Bouschen");
            List o = this.getEntityManager().createQuery("SELECT o FROM Order o WHERE o.customer.name = 'Michael Bouschen'").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + o.size());
            } else {
                Customer newCust = (Customer)this.getEntityManager().find(Customer.class, (Object)"1");
                if (newCust.getName().equals("Michael Bouschen")) {
                    pass = true;
                }
                logger.log(System.Logger.Level.TRACE, "Expected results received");
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexception: " + e);
        }
        if (!pass) {
            throw new Exception("flushModeTest3 failed");
        }
    }

    @Test
    public void flushModeTest4() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute Starting flushModeTest4");
            Customer cust6 = (Customer)this.getEntityManager().find(Customer.class, (Object)"6");
            Spouse s4 = (Spouse)this.getEntityManager().find(Spouse.class, (Object)"4");
            cust6.setSpouse(s4);
            this.getEntityManager().merge((Object)cust6);
            s4.setCustomer(cust6);
            this.getEntityManager().merge((Object)s4);
            List result = this.getEntityManager().createQuery("SELECT o FROM Order o WHERE o.customer.spouse.lastName = 'Mullen'").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected  2 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexception: " + e);
        }
        if (!pass) {
            throw new Exception("flushModeTest4 failed");
        }
    }

    @Test
    public void flushModeTest5() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Starting flushModeTest5");
            Spouse s4 = (Spouse)this.getEntityManager().find(Spouse.class, (Object)"4");
            s4.setLastName("Miller");
            List result = this.getEntityManager().createQuery("SELECT o FROM Order o WHERE o.customer.spouse.lastName = 'Miller'").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{"11"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected  1 reference, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexception: " + e);
        }
        if (!pass) {
            throw new Exception("flushModeTest5 failed");
        }
    }

    @Test
    public void flushModeTest6() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Starting flushModeTest6");
            Customer cust4 = (Customer)this.getEntityManager().find(Customer.class, (Object)"4");
            Order order4 = (Order)this.getEntityManager().find(Order.class, (Object)"4");
            Order order9 = (Order)this.getEntityManager().find(Order.class, (Object)"9");
            order9.setCustomer(cust4);
            this.getEntityManager().merge((Object)order9);
            order4.setCustomer(null);
            this.getEntityManager().merge((Object)order4);
            Vector<Order> orders = new Vector<Order>();
            orders.add(order9);
            cust4.setOrders(orders);
            this.getEntityManager().merge((Object)cust4);
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c JOIN c.orders o where o.id = '4' ").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected  0 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("flushModeTest6 failed");
        }
    }

    @Test
    public void flushModeTest7() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{"2"};
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Starting flushModeTest7");
            CreditCard c17 = (CreditCard)this.getEntityManager().find(CreditCard.class, (Object)"17");
            c17.setNumber("1111-1111-1111-1111");
            List result = this.getEntityManager().createQuery("SELECT s FROM Spouse s JOIN s.customer c JOIN c.orders o WHERE o.creditCard.number = '1111-1111-1111-1111'").setFlushMode(FlushModeType.AUTO).getResultList();
            if (!this.checkEntityPK(result, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + expected.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("flushModeTest7 failed");
        }
    }
}

