/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.field;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.types.common.Grade;
import ee.jakarta.tck.persistence.core.types.field.DataTypes;
import ee.jakarta.tck.persistence.core.types.field.DataTypes2;
import ee.jakarta.tck.persistence.core.types.field.UUIDType;
import jakarta.persistence.Query;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private DataTypes d1;
    private DataTypes2 d2;
    private final java.util.Date dateId = this.getPKDate(2006, 4, 15);
    private final Date dateValue = this.getSQLDate(2006, 4, 15);

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", pkgName + "UUIDType"};
        return this.createDeploymentJar("jpa_core_types_field.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void fieldTypeTest1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (!this.d1.getBooleanData()) {
                    this.d1.setBooleanData(true);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getBooleanData()) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest2() throws Exception {
        boolean pass = false;
        int newByte = 111;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getByteData() == 100) {
                    this.d1.setByteData((byte)111);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getByteData() == 111) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest3() throws Exception {
        boolean pass = false;
        int newChar = 98;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getCharacterData() == 'a') {
                    this.d1.setCharacterData('b');
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getCharacterData() == 'b') {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest4() throws Exception {
        boolean pass = false;
        int newShort = 101;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getShortData() == 100) {
                    this.d1.setShortData((short)101);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getShortData() == 101) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest5() throws Exception {
        boolean pass = false;
        int newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getIntData() == 300) {
                    this.d1.setIntData(500);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getIntData() == 500) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest6() throws Exception {
        boolean pass = false;
        long newLong = 600L;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getLongData() == 600L) {
                    this.d1.setLongData(600L);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getLongData() == 600L) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest7() throws Exception {
        boolean pass = false;
        double newDbl = 80.0;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getDoubleData() == 50.0) {
                    this.d1.setDoubleData(80.0);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getDoubleData() == 80.0) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest8() throws Exception {
        boolean pass = false;
        float expFloat = 1.0f;
        float floatRange = 2.0f;
        float newFloat = 6.0f;
        float newfloatRange = 7.0f;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                logger.log(System.Logger.Level.TRACE, "float value is: " + this.d1.getFloatData());
                if (this.d1.getFloatData() >= 1.0f && this.d1.getFloatData() < 2.0f) {
                    this.d1.setFloatData(6.0f);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getFloatData() >= 6.0f && this.d1.getFloatData() < 7.0f) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest8 failed");
        }
    }

    @Test
    public void fieldTypeTest9() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "FIND D1");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                logger.log(System.Logger.Level.TRACE, "DataTypes is not null, setting enumData");
                this.d1.setEnumData(Grade.B);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "Update performed, check results");
                if (this.d1.getEnumData().equals((Object)Grade.B)) {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results received");
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest9 failed");
        }
    }

    @Test
    public void fieldTypeTest10() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "FIND D2");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                if (this.d2.getId().equals(this.dateId)) {
                    logger.log(System.Logger.Level.TRACE, "Got expected PK of:" + this.d2.getId() + "received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + this.dateId + ", got: " + this.d2.getId());
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest11() throws Exception {
        boolean pass = false;
        byte[] b = new byte[]{31, 32, 33, 63, 64, 65};
        int bv = 5;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "FIND D1");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting byteData ");
                this.d1.setByteArrayData(b);
                byte[] a = this.d1.getByteArrayData();
                a[0] = (byte)(a[0] + 5);
                this.d1.setByteArrayData(b);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (Arrays.equals(this.d1.getByteArrayData(), a)) {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Unexpected result in array comparison.");
                    for (byte aa : a) {
                        logger.log(System.Logger.Level.TRACE, "Array a in propertyTest9 equals: " + aa);
                    }
                    for (byte bb : b) {
                        logger.log(System.Logger.Level.TRACE, "Array b in propertyTest9 equals: " + bb);
                    }
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest12() throws Exception {
        boolean pass = false;
        char[] charData = new char[]{'c', 't', 's'};
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "FIND D1");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting charData ");
                this.d1.setCharArrayData(charData);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (Arrays.equals(this.d1.getCharArrayData(), charData)) {
                    logger.log(System.Logger.Level.TRACE, "Expected Results Received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + Arrays.toString(charData) + ", got: " + Arrays.toString(this.d1.getCharArrayData()));
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest12 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest13() throws Exception {
        boolean pass = false;
        Time timeValue = this.getTimeData(18, 30, 15);
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "FIND D2");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting TimeData ");
                this.d2.setTimeData(timeValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                if (this.d2.getTimeData().equals(timeValue)) {
                    logger.log(System.Logger.Level.TRACE, "Expected Time Received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + timeValue + " , got: " + this.d2.getTimeData());
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest13 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest14() throws Exception {
        boolean pass = false;
        Timestamp tsValue = this.getTimestampData(2006, 2, 11);
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "FIND D2");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting TimestampData ");
                this.d2.setTsData(tsValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                if (this.d2.getTsData().equals(tsValue)) {
                    logger.log(System.Logger.Level.TRACE, "Expected Timestamp Received");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + tsValue + " , got: " + this.d2.getTsData());
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest14 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest15() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = ee.jakarta.tck.persistence.core.types.common.Grade.A");
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1 == result) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest15 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest16() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = :grade").setParameter("grade", (Object)Grade.A);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1 == result) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest16 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fieldTypeTest17() throws Exception {
        boolean pass = false;
        Grade failingGrade = Grade.F;
        Grade incompleteGrade = Grade.INCOMPLETE;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.C);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE (dt.enumData <> ?1) OR (dt.enumData <> ?2) ").setParameter(1, (Object)failingGrade).setParameter(2, (Object)incompleteGrade);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1 == result) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest17 failed");
        }
    }

    @Test
    public void testCreateUUIDType() throws Exception {
        UUID id = UUID.randomUUID();
        UUIDType uuidType = new UUIDType(id, "Create UUID Type");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)uuidType);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.getEntityManager().clear();
            UUIDType fromDb = (UUIDType)this.getEntityManager().find(UUIDType.class, (Object)id);
            System.out.println("UUID: " + fromDb.getId().toString());
            if (fromDb == null) {
                throw new Exception("testCreateUUIDType: no UUID was found in database");
            }
            if (!id.equals(fromDb.getId())) {
                throw new Exception("testCreateUUIDType: UUID returned from database " + fromDb.getId() + " does not match expected value " + id);
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)ex);
            throw new Exception("Caught exception: ", ex);
        }
        finally {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
    }

    @Test
    public void scalarExpressionsTest() throws Exception {
        DataTypes d;
        List p;
        char expected;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            expected = this.d1.getIntData() + 1;
            logger.log(System.Logger.Level.TRACE, "Testing arithmetic expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where ((d.intData + 1) = ?1)").setParameter(1, (Object)expected).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                logger.log(System.Logger.Level.TRACE, "DataType:" + d.toString());
                int actual = d.getIntData() + 1;
                if (actual == expected) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Integer data:" + actual);
                    pass1 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected result, Expected: " + expected + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            expected = 'a';
            logger.log(System.Logger.Level.TRACE, "Testing string expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.characterData = ?1)").setParameter(1, (Object)Character.valueOf(expected)).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                logger.log(System.Logger.Level.TRACE, "DataType:" + d.toString());
                Character actual = Character.valueOf(d.getCharacterData());
                if (actual.equals(Character.valueOf(expected))) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Character data:" + actual);
                    pass2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected result, Expected: " + expected + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            Grade expected2 = Grade.C;
            logger.log(System.Logger.Level.TRACE, "Testing enum expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.enumData = ?1)").setParameter(1, (Object)expected2).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                logger.log(System.Logger.Level.TRACE, "DataType:" + d.toString());
                Grade actual = d.getEnumData();
                if (actual.equals((Object)expected2)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Enum data:" + actual);
                    pass3 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected result, Expected: " + expected2 + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            java.util.Date dateValue = this.getPKDate(2006, 1, 1);
            java.util.Date expected3 = this.dateId;
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Testing datetime expression:");
            List pp = this.getEntityManager().createQuery("Select d From DataTypes2 d where (d.dateData > ?1)").setParameter(1, (Object)dateValue).getResultList();
            if (pp.size() == 1) {
                DataTypes2 d2 = (DataTypes2)pp.get(0);
                logger.log(System.Logger.Level.TRACE, "DataType2:" + d2.toString());
                java.util.Date actual = d2.getDateData();
                if (actual.equals(expected3)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Date data:" + actual);
                    pass4 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected result, Expected: " + expected3 + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected number of results, expected:1, actual:" + pp.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            boolean expected4 = false;
            logger.log(System.Logger.Level.TRACE, "Testing boolean expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.booleanData = ?1)").setParameter(1, (Object)expected4).getResultList();
            if (p.size() > 0) {
                d = (DataTypes)p.get(0);
                logger.log(System.Logger.Level.TRACE, "DataType:" + d.toString());
                Boolean actual = d.getBooleanData();
                if (actual.equals(expected4)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Boolean data:" + actual);
                    pass5 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected result, Expected: " + expected4 + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("scalarExpressionsTest failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            char[] cArray = new char[]{'a'};
            byte[] bArray = new byte[]{100};
            this.d1 = new DataTypes(1, false, 100, 'a', 100, 300, 600L, 50.0, 1.0f, cArray, bArray);
            this.d1.setEnumData(Grade.C);
            logger.log(System.Logger.Level.TRACE, "dateId is: " + this.dateId);
            this.d2 = new DataTypes2(this.dateId);
            this.d2.setDateData(this.dateValue);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UUIDTYPE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

