/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.schemaGeneration.annotations.joinTable;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.schemaGeneration.annotations.joinTable.Course;
import ee.jakarta.tck.persistence.se.schemaGeneration.annotations.joinTable.Student;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 22L;
    String schemaGenerationDir = null;
    String sTestCase = "jpa_se_schemaGeneration_annotations_joinTable";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Course", pkgName + "Student"};
        return this.createDeploymentJar("jpa_se_schemaGeneration_annotations_joinTable.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.schemaGenerationDir = System.getProperty("user.dir");
            if (!this.schemaGenerationDir.endsWith(File.separator)) {
                this.schemaGenerationDir = this.schemaGenerationDir + File.separator;
            }
            this.schemaGenerationDir = this.schemaGenerationDir + "schemaGeneration";
            logger.log(System.Logger.Level.INFO, "schemaGenerationDir=" + this.schemaGenerationDir);
            File f = new File(this.schemaGenerationDir);
            logger.log(System.Logger.Level.INFO, "Delete existing directory ");
            this.deleteItem(f);
            logger.log(System.Logger.Level.INFO, "Create new directory ");
            if (!f.mkdir()) {
                String msg = "Could not mkdir:" + f.getAbsolutePath();
                throw new Exception(msg);
            }
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void joinTableTest() throws Exception {
        boolean pass1a = false;
        boolean pass1b = false;
        boolean pass1c = false;
        boolean pass1d = false;
        boolean pass1e = false;
        boolean pass2a = false;
        boolean pass2b = false;
        boolean pass2c = false;
        boolean pass2d = false;
        boolean pass2e = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = new File(CREATEFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
        this.deleteItem(f1);
        File f2 = new File(DROPFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
        this.deleteItem(f2);
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", this.convertToURI(CREATEFILENAME));
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("CREATE TABLE SCHEMAGENCOURSE");
        expected.add("COURSEID");
        expected.add("COURSENAME");
        expected.add("PRIMARY KEY (COURSEID)");
        pass1a = this.findDataInFile(f1, expected);
        expected.clear();
        expected.add("CREATE TABLE SCHEMAGENSTUDENT");
        expected.add("STUDENTID");
        expected.add("STUDENTNAME");
        expected.add("PRIMARY KEY (STUDENTID)");
        pass1b = this.findDataInFile(f1, expected);
        expected.clear();
        expected.add("CREATE TABLE SCHEMAGEN_COURSE_STUDENT");
        expected.add("COURSE_ID");
        expected.add("STUDENT_ID");
        pass1c = this.findDataInFile(f1, expected);
        expected.clear();
        expected.add("ALTER TABLE");
        expected.add("SCHEMAGEN_COURSE_STUDENT ADD");
        expected.add("CONSTRAINT STUDENTIDCONSTRAINT");
        expected.add("SCHEMAGENSTUDENT");
        pass1d = this.findDataInFile(f1, expected);
        expected.clear();
        expected.add("ALTER TABLE");
        expected.add("SCHEMAGEN_COURSE_STUDENT ADD");
        expected.add("CONSTRAINT COURSEIDCONSTRAINT");
        expected.add("SCHEMAGENCOURSE");
        pass1e = this.findDataInFile(f1, expected);
        pass2a = this.findDataInFile(f2, List.of("ALTER TABLE", "SCHEMAGEN_COURSE_STUDENT DROP", "STUDENTIDCONSTRAINT"));
        pass2a = pass2a || this.findDataInFile(f2, List.of("DROP TABLE", "SCHEMAGEN_COURSE_STUDENT", "CASCADE CONSTRAINTS"));
        pass2b = this.findDataInFile(f2, List.of("ALTER TABLE", "SCHEMAGEN_COURSE_STUDENT DROP", "COURSEIDCONSTRAINT"));
        pass2b = pass2b || this.findDataInFile(f2, List.of("DROP TABLE", "SCHEMAGEN_COURSE_STUDENT", "CASCADE CONSTRAINTS"));
        expected.clear();
        expected.add("DROP TABLE");
        expected.add("SCHEMAGEN_COURSE_STUDENT");
        pass2c = this.findDataInFile(f2, expected);
        expected.clear();
        expected.add("DROP TABLE");
        expected.add("SCHEMAGENCOURSE");
        pass2d = this.findDataInFile(f2, expected);
        expected.clear();
        expected.add("DROP TABLE");
        expected.add("SCHEMAGENSTUDENT");
        pass2e = this.findDataInFile(f2, expected);
        logger.log(System.Logger.Level.TRACE, "Execute the create script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.create-script-source", this.convertToURI(CREATEFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Student expectedStudent = new Student(1, "Neo");
            Course appliedMath = new Course(101, "AppliedMathematics");
            Course physics = new Course(102, "Physics");
            ArrayList<Student> studentList = new ArrayList<Student>();
            studentList.add(expectedStudent);
            appliedMath.setStudents(studentList);
            physics.setStudents(studentList);
            ArrayList<Course> firstSemCourses = new ArrayList<Course>();
            firstSemCourses.add(appliedMath);
            firstSemCourses.add(physics);
            expectedStudent.setCourses(firstSemCourses);
            this.getEntityManager().persist((Object)expectedStudent);
            this.getEntityManager().persist((Object)appliedMath);
            this.getEntityManager().persist((Object)physics);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            Course course = (Course)this.getEntityManager().find(Course.class, (Object)101);
            if (course != null) {
                if (course.courseName.equals(appliedMath.courseName)) {
                    if (course.getStudents().size() == 1) {
                        Student s1 = course.getStudents().get(0);
                        if (expectedStudent.equals(s1)) {
                            logger.log(System.Logger.Level.TRACE, "Received expected result:" + s1);
                            pass3 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected:" + expectedStudent.toString());
                            logger.log(System.Logger.Level.ERROR, "Actual:" + s1.toString());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get list of students of size 1, actual:" + course.getStudents().size());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected Course:" + appliedMath.courseName);
                    logger.log(System.Logger.Level.ERROR, "Actual Course:" + course.courseName);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Received null result from find");
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        this.clearEMAndEMF();
        logger.log(System.Logger.Level.TRACE, "Execute the drop script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.drop-script-source", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        logger.log(System.Logger.Level.INFO, "Try to persist an entity, it should fail");
        try {
            this.getEntityTransaction(true).begin();
            Student joe = new Student(2, "Joe");
            this.getEntityManager().persist((Object)joe);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "An exception should have been thrown if drop had occurred successfully");
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.TRACE, "Receive expected exception");
            pass4 = true;
        }
        try {
            this.getEntityTransaction(true).begin();
            Course accounting = new Course(303, "Accounting");
            this.getEntityManager().persist((Object)accounting);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "An exception should have been thrown if drop had occurred successfully");
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.TRACE, "Receive expected exception");
            pass5 = true;
        }
        logger.log(System.Logger.Level.TRACE, "pass1a:" + pass1a);
        logger.log(System.Logger.Level.TRACE, "pass1b:" + pass1b);
        logger.log(System.Logger.Level.TRACE, "pass1c:" + pass1c);
        logger.log(System.Logger.Level.TRACE, "pass1d:" + pass1d);
        logger.log(System.Logger.Level.TRACE, "pass1e:" + pass1e);
        logger.log(System.Logger.Level.TRACE, "pass2a:" + pass2a);
        logger.log(System.Logger.Level.TRACE, "pass2b:" + pass2b);
        logger.log(System.Logger.Level.TRACE, "pass2c:" + pass2c);
        logger.log(System.Logger.Level.TRACE, "pass2d:" + pass2d);
        logger.log(System.Logger.Level.TRACE, "pass2e:" + pass2e);
        logger.log(System.Logger.Level.TRACE, "pass3:" + pass3);
        logger.log(System.Logger.Level.TRACE, "pass4:" + pass4);
        logger.log(System.Logger.Level.TRACE, "pass5:" + pass5);
        if (!(pass1a && pass1b && pass1c && pass1d && pass1e && pass2a && pass2b && pass2c && pass2d && pass2e && pass3 && pass4 && pass5)) {
            throw new Exception("joinTableTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Try to drop table SCHEMAGENSIMPLE");
            this.getEntityManager().createNativeQuery("DROP TABLE SCHEMAGENCOURSE").executeUpdate();
            this.getEntityManager().createNativeQuery("DROP TABLE SCHEMAGENSTUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DROP TABLE SCHEMAGEN_COURSE_STUDENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.INFO, "AN EXCEPTION WAS THROWN DURING DROPS, IT MAY OR MAY NOT BE A PROBLEM, " + t.getMessage());
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
                this.clearEntityTransaction();
                this.clearEMAndEMF();
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

