/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common;

import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManager;
import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManagerFactory;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class PMClientBase
implements UseEntityManager,
UseEntityManagerFactory,
Serializable {
    private static final System.Logger logger = System.getLogger(PMClientBase.class.getName());
    protected Properties myProps = new Properties();
    private transient EntityManager em;
    private transient EntityTransaction et;
    private transient boolean inContainer;
    private transient boolean testArtifactDeployed = false;
    private transient EntityManagerFactory emf;
    EntityManagerFactory jakartaEEemf;
    public boolean cachingSupported = true;
    public static final transient String PROVIDER_PROP = "jakarta.persistence.provider";
    public static final transient String TRANSACTION_TYPE_PROP = "jakarta.persistence.transactionType";
    public static final transient String JTA_DATASOURCE_PROP = "jakarta.persistence.jtaDataSource";
    public static final transient String NON_JTA_DATASOURCE_PROP = "jakarta.persistence.nonJtaDataSource";
    public static final transient String RESOURCE_LOCAL = "RESOURCE_LOCAL";
    public static final transient String MODE_PROP = "platform.mode";
    public static final transient String JAVAEE_MODE = "jakartaEE";
    public static final transient String STANDALONE_MODE = "standalone";
    public static final transient String PERSISTENCE_UNIT_NAME_PROP = "persistence.unit.name";
    public static final transient String SECOND_PERSISTENCE_UNIT_NAME_PROP = "persistence.unit.name.2";
    public static final transient String JAVAX_PERSISTENCE_PROVIDER = "jakarta.persistence.provider";
    public static final transient String JAVAX_PERSISTENCE_JDBC_DRIVER = "jakarta.persistence.jdbc.driver";
    public static final transient String JAVAX_PERSISTENCE_JDBC_URL = "jakarta.persistence.jdbc.url";
    public static final transient String JAVAX_PERSISTENCE_JDBC_USER = "jakarta.persistence.jdbc.user";
    public static final transient String JAVAX_PERSISTENCE_JDBC_PASSWORD = "jakarta.persistence.jdbc.password";
    public static final transient String JPA_PROVIDER_IMPLEMENTATION_SPECIFIC_PROPERTIES = "jpa.provider.implementation.specific.properties";
    public static final transient String PERSISTENCE_SECOND_LEVEL_CACHING_SUPPORTED = "persistence.second.level.caching.supported";
    private transient String mode;
    private String persistenceUnitName;
    protected String secondPersistenceUnitName;
    public static final String STANDALONE_PERSISTENCE_XML = "ee/jakarta/tck/persistence/common/template/standalone/persistence.xml";
    public static final String EE_PERSISTENCE_XML = "ee/jakarta/tck/persistence/common/template/persistence.xml";
    public static final String PERSISTENCE_ELEMENT_TAG = "persistence-unit";
    public static final String CLASS_ELEMENT_TAG = "class";
    public static final String MAPPING_ELEMENT_TAG = "mapping-file";
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static final String PERSISTENCE_XML = "persistence.xml";
    public static final String ORM_XML = "orm.xml";
    public static final String MAPPING_FILE_XML = "myMappingFile.xml";

    protected PMClientBase() {
    }

    protected void removeEntity(Object o) {
        if (o != null) {
            try {
                this.getEntityManager().remove(o);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "removeEntity: Exception caught when removing entity: ", (Throwable)e);
            }
        }
    }

    public String getPersistenceUnitName() {
        logger.log(System.Logger.Level.TRACE, "getPersistenceUnitName() - Persistence Unit Name:" + this.persistenceUnitName);
        return this.persistenceUnitName;
    }

    public String getSecondPersistenceUnitName() {
        logger.log(System.Logger.Level.TRACE, "getSecondPersistenceUnitName() - Second Persistence Unit Name:" + this.secondPersistenceUnitName);
        return this.secondPersistenceUnitName;
    }

    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "PMClientBase.setup");
        this.mode = System.getProperty(MODE_PROP);
        this.myProps.put(MODE_PROP, this.mode);
        this.persistenceUnitName = System.getProperty(PERSISTENCE_UNIT_NAME_PROP);
        this.myProps.put(PERSISTENCE_UNIT_NAME_PROP, this.persistenceUnitName);
        logger.log(System.Logger.Level.TRACE, "Persistence Unit Name =" + this.persistenceUnitName);
        this.secondPersistenceUnitName = System.getProperty(SECOND_PERSISTENCE_UNIT_NAME_PROP);
        this.myProps.put(SECOND_PERSISTENCE_UNIT_NAME_PROP, this.secondPersistenceUnitName);
        logger.log(System.Logger.Level.TRACE, "Second Persistence Unit Name =" + this.secondPersistenceUnitName);
        this.myProps.put("jakarta.persistence.provider", System.getProperty("jakarta.persistence.provider"));
        this.myProps.put(JAVAX_PERSISTENCE_JDBC_DRIVER, System.getProperty(JAVAX_PERSISTENCE_JDBC_DRIVER));
        this.myProps.put(JAVAX_PERSISTENCE_JDBC_URL, System.getProperty(JAVAX_PERSISTENCE_JDBC_URL));
        this.myProps.put(JAVAX_PERSISTENCE_JDBC_USER, System.getProperty(JAVAX_PERSISTENCE_JDBC_USER));
        this.myProps.put(JAVAX_PERSISTENCE_JDBC_PASSWORD, System.getProperty(JAVAX_PERSISTENCE_JDBC_PASSWORD));
        this.myProps.put(JPA_PROVIDER_IMPLEMENTATION_SPECIFIC_PROPERTIES, System.getProperty(JPA_PROVIDER_IMPLEMENTATION_SPECIFIC_PROPERTIES));
        this.myProps.put(PERSISTENCE_SECOND_LEVEL_CACHING_SUPPORTED, System.getProperty(PERSISTENCE_SECOND_LEVEL_CACHING_SUPPORTED));
        if (JAVAEE_MODE.equalsIgnoreCase(this.mode)) {
            logger.log(System.Logger.Level.TRACE, "platform.mode is set to " + this.mode + ", so tests are running in JakartaEE environment.");
        } else if (STANDALONE_MODE.equalsIgnoreCase(this.mode)) {
            logger.log(System.Logger.Level.TRACE, "platform.mode is set to " + this.mode + ", so tests are running in J2SE environment standalone mode.persistence.unit.name is set to " + this.persistenceUnitName);
        } else {
            logger.log(System.Logger.Level.INFO, "WARNING: platform.mode is set to " + this.mode + ", an invalid value.");
        }
        this.cachingSupported = Boolean.parseBoolean(System.getProperty(PERSISTENCE_SECOND_LEVEL_CACHING_SUPPORTED, "true"));
    }

    public void displayProperties(Properties props) {
        logger.log(System.Logger.Level.INFO, "Current properties:");
        for (Object entry : props.keySet()) {
            if (props.get(entry) instanceof String) {
                logger.log(System.Logger.Level.TRACE, "Key:" + (String)entry + ", value:[" + props.get(entry) + "]");
                continue;
            }
            logger.log(System.Logger.Level.TRACE, "Key:" + (String)entry + ", value:" + props.get(entry).getClass().getSimpleName());
        }
    }

    public void cleanup() throws Exception {
        this.closeEMAndEMF();
    }

    public void cleanupNoSuper() throws Exception {
    }

    public void closeEMAndEMF() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Rolling back any existing transaction before closing EMF and EM if one exists.");
            if (this.getEntityTransaction(false) != null && this.getEntityTransaction(false).isActive()) {
                logger.log(System.Logger.Level.TRACE, "An active transaction was found, rolling it back.");
                this.getEntityTransaction(false).rollback();
            }
        }
        catch (Exception fe) {
            logger.log(System.Logger.Level.INFO, "Unexpected exception rolling back TX:", (Throwable)fe);
        }
        this.clearCache();
        if (this.isStandAloneMode()) {
            logger.log(System.Logger.Level.TRACE, "Closing EM and EMF");
            if (this.getEntityManager(false) != null && this.getEntityManager(false).isOpen()) {
                this.getEntityManager(false).close();
            }
            if (this.getEntityManagerFactory() != null && this.getEntityManagerFactory().isOpen()) {
                this.getEntityManagerFactory().close();
            }
        }
    }

    public void clearEMAndEMF() throws Exception {
        this.closeEMAndEMF();
        this.clearEntityManager();
        this.clearEntityManagerFactory();
    }

    public void clearEntityManager() {
        if (this.isStandAloneMode()) {
            this.em = null;
        }
    }

    public void clearEntityManagerFactory() {
        if (this.isStandAloneMode()) {
            this.emf = null;
        }
    }

    public void clearCache() throws Exception {
        if (this.cachingSupported) {
            if (this.getEntityManager() != null && this.getEntityManager().isOpen()) {
                if (this.getEntityManager().getEntityManagerFactory() != null && this.getEntityManager().getEntityManagerFactory().isOpen()) {
                    logger.log(System.Logger.Level.TRACE, "Clearing context");
                    this.getEntityManager().clear();
                    logger.log(System.Logger.Level.TRACE, "Trying to clear cache via call to EMF.getCache().evictAll().");
                    Cache cache = this.getEntityManager().getEntityManagerFactory().getCache();
                    if (cache != null) {
                        cache.evictAll();
                        logger.log(System.Logger.Level.TRACE, "EMF.getCache().evictAll() was executed.");
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Cache supported is true in ts.jte but getCache() is returning null");
                    }
                } else {
                    logger.log(System.Logger.Level.TRACE, "Clearing of cache did not occur because either EntityManagerFactory was null or closed");
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Clearing of cache did not occur because either EntityManager was null or closed");
            }
        } else {
            logger.log(System.Logger.Level.TRACE, "Clearing of cache did not occur because it is not supposed.");
        }
    }

    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.jakartaEEemf = emf;
    }

    public EntityManager getEntityManager() {
        return this.getEntityManager(false);
    }

    public EntityManager getEntityManager(boolean reInit) {
        if (!reInit) {
            if (this.em != null) {
                logger.log(System.Logger.Level.TRACE, "Using existing entity manager class:" + this.em.getClass().getName() + " isOpen:" + this.em.isOpen());
                return this.em;
            }
            logger.log(System.Logger.Level.TRACE, "getEntityManager: false was specified and EM is null");
        }
        logger.log(System.Logger.Level.TRACE, "Need to Initialize EntityManager");
        if (this.isStandAloneMode()) {
            this.initEntityManager(this.persistenceUnitName, true);
            logger.log(System.Logger.Level.TRACE, "EntityManager class:" + this.em.getClass().getName() + " isOpen:" + this.em.isOpen());
            return this.em;
        }
        throw new IllegalStateException("The test is running in JakartaEE environment, but PMClientBase.em has not been initialized from the vehicle component.");
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.isStandAloneMode()) {
            if (this.emf != null) {
                logger.log(System.Logger.Level.TRACE, "EntityManagerFactory class:" + this.emf.getClass().getName() + " isOpen:" + this.emf.isOpen());
            }
            return this.emf;
        }
        if (this.jakartaEEemf != null) {
            logger.log(System.Logger.Level.TRACE, "EntityManagerFactory class:" + this.jakartaEEemf.getClass().getName() + " isOpen:" + this.jakartaEEemf.isOpen());
        }
        return this.jakartaEEemf;
    }

    public void clearEntityTransaction() {
        this.et = null;
    }

    public void setEntityTransaction(EntityTransaction et) {
        this.et = et;
    }

    public EntityTransaction getEntityTransaction() {
        if (this.et != null) {
            logger.log(System.Logger.Level.TRACE, "Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            return this.et;
        }
        logger.log(System.Logger.Level.TRACE, "Need to get Transaction");
        if (this.isStandAloneMode()) {
            this.initEntityTransaction();
            if (this.et != null) {
                logger.log(System.Logger.Level.TRACE, "Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            }
            return this.et;
        }
        throw new IllegalStateException("The test is running in JakartaEE environment, but PMClientBase.et has not been initialized from the vehicle component.");
    }

    public EntityTransaction getEntityTransaction(boolean reInit, EntityManager em) {
        if (!reInit && this.et != null) {
            logger.log(System.Logger.Level.TRACE, "Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            return this.et;
        }
        if (this.isStandAloneMode()) {
            this.initEntityTransaction(em);
            if (this.et != null) {
                logger.log(System.Logger.Level.TRACE, "Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            }
            return this.et;
        }
        throw new IllegalStateException("The test is running in JakartaEE environment, but PMClientBase.et has not been initialized from the vehicle component.");
    }

    public EntityTransaction getEntityTransaction(boolean reInit) {
        if (!reInit && this.et != null) {
            logger.log(System.Logger.Level.TRACE, "Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            return this.et;
        }
        if (this.isStandAloneMode()) {
            this.initEntityTransaction();
            if (this.et != null) {
                logger.log(System.Logger.Level.TRACE, "Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            }
            return this.et;
        }
        throw new IllegalStateException("The test is running in JakartaEE environment, but PMClientBase.et has not been initialized from the vehicle component.");
    }

    protected void initEntityManager(String persistenceUnitName, boolean useProps) {
        if (this.isStandAloneMode()) {
            logger.log(System.Logger.Level.TRACE, "in initEntityManager(String, boolean): " + persistenceUnitName);
            if (useProps) {
                Properties propsMap = this.getPersistenceUnitProperties();
                logger.log(System.Logger.Level.TRACE, "createEntityManagerFactory(String,Map)");
                this.emf = Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)propsMap);
            } else {
                logger.log(System.Logger.Level.TRACE, "createEntityManagerFactory(String)");
                this.emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
            }
            Map emfMap = this.emf.getProperties();
            if (emfMap != null) {
                this.displayMap(emfMap);
            }
            this.em = this.emf.createEntityManager();
        } else {
            logger.log(System.Logger.Level.INFO, "The test is running in JakartaEE environment, the EntityManager is initialized in the vehicle component.");
        }
    }

    protected void initEntityTransaction() {
        EntityTransaction delegate;
        this.et = delegate = this.getEntityManager().getTransaction();
    }

    protected void initEntityTransaction(EntityManager em) {
        EntityTransaction delegate;
        this.et = delegate = em.getTransaction();
    }

    public boolean isInContainer() {
        return this.inContainer;
    }

    public void setInContainer(boolean inContainer) {
        this.inContainer = inContainer;
    }

    protected Properties getPersistenceUnitProperties() {
        Properties jpaProps = new Properties();
        jpaProps.put("jakarta.persistence.provider", this.myProps.get("jakarta.persistence.provider"));
        jpaProps.put(JAVAX_PERSISTENCE_JDBC_DRIVER, this.myProps.get(JAVAX_PERSISTENCE_JDBC_DRIVER));
        jpaProps.put(JAVAX_PERSISTENCE_JDBC_URL, this.myProps.get(JAVAX_PERSISTENCE_JDBC_URL));
        jpaProps.put(JAVAX_PERSISTENCE_JDBC_USER, this.myProps.get(JAVAX_PERSISTENCE_JDBC_USER));
        jpaProps.put(JAVAX_PERSISTENCE_JDBC_PASSWORD, this.myProps.get(JAVAX_PERSISTENCE_JDBC_PASSWORD));
        String provider_specific_props = (String)this.myProps.get(JPA_PROVIDER_IMPLEMENTATION_SPECIFIC_PROPERTIES);
        StringTokenizer st = new StringTokenizer(provider_specific_props, ":");
        while (st.hasMoreTokens()) {
            StringTokenizer st1 = new StringTokenizer(st.nextToken(), "=");
            String pspValue = null;
            String pspName = null;
            if (st1.hasMoreTokens()) {
                pspName = st1.nextToken();
            }
            if (st1.hasMoreTokens()) {
                pspValue = st1.nextToken();
            }
            jpaProps.put(pspName, pspValue);
        }
        this.checkPersistenceUnitProperties(jpaProps);
        return jpaProps;
    }

    public boolean isStandAloneMode() {
        return STANDALONE_MODE.equalsIgnoreCase(this.mode);
    }

    private void checkPersistenceUnitProperties(Properties jpaProps) {
        logger.log(System.Logger.Level.TRACE, "persistence unit properites from user: " + jpaProps.toString());
        String provider = jpaProps.getProperty("jakarta.persistence.provider");
        if (provider == null) {
            throw new IllegalStateException("jakarta.persistence.provider not specified in persistence unit properties file");
        }
        String transactionType = jpaProps.getProperty(TRANSACTION_TYPE_PROP);
        if (transactionType != null && !RESOURCE_LOCAL.equals(transactionType)) {
            throw new IllegalStateException("jakarta.persistence.transactionType is set to an unsupported value: " + transactionType + ".  The only portably supported type is RESOURCE_LOCAL.  Please correct it in persistence unit properties file.");
        }
        String jtaDataSource = jpaProps.getProperty(JTA_DATASOURCE_PROP);
        if (jtaDataSource != null) {
            logger.log(System.Logger.Level.INFO, "WARNING: jakarta.persistence.jtaDataSource is specified as " + jtaDataSource + ", and it will be passed to the persistence provider.  However, this is in general not supported in Java SE environment");
        }
        logger.log(System.Logger.Level.TRACE, "persistence unit properites verified: " + jpaProps.toString());
    }

    public Calendar getCalDate() {
        return Calendar.getInstance();
    }

    public Calendar getCalDate(int yy, int mm, int dd) {
        GregorianCalendar cal = new GregorianCalendar(yy, mm, dd);
        logger.log(System.Logger.Level.TRACE, "returning date:" + cal);
        return cal;
    }

    public Date getSQLDate(String sDate) {
        Date d = Date.valueOf(sDate);
        logger.log(System.Logger.Level.TRACE, "returning date:" + d);
        return d;
    }

    public Date getSQLDate(int yy, int mm, int dd) {
        Calendar newCal = this.getCalDate();
        newCal.clear();
        newCal.set(yy, mm, dd);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(newCal.getTime());
        logger.log(System.Logger.Level.TRACE, "returning date:" + Date.valueOf(sDate));
        return Date.valueOf(sDate);
    }

    public Date getSQLDate() {
        Calendar calDate = this.getCalDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(calDate.getTime());
        Date d = Date.valueOf(sDate);
        logger.log(System.Logger.Level.TRACE, "returning date:" + d);
        return d;
    }

    public java.util.Date getUtilDate() {
        java.util.Date d = new java.util.Date();
        logger.log(System.Logger.Level.TRACE, "getPKDate: returning date:" + d);
        return d;
    }

    public java.util.Date getUtilDate(String sDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date d = null;
        try {
            d = formatter.parse(sDate);
        }
        catch (ParseException pe) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:" + pe);
        }
        logger.log(System.Logger.Level.TRACE, "getPKDate: returning date:" + d);
        return d;
    }

    public Time getTimeData(String sTime) {
        Time t = Time.valueOf(sTime);
        logger.log(System.Logger.Level.TRACE, "getTimeData: returning Time:" + t);
        return t;
    }

    public Time getTimeData(int hh, int mm, int ss) {
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(hh, mm, ss);
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss");
        String sDate = sdf.format(newCal.getTime());
        logger.log(System.Logger.Level.TRACE, "getTimeData: returning Time:" + Time.valueOf(sDate));
        return Time.valueOf(sDate);
    }

    public Timestamp getTimestampData(String sDate) {
        String tFormat = sDate + " 10:10:10";
        Timestamp ts = Timestamp.valueOf(tFormat);
        logger.log(System.Logger.Level.TRACE, "getTimestampData: returning TimeStamp:" + ts);
        return ts;
    }

    public Timestamp getTimestampData(int yy, int mm, int dd) {
        logger.log(System.Logger.Level.TRACE, "Entering getTimestampData");
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(yy, mm, dd);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = sdf.format(newCal.getTime());
        logger.log(System.Logger.Level.TRACE, "getTimestampData: returning TimeStamp:" + Timestamp.valueOf(sDate));
        return Timestamp.valueOf(sDate);
    }

    public java.util.Date getPKDate(int yy, int mm, int dd) {
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(yy, mm, dd);
        logger.log(System.Logger.Level.TRACE, "getPKDate: returning date:" + newCal.getTime());
        return newCal.getTime();
    }

    public void doFlush() throws PersistenceException {
        try {
            this.getEntityManager().flush();
        }
        catch (PersistenceException pe) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception caught while flushing: ", (Throwable)pe);
            throw new PersistenceException("Unexpected Exception caught while flushing: " + pe);
        }
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Collection<T> expectedPKS) {
        logger.log(System.Logger.Level.TRACE, "PMClientBase.checkEntityPK(Collection<T>,Collection<T>)");
        return this.checkEntityPK(actualPKS, expectedPKS, false);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Collection<T> expectedPKS, boolean allowDups) {
        Integer[] epks2 = new Integer[expectedPKS.size()];
        logger.log(System.Logger.Level.TRACE, "PMClientBase.checkEntityPK(Collection<T>,Collection<T>, boolean)");
        if (expectedPKS.size() != 0) {
            int i = 0;
            Iterator<T> iterator = expectedPKS.iterator();
            while (iterator.hasNext()) {
                T o;
                T ref = o = iterator.next();
                try {
                    if (ref instanceof Integer) {
                        epks2[i++] = (Integer)ref;
                        continue;
                    }
                    if (ref instanceof String) {
                        epks2[i++] = Integer.valueOf((String)ref);
                        continue;
                    }
                    Method m = ref.getClass().getMethod("getId", new Class[0]);
                    Object oo = m.invoke(ref, new Object[0]);
                    if (oo instanceof String) {
                        epks2[i++] = Integer.valueOf((String)oo);
                        continue;
                    }
                    epks2[i++] = (Integer)oo;
                }
                catch (NoSuchMethodException nsme) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception thrown", (Throwable)nsme);
                }
                catch (IllegalAccessException iae) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception thrown", (Throwable)iae);
                }
                catch (InvocationTargetException ite) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception thrown", (Throwable)ite);
                }
            }
        }
        return this.checkEntityPK(actualPKS, epks2, allowDups, true);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, String[] expectedPKS) {
        logger.log(System.Logger.Level.TRACE, "PMClientBase.checkEntityPK(Collection<T>,String[])");
        return this.checkEntityPK(actualPKS, expectedPKS, false);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, String[] expectedPKS, boolean allowDups) {
        Integer[] epks2 = new Integer[expectedPKS.length];
        logger.log(System.Logger.Level.TRACE, "PMClientBase.checkEntityPK(Collection<T>,String[], boolean)");
        if (expectedPKS.length != 0) {
            int i = 0;
            for (String s : expectedPKS) {
                epks2[i++] = Integer.valueOf(s);
            }
        }
        return this.checkEntityPK(actualPKS, epks2, allowDups, true);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Integer[] expectedPKS) {
        logger.log(System.Logger.Level.TRACE, "PMClientBase.checkEntityPK(Collection<T>,Integer[])");
        return this.checkEntityPK(actualPKS, expectedPKS, false, true);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Integer[] expectedPKS, boolean allowDups, boolean sortLists) {
        Object[] cpks2 = new Integer[actualPKS.size()];
        logger.log(System.Logger.Level.TRACE, "PMClientBase.checkEntityPK(Collection<T>,Integer[], boolean)");
        try {
            String cpks;
            String epks;
            if (expectedPKS.length == 0) {
                epks = "()";
            } else {
                if (sortLists) {
                    Arrays.sort((Object[])expectedPKS);
                }
                epks = this.createStringVersionOfPKS(expectedPKS);
            }
            if (actualPKS.size() == 0) {
                cpks = "()";
            } else {
                int k = 0;
                Iterator<T> iterator = actualPKS.iterator();
                while (iterator.hasNext()) {
                    T o;
                    T ref = o = iterator.next();
                    try {
                        if (ref instanceof Integer) {
                            cpks2[k++] = (Integer)ref;
                            continue;
                        }
                        if (ref instanceof String) {
                            cpks2[k++] = Integer.valueOf((String)ref);
                            continue;
                        }
                        Method m = ref.getClass().getMethod("getId", new Class[0]);
                        Object oo = m.invoke(ref, new Object[0]);
                        if (oo instanceof String) {
                            cpks2[k++] = Integer.valueOf((String)oo);
                            continue;
                        }
                        cpks2[k++] = (Integer)oo;
                    }
                    catch (NoSuchMethodException nsme) {
                        logger.log(System.Logger.Level.ERROR, "Unexpected exception thrown", (Throwable)nsme);
                    }
                    catch (IllegalAccessException iae) {
                        logger.log(System.Logger.Level.ERROR, "Unexpected exception thrown", (Throwable)iae);
                    }
                    catch (InvocationTargetException ite) {
                        logger.log(System.Logger.Level.ERROR, "Unexpected exception thrown", (Throwable)ite);
                    }
                }
            }
            if (sortLists) {
                Arrays.sort(cpks2);
            }
            cpks = this.createStringVersionOfPKS((Integer[])cpks2);
            if (this.checkWrongSize(expectedPKS, (Integer[])cpks2)) {
                logger.log(System.Logger.Level.ERROR, "Wrong size returned, expected PKs of " + epks + ", got PKs of " + cpks);
                return false;
            }
            if (!allowDups && this.checkDuplicates((Integer[])cpks2)) {
                logger.log(System.Logger.Level.ERROR, "Duplicate values returned, expected PKs of " + epks + ", got PKs of " + cpks);
                return false;
            }
            if (!Arrays.equals((Object[])expectedPKS, cpks2)) {
                logger.log(System.Logger.Level.ERROR, "Wrong values returned, expected PKs of " + epks + ", got PKs of " + cpks);
                return false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception in PMClientBase.checkEntityPK(Collection<T>,Integer[]: ", (Throwable)e);
            return false;
        }
        return true;
    }

    public String createStringVersionOfPKS(Integer[] iArray) {
        StringBuilder sb = new StringBuilder(2);
        sb.append("(");
        for (int i = 0; i < iArray.length; ++i) {
            sb.append(iArray[i]);
            if (i >= iArray.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean checkWrongSize(Integer[] expected, Integer[] actual) {
        logger.log(System.Logger.Level.TRACE, "PMClientbase.checkWrongSize");
        if (expected.length != actual.length) {
            logger.log(System.Logger.Level.ERROR, "Wrong collection size returned (expected " + expected.length + ", got " + actual.length + ")");
            return true;
        }
        return false;
    }

    public boolean checkDuplicates(Integer[] iArray) {
        logger.log(System.Logger.Level.TRACE, "PMClientbase.checkDuplicates");
        boolean duplicates = false;
        block0: for (int ii = 0; ii < iArray.length; ++ii) {
            for (int j = 0; j < iArray.length; ++j) {
                if (ii == j || !iArray[ii].equals(iArray[j])) continue;
                duplicates = true;
                continue block0;
            }
        }
        if (duplicates) {
            logger.log(System.Logger.Level.ERROR, "Wrong collection contents returned (contains duplicate entries)");
            return true;
        }
        return false;
    }

    public String compareResultList(List expected, List actual) {
        if (!expected.equals(actual)) {
            String reason = "Expecting result list: " + expected + "  , actual: " + actual;
            throw new RuntimeException(reason);
        }
        String reason = "Got expected result list: " + expected;
        logger.log(System.Logger.Level.TRACE, reason);
        return reason;
    }

    public void displayMap(Map map) {
        if (map != null) {
            Set set = map.entrySet();
            for (Map.Entry me : set) {
                if (me.getValue() instanceof String) {
                    logger.log(System.Logger.Level.TRACE, "Map - name:" + (String)me.getKey() + ", value:" + me.getValue());
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "Map - name:" + (String)me.getKey() + ", value:" + me.getValue().getClass().getName());
            }
        } else {
            logger.log(System.Logger.Level.TRACE, "Map passed in to displayMap was null");
        }
    }

    public int convertToInt(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).intValue();
        }
        throw new IllegalArgumentException("convertToInt(): Received type not coded for:" + o.getClass().getName());
    }

    public boolean findDataInFile(File file, String searchString) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(searchString);
        return this.findDataInFile(file, list);
    }

    public boolean findDataInFile(File file, List<String> searchStrings) {
        boolean found = false;
        List<String> fileContents = this.getFileContent(file);
        int fileContentLineCount = 0;
        int foundCount = 0;
        block0: while (!found && foundCount != searchStrings.size() && fileContentLineCount != fileContents.size()) {
            for (String fileContent : fileContents) {
                ++fileContentLineCount;
                foundCount = 0;
                for (String searchString : searchStrings) {
                    logger.log(System.Logger.Level.TRACE, "searchString:" + searchString);
                    if (fileContent.toLowerCase().indexOf(searchString.toLowerCase()) < 0) continue;
                    logger.log(System.Logger.Level.TRACE, "Found string[" + searchString + "] in line [" + fileContent + "]");
                    ++foundCount;
                }
                if (foundCount != searchStrings.size()) continue;
                found = true;
                continue block0;
            }
        }
        if (!found) {
            if (searchStrings.size() > 1) {
                StringBuffer sb = new StringBuffer();
                int count = 0;
                for (String s : searchStrings) {
                    sb.append(s);
                    if (++count == searchStrings.size()) continue;
                    sb.append(" and ");
                }
                logger.log(System.Logger.Level.ERROR, "Entries:" + sb.toString() + ", not found in file:" + file.toString());
                for (String s : fileContents) {
                    logger.log(System.Logger.Level.ERROR, "File line[" + s + "]");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Entry:" + searchStrings.get(0) + ", not found in file:" + file.toString());
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFileContent(File file) {
        ArrayList<String> list;
        block8: {
            list = new ArrayList<String>();
            try {
                if (file.exists()) {
                    logger.log(System.Logger.Level.TRACE, "found file:" + file.getAbsolutePath());
                    if (file.length() > 0L) {
                        try (BufferedReader input = new BufferedReader(new FileReader(file));){
                            String line = null;
                            while ((line = input.readLine()) != null) {
                                logger.log(System.Logger.Level.TRACE, "read line:" + line);
                                line = line.trim();
                                list.add(line);
                            }
                            break block8;
                        }
                    }
                    logger.log(System.Logger.Level.ERROR, "File is empty: " + file.getAbsolutePath());
                    break block8;
                }
                logger.log(System.Logger.Level.ERROR, "Specified file " + file.getAbsolutePath() + " does not exist");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    public void deleteItem(File file) {
        if (file.exists()) {
            logger.log(System.Logger.Level.TRACE, "item:" + file.getAbsolutePath() + " exists");
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File f : files) {
                        this.deleteItem(f);
                    }
                    if (file.delete()) {
                        logger.log(System.Logger.Level.TRACE, "directory: " + file.getAbsolutePath() + " deleted");
                        if (file.exists()) {
                            logger.log(System.Logger.Level.ERROR, "directory still exists even after calling delete");
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Could not delete directory: " + file.getAbsolutePath());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "listFiles returned null");
                }
            } else if (file.delete()) {
                logger.log(System.Logger.Level.TRACE, "file: " + file.getAbsolutePath() + " deleted");
                if (file.exists()) {
                    logger.log(System.Logger.Level.ERROR, "file still exists even after calling delete");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Could not delete file: " + file.getAbsolutePath());
            }
        } else {
            logger.log(System.Logger.Level.TRACE, "file:" + file.getAbsolutePath() + " does not exist");
        }
    }

    public String convertToURI(String path) {
        String sURI = null;
        try {
            sURI = new File(path).toURI().toASCIIString();
            logger.log(System.Logger.Level.TRACE, "URI=" + sURI);
        }
        catch (Exception ue) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception for path:" + path, (Throwable)ue);
        }
        return sURI;
    }

    public JavaArchive createDeploymentJar(String jarName, String packageName, String[] classes, String persistenceFile, String[] xmlFiles) throws Exception {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)jarName);
        for (int j = 0; j < classes.length; ++j) {
            archive.addClass(classes[j]);
        }
        if (persistenceFile.equals(STANDALONE_PERSISTENCE_XML) || persistenceFile.equals(EE_PERSISTENCE_XML)) {
            int i;
            int j;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            InputStream xmlStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(persistenceFile);
            Document document = db.parse(xmlStream);
            NodeList presistenceElement = document.getElementsByTagName(PERSISTENCE_ELEMENT_TAG);
            for (j = 0; j < xmlFiles.length; ++j) {
                if (ORM_XML.equalsIgnoreCase(xmlFiles[j])) continue;
                for (i = 0; i < presistenceElement.getLength(); ++i) {
                    Element mappingTag = document.createElement(MAPPING_ELEMENT_TAG);
                    Text mappingNode = document.createTextNode(xmlFiles[j]);
                    mappingTag.appendChild(mappingNode);
                    presistenceElement.item(i).appendChild(mappingTag);
                }
            }
            for (j = 0; j < classes.length; ++j) {
                for (i = 0; i < presistenceElement.getLength(); ++i) {
                    Element classTag = document.createElement(CLASS_ELEMENT_TAG);
                    Text classNode = document.createTextNode(classes[j]);
                    classTag.appendChild(classNode);
                    presistenceElement.item(i).appendChild(classTag);
                }
            }
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            archive.addAsManifestResource((Asset)new StringAsset(writer.getBuffer().toString()), PERSISTENCE_XML);
        } else {
            InputStream xmlFileStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(packageName.replace('.', '/') + "/" + persistenceFile);
            archive.addAsManifestResource((Asset)new ByteArrayAsset(xmlFileStream), PERSISTENCE_XML);
        }
        for (int i = 0; i < xmlFiles.length; ++i) {
            if (ORM_XML.equalsIgnoreCase(xmlFiles[i])) {
                InputStream xmlFileStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(packageName.replace('.', '/') + "/" + xmlFiles[i]);
                archive.addAsManifestResource((Asset)new ByteArrayAsset(xmlFileStream), xmlFiles[i]);
                continue;
            }
            archive.addAsResource(packageName.replace('.', '/') + "/" + xmlFiles[i], xmlFiles[i]);
        }
        if (STANDALONE_MODE.equalsIgnoreCase(this.mode)) {
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(new File(TEMP_DIR + File.separator + jarName), true);
            ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(TEMP_DIR + File.separator + jarName).toURL()}, currentThreadClassLoader);
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            this.testArtifactDeployed = true;
        }
        return archive;
    }

    public JavaArchive createDeploymentJar(String jarName, String packageName, String[] classes, String[] xmlFiles) throws Exception {
        return this.createDeploymentJar(jarName, packageName, classes, STANDALONE_PERSISTENCE_XML, xmlFiles);
    }

    public JavaArchive createDeploymentJar(String jarName, String packageName, String[] classes) throws Exception {
        String[] xmlFiles = new String[]{};
        return this.createDeploymentJar(jarName, packageName, classes, STANDALONE_PERSISTENCE_XML, xmlFiles);
    }

    public void removeTestJarFromCP() throws Exception {
        if (this.testArtifactDeployed && STANDALONE_MODE.equalsIgnoreCase(this.mode)) {
            URLClassLoader currentThreadClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader.getParent());
            currentThreadClassLoader.close();
            this.testArtifactDeployed = false;
        }
    }

    public static String toString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }
}

