/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverapplicationconfig;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -6963654147324631018L;
    private static final String CONTENT = WSClientIT.class.getName();

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_ee_jakarta_websocket_server_appconfig_web.war");
        try {
            archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverapplicationconfig"});
            archive.addPackages(false, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
            archive.addClasses(new Class[]{IOUtil.class});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("ws_ee_jakarta_websocket_server_appconfig_web");
    }

    @Test
    public void usedServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("used"));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, CONTENT);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invoke();
    }

    @Test
    public void unusedServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("unused"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invokeFail();
        String message = this.getResponseAsString();
        WSClientIT.assertTrue(WSClientIT.isNullOrEmpty(message), "The unused server endpoint should not be registered");
    }

    @Test
    public void otherUsedServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("other"));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, CONTENT);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invoke();
    }

    @Test
    public void configuredServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("configured"));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, CONTENT);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invoke();
    }

    @Test
    public void unusedConfiguredServerTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("unusedconfig"));
        this.setProperty(WebSocketCommonClient.Property.CONTENT, CONTENT);
        this.invokeFail();
        String message = this.getResponseAsString();
        WSClientIT.assertTrue(WSClientIT.isNullOrEmpty(message), "The unused server endpoint config should not register an endpoint");
    }

    private void invokeFail() {
        try {
            this.invoke(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

