/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.builtin.metadata.session;

import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Collections;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.session.BakeryProduct;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.session.BakeryProductDecorator;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.session.Frozen;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.session.Yoghurt;
import org.jboss.cdi.tck.tests.implementation.builtin.metadata.session.YoghurtInterceptor;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="2.0")
public class BuiltinMetadataSessionBeanTest
extends AbstractTest {
    @Inject
    private Yoghurt yoghurt;
    @Inject
    private BakeryProduct bakery;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinMetadataSessionBeanTest.class)).withClasses(new Class[]{YoghurtInterceptor.class, Frozen.class})).withBeansXml(new BeansXml().interceptors(new Class[]{YoghurtInterceptor.class}).decorators(new Class[]{BakeryProductDecorator.class}))).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_metadata", id="b"), @SpecAssertion(section="bean_metadata", id="d"), @SpecAssertion(section="bean_metadata", id="f")})
    public void testInterceptorMetadata() {
        Interceptor interceptor = (Interceptor)this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new Frozen.Literal()}).iterator().next();
        Bean sessionBean = this.getUniqueBean(Yoghurt.class, new Annotation[0]);
        YoghurtInterceptor fatYoghurtInterceptor = this.yoghurt.getInterceptorInstance();
        Assert.assertEquals((Object)interceptor, fatYoghurtInterceptor.getBean());
        Assert.assertEquals((Object)interceptor, fatYoghurtInterceptor.getInterceptor());
        Assert.assertEquals((Object)sessionBean, fatYoghurtInterceptor.getInterceptedBean());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_metadata", id="c"), @SpecAssertion(section="bean_metadata", id="e"), @SpecAssertion(section="bean_metadata", id="f")})
    public void testDecoratorMetadata() {
        Bean sessionBean = this.getUniqueBean(BakeryProduct.class, new Annotation[0]);
        Decorator decoratorInstance = (Decorator)this.getCurrentManager().resolveDecorators(Collections.singleton(BakeryProduct.class), new Annotation[0]).iterator().next();
        BakeryProductDecorator bakeryDecorator = this.bakery.getDecoratorInstance();
        Assert.assertEquals((Object)decoratorInstance, bakeryDecorator.getBean());
        Assert.assertEquals((Object)decoratorInstance, bakeryDecorator.getDecorator());
        Assert.assertEquals((Object)sessionBean, bakeryDecorator.getDecoratedBean());
    }
}

