/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.beannameelresolver;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.BeanNameELResolver;
import jakarta.el.BeanNameResolver;
import jakarta.el.ELContext;
import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.StandardELContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientServletTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "beannameelresolver_servlet_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientServletTest.class.getName());
    private Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientServletTest.inputStreamToString(inStream).replaceAll("el_servlet_vehicle", servlet_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="beannameelresolver_servlet_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"beannameelresolver_servlet_vehicle_web.war");
        servlet_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, BarELResolver.class, ResolverTest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ServletVehicle.class, ELClientServletTest.class, TCKBeanNameResolver.class, BareBonesELContext.class, SimpleBean.class, SimpleInterface.class, ELTestUtil.class});
        InputStream inStream = ELClientServletTest.class.getResourceAsStream("/vehicle/servlet/servlet_vehicle_web.xml");
        String webXml = ELClientServletTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        servlet_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        return servlet_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientServletTest theTests = new ELClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    @AfterEach
    public void cleanup() throws Exception {
        TestUtil.logTrace((String)"Cleanup method called");
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanNameELResolverTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        elm.addBeanNameResolver((BeanNameResolver)bnr);
        elm.addELResolver((ELResolver)belr);
        elm.defineBean("simpleBean", (Object)new SimpleBean());
        StandardELContext context = elm.getELContext();
        try {
            pass = ResolverTest.testELResolver((ELContext)context, (ELResolver)context.getELResolver(), (Object)bnr.getBean("simpleBean"), (Object)"intention", (Object)"GOLDEN", (StringBuffer)buf, (boolean)false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logMsg((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanNameELResolverInvokeMNFETest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        elm.addBeanNameResolver((BeanNameResolver)bnr);
        elm.addELResolver((ELResolver)belr);
        elm.defineBean("simpleBean", (Object)new SimpleBean());
        StandardELContext context = elm.getELContext();
        Class[] types = new Class[]{String.class, String.class};
        Object[] values = new String[]{"Doug", "Donahue"};
        try {
            pass = ResolverTest.testELResolverInvoke((ELContext)context, (ELResolver)context.getELResolver(), (Object)new SimpleBean(), (Object)"bogue_method", (Class[])types, (Object[])values, (Boolean)true, (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logMsg((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanNameELResolverInvokeTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        elm.addBeanNameResolver((BeanNameResolver)bnr);
        elm.addELResolver((ELResolver)belr);
        elm.defineBean("simpleBean", (Object)new SimpleBean());
        StandardELContext context = elm.getELContext();
        Class[] types = new Class[]{String.class, String.class};
        Object[] values = new String[]{"Doug", "Donahue"};
        try {
            pass = ResolverTest.testELResolverInvoke((ELContext)context, (ELResolver)context.getELResolver(), (Object)new SimpleBean(), (Object)"isName", (Class[])types, (Object[])values, (Boolean)false, (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logMsg((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanNameELResolverGetTypeNPETest() throws Exception {
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        ELTestUtil.checkForNPE(belr, "getType", new Class[]{ELContext.class, Object.class, Object.class}, new Object[]{null, "Ender", "Wiggins"});
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanNameELResolverGetValueNPETest() throws Exception {
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        ELTestUtil.checkForNPE(belr, "getValue", new Class[]{ELContext.class, Object.class, Object.class}, new Object[]{null, "Ender", "Wiggins"});
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanNameELResolverIsReadOnlyNPETest() throws Exception {
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        ELTestUtil.checkForNPE(belr, "isReadOnly", new Class[]{ELContext.class, Object.class, Object.class}, new Object[]{null, "Ender", "Wiggins"});
    }

    @Test
    @TargetVehicle(value="servlet")
    public void beanNameELResolverSetValueNPETest() throws Exception {
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        ELTestUtil.checkForNPE(belr, "setValue", new Class[]{ELContext.class, Object.class, Object.class, Object.class}, new Object[]{null, "Ender", "Valintine", "Wiggins"});
    }

    private static class TCKBeanNameResolver
    extends BeanNameResolver {
        private TCKBeanNameResolver() {
        }
    }
}

