/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.staticfieldelresolver;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.api.jakarta_el.staticfieldelresolver.TCKELClass;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.ELClass;
import jakarta.el.ELContext;
import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.StandardELContext;
import jakarta.el.StaticFieldELResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "staticfieldelresolver_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    private Properties testProps;

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="staticfieldelresolver_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"staticfieldelresolver_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, BarELResolver.class, ResolverTest.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, TCKFunctionMapper.class, EmployeeELResolver.class, VariableELResolver.class, VectELResolver.class, FunctionELResolver.class, TCKELClass.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", servlet_vehicle);
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    @AfterEach
    public void cleanup() throws Exception {
        TestUtil.logTrace((String)"Cleanup method called");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void staticFieldELResolverTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = true;
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        StandardELContext context = elm.getELContext();
        ELClass base = new ELClass(TCKELClass.class);
        String property = "firstName";
        String value = "Ender";
        context.setPropertyResolved(false);
        try {
            resolver.setValue((ELContext)context, (Object)base, (Object)property, (Object)value);
            buf.append("Test FAILED" + TestUtil.NEW_LINE + "Expected PropertyNotWritableException to be thrown when calling setValue()!" + TestUtil.NEW_LINE + "No exception was thown!" + TestUtil.NEW_LINE);
            pass = false;
        }
        catch (PropertyNotWritableException pnwe) {
            buf.append("Test PASSED" + TestUtil.NEW_LINE + "PropertyNotWritableException Thrown as expected for setValue()!" + TestUtil.NEW_LINE);
        }
        catch (Exception e) {
            buf.append("Test FAILED" + TestUtil.NEW_LINE + "Wrong Exception Thrownfor setValue()!" + TestUtil.NEW_LINE + "Expected: PropertyNotWritableException" + TestUtil.NEW_LINE + "Received: " + e.getClass().getSimpleName() + TestUtil.NEW_LINE);
        }
        context.setPropertyResolved(false);
        Object valueRetrieved = resolver.getValue((ELContext)context, (Object)base, (Object)property);
        if (!context.isPropertyResolved()) {
            buf.append("getValue() did not resolve" + TestUtil.NEW_LINE);
            pass = false;
        }
        if (valueRetrieved != value) {
            buf.append("Invalid value from getValue():" + TestUtil.NEW_LINE + "Value expected: " + value.toString() + TestUtil.NEW_LINE + "Value retrieved: " + valueRetrieved.toString() + TestUtil.NEW_LINE);
            pass = false;
        }
        context.setPropertyResolved(false);
        Class type = resolver.getType((ELContext)context, (Object)base, (Object)property);
        if (!context.isPropertyResolved()) {
            buf.append("getType() did not resolve" + TestUtil.NEW_LINE);
            pass = false;
        } else if (type != null) {
            buf.append("getType() returns " + type.getName() + " rather than null" + TestUtil.NEW_LINE);
            pass = false;
        } else {
            buf.append("getType() returns null" + TestUtil.NEW_LINE + "as expected." + TestUtil.NEW_LINE);
        }
        context.setPropertyResolved(false);
        boolean nonWritable = resolver.isReadOnly((ELContext)context, (Object)base, (Object)property);
        if (!context.isPropertyResolved()) {
            buf.append("isReadOnly() did not resolve" + TestUtil.NEW_LINE);
            pass = false;
        } else if (!nonWritable) {
            buf.append("isReadOnly() returned unexpected value: " + TestUtil.NEW_LINE + "Expected: false" + TestUtil.NEW_LINE + "Received: " + nonWritable + TestUtil.NEW_LINE);
            pass = false;
        } else {
            buf.append("isReadOnly() returns false as expected" + TestUtil.NEW_LINE);
        }
        context.setPropertyResolved(false);
        Class commonPropertyType = resolver.getCommonPropertyType((ELContext)context, (Object)base);
        buf.append("getCommonPropertyType() returns " + commonPropertyType.getName() + TestUtil.NEW_LINE);
        if (!pass) {
            throw new Exception("Test FAILED" + TestUtil.NEW_LINE + buf.toString());
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void staticFieldResolverInvokeMNFETest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        StandardELContext context = elm.getELContext();
        Class[] types = new Class[]{String.class, String.class};
        Object[] values = new String[]{"Doug", "Donahue"};
        try {
            pass = ResolverTest.testELResolverInvoke((ELContext)context, (ELResolver)context.getELResolver(), (Object)new ELClass(TCKELClass.class), (Object)"bogue_method", (Class[])types, (Object[])values, (Boolean)true, (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logMsg((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void staticFieldELResolverInvokeTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        StandardELContext context = elm.getELContext();
        Class[] types = new Class[]{String.class};
        Object[] values = new String[]{"Ender"};
        try {
            pass = ResolverTest.testELResolverInvoke((ELContext)context, (ELResolver)context.getELResolver(), (Object)new ELClass(TCKELClass.class), (Object)"isName", (Class[])types, (Object[])values, (Boolean)false, (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logMsg((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void staticFieldELResolverNPETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)resolver, (Object)new ELClass(TCKELClass.class), (Object)"intention", (Object)"billy", (StringBuffer)buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        TestUtil.logTrace((String)buf.toString());
    }

    @Test
    @TargetVehicle(value="jsp")
    public void staticFieldResolverInvokePNFETest() throws Exception {
        ELClass base = new ELClass(TCKELClass.class);
        this.testForPNFE("notStatic", base);
        this.testForPNFE("privStatic", base);
        this.testForPNFE("privStatic", "bogus");
    }

    private void testForPNFE(String property, Object base) {
        StringBuffer buf = new StringBuffer();
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        StandardELContext context = elm.getELContext();
        try {
            resolver.getType((ELContext)context, base, (Object)property);
            buf.append("Test FAILED getType() did not throw any exception." + TestUtil.NEW_LINE + "Expected: PropertyNotFoundException " + TestUtil.NEW_LINE);
        }
        catch (PropertyNotFoundException pnfe) {
            buf.append("Test PASSED");
        }
        catch (Exception e) {
            buf.append("Test FAILEDWrong Exception thrown for getType()!" + TestUtil.NEW_LINE + " Expected: PropertyNotFoundException" + TestUtil.NEW_LINE + "Received: " + e.getClass().getSimpleName());
        }
        try {
            resolver.getValue((ELContext)context, base, (Object)property);
            buf.append("Test FAILED getValue() did not throw any exception." + TestUtil.NEW_LINE + "Expected: PropertyNotFoundException " + TestUtil.NEW_LINE);
        }
        catch (PropertyNotFoundException pnfe) {
            buf.append("Test PASSED");
        }
        catch (Exception e) {
            buf.append("Test FAILEDWrong Exception thrown getValue()!" + TestUtil.NEW_LINE + " Expected: PropertyNotFoundException" + TestUtil.NEW_LINE + "Received: " + e.getClass().getSimpleName());
        }
    }
}

