/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.concatoperator;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import jakarta.el.ELProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "concatoperator_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String jsp_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", jsp_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="concatoperator_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"concatoperator_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, EmployeeELResolver.class, FunctionELResolver.class, VariableELResolver.class, VectELResolver.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TestNum.class, TypesBean.class, Validator.class, TCKFunctionMapper.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalConcatenationTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(10.531);
        Validator.testBigDecimal(testValue, null, "+=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerConcatenationTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        Validator.testBigInteger(testValue, null, "+=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatConcatenationTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Validator.testFloat(testValue, null, "+=");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleConcatenationTest() throws Exception {
        Double testValue = 2.5;
        Validator.testDouble(testValue, null, "+=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongConcatenationTest() throws Exception {
        Long testValue = 25000L;
        Validator.testLong(testValue, null, "+=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerConcatenationTest() throws Exception {
        Integer testValue = 25;
        Validator.testInteger(testValue, null, "+=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortConcatenationTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Validator.testShort(testValue, null, "+=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteConcatenationTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Validator.testByte(testValue, null, "+=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBooleanConcatenationTest() throws Exception {
        Validator.testBoolean(false, "true", null, "+=");
        Validator.testBoolean(false, true, null, "+=");
    }

    private void logLine(String s) {
        TestUtil.logTrace((String)s);
    }

    private void testQuery(String name, String query, String expected) throws Exception {
        ELProcessor elp = new ELProcessor();
        this.logLine("=== Testing " + name + " ===");
        this.logLine(query);
        this.logLine(" = returns =");
        Object ret = elp.eval(query);
        if (!expected.equals(ret.toString())) {
            throw new Exception("Test FAILED  Unexpected Value!" + ELTestUtil.NL + "Expected: " + expected + ELTestUtil.NL + "Received: " + ret.toString());
        }
    }
}

