/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.language;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.el.spec.Book;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import jakarta.el.ELException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "language_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    private static String NLINE = System.getProperty("line.separator", "\n");
    Properties testProps;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String jsp_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", jsp_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="language_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"language_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, EmployeeELResolver.class, FunctionELResolver.class, VariableELResolver.class, VectELResolver.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TestNum.class, TypesBean.class, Validator.class, TCKFunctionMapper.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="jsp")
    public void poundDollarSameMeaning1Test() throws Exception {
        boolean pass = true;
        String testExpr = "\"foo\"";
        try {
            Object dollarResult = ExprEval.evaluateValueExpression("${" + testExpr + "}", null, String.class);
            Object poundResult = ExprEval.evaluateValueExpression("#{" + testExpr + "}", null, String.class);
            TestUtil.logTrace((String)("Comparing  ${" + dollarResult.toString() + "} to #{" + poundResult.toString() + "}"));
            pass = ExprEval.compareClass(poundResult, String.class) && ExprEval.compareClass(dollarResult, String.class) && ExprEval.compareValue(poundResult, dollarResult);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void poundDollarSameMeaning2Test() throws Exception {
        boolean pass = true;
        try {
            Object firstNameDollar = ExprEval.evaluateValueExpression("${worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            Object firstNamePound = ExprEval.evaluateValueExpression("#{worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            TestUtil.logTrace((String)("Comparing  ${" + firstNameDollar.toString() + "} to #{" + firstNamePound.toString() + "}"));
            if (!firstNamePound.toString().equals(firstNameDollar.toString())) {
                TestUtil.logTrace((String)"Dollar & Pound symbols return differentexpression values!");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void nestedEvalExpressionsTest() throws Exception {
        boolean pass = true;
        String[] expr = new String[]{"${worker[${worker}]}", "${worker[#{worker}]}", "#{worker[${worker}]}", "#{worker[#{worker}]}"};
        for (int i = 0; i < expr.length; ++i) {
            try {
                ExprEval.evaluateValueExpression(expr[i], null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
                pass = false;
                TestUtil.logErr((String)"Test FAILED. No exception thrown for ");
                TestUtil.logErr((String)expr[i]);
                continue;
            }
            catch (ELException ee) {
                TestUtil.logErr((String)"Expected Exception thrown.");
                continue;
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)("Test FAILED. " + expr[i] + " caused "));
                TestUtil.logErr((String)"an exception, but it was not an ");
                TestUtil.logErr((String)"ELException.");
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void mixedCompositeExpressionsTest() throws Exception {
        boolean pass = true;
        String[] expr = new String[]{"${worker}#{worker}", "#{worker}${worker}", "${worker}#{worker}${worker}", "#{worker}${worker}#{worker}"};
        for (int i = 0; i < expr.length; ++i) {
            try {
                ExprEval.evaluateValueExpression(expr[i], null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
                pass = false;
                TestUtil.logErr((String)"Test FAILED. No exception thrown for ");
                TestUtil.logErr((String)expr[i]);
            }
            catch (ELException ee) {
                TestUtil.logErr((String)"Expected Exception thrown.");
            }
            catch (Exception e) {
                pass = false;
                TestUtil.logErr((String)("Test FAILED. " + expr[i] + " caused "));
                TestUtil.logErr((String)"an exception, but it was not an ");
                TestUtil.logErr((String)"ELException.");
                TestUtil.printStackTrace((Throwable)e);
            }
            if (pass) continue;
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void compositeExprEval1Test() throws Exception {
        boolean pass = true;
        String streetName = "${'Network Circle'}";
        String city = "${'Santa Clara'}";
        String state = "${'CA'}";
        String expected = "4140 Network Circle, Santa Clara, CA 95054";
        try {
            Object address = ExprEval.evaluateValueExpression("4140 " + streetName + ", " + city + ", " + state + " 95054", null, String.class);
            TestUtil.logTrace((String)("Testing for Address: " + expected));
            pass = ExprEval.compareClass(address, String.class) && ExprEval.compareValue(address, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void compositeExprEval2Test() throws Exception {
        boolean pass = true;
        int num = 2;
        String expected = "total = 3.0";
        try {
            Object div = ExprEval.evaluateValueExpression("total = ${" + num + "+2/" + num + "}", null, String.class);
            TestUtil.logTrace((String)("Testing for: " + expected));
            pass = ExprEval.compareClass(div, String.class) && ExprEval.compareValue(div, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void dotAndIndexOperatorsSameTest() throws Exception {
        boolean pass = true;
        try {
            Object firstnameDot = ExprEval.evaluateValueExpression("${worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            Object firstnameBracket = ExprEval.evaluateValueExpression("${worker['firstName']}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            pass = firstnameDot.equals(firstnameBracket);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elSyntaxEscapeTest() throws Exception {
        boolean pass = true;
        try {
            Object firstnameDollar = ExprEval.evaluateValueExpression("\\${worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            Object firstnamePound = ExprEval.evaluateValueExpression("\\#{worker.firstName}", null, String.class, ResolverType.EMPLOYEE_ELRESOLVER);
            if (!ExprEval.compareValue(firstnameDollar, "${worker.firstName}") || !ExprEval.compareValue(firstnamePound, "#{worker.firstName}")) {
                TestUtil.logTrace((String)"Escape character failed to work.");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void literalExprEval1Test() throws Exception {
        String exprStr;
        boolean pass = true;
        String expected = exprStr = "foo";
        try {
            Object expr = ExprEval.evaluateValueExpression(exprStr, null, String.class);
            pass = ExprEval.compareClass(expr, String.class) && ExprEval.compareValue(expr, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void literalExprEval2Test() throws Exception {
        boolean pass = true;
        String exprStr = "true";
        try {
            Object expr = ExprEval.evaluateValueExpression(exprStr, null, Boolean.class);
            pass = ExprEval.compareClass(expr, Boolean.class) && ExprEval.compareValue(expr, (Object)true);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void literalExprAsMethodExpr1Test() throws Exception {
        boolean pass = true;
        try {
            Object value2;
            Class[] params = new Class[]{};
            Object value1 = ExprEval.evaluateMethodExpression("true", params, String.class, ResolverType.VECT_ELRESOLVER);
            if (!"true".equals(value1)) {
                pass = false;
                TestUtil.logErr((String)"Literal Expression, Return String Failed!");
            }
            if (!((Boolean)(value2 = ExprEval.evaluateMethodExpression("true", params, Boolean.class, ResolverType.VECT_ELRESOLVER))).booleanValue()) {
                pass = false;
                TestUtil.logErr((String)"Literal Expression, Return non-String Failed!");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("Test Failed!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void literalExprAsMethodExpr2Test() throws Exception {
        boolean pass = true;
        int testNum = 496;
        try {
            Class[] params = new Class[]{};
            Object value = ExprEval.evaluateMethodExpression("496", params, Integer.class, ResolverType.VECT_ELRESOLVER);
            if (!(value instanceof Integer)) {
                pass = false;
                TestUtil.logErr((String)"MethodExpression invocation does not return instance of expected class");
            } else if ((Integer)value != testNum) {
                pass = false;
                TestUtil.logErr((String)("Expected: " + testNum + NLINE + "Received: " + value.toString()));
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("Test Failed!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void rValueCoercion1Test() throws Exception {
        boolean pass = false;
        String expr = "${foo}";
        String expected = "bar";
        try {
            Object value = ExprEval.evaluateCoerceValueExpression(expr, expected, String.class);
            pass = ExprEval.compareClass(value, String.class) && ExprEval.compareValue(value, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void rValueCoercion2Test() throws Exception {
        boolean pass = false;
        String expr = "${javabook}";
        String expected = "The Java Programming Language";
        try {
            Book jbook = new Book(expected, "Arnold and Gosling", "Addison Wesley", 1996);
            Object value = ExprEval.evaluateCoerceValueExpression(expr, jbook, String.class);
            pass = ExprEval.compareClass(value, String.class) && ExprEval.compareValue(value, expected);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void parseOnceEvalManyTest() throws Exception {
        boolean pass = false;
        String expr = "${foo}";
        String expected = "bar";
        Hashtable<Class<Boolean>, Object> contextObjects = new Hashtable<Class<Boolean>, Object>();
        contextObjects.put(String.class, "string context");
        contextObjects.put(Integer.class, 1);
        contextObjects.put(Boolean.class, Boolean.TRUE);
        try {
            pass = ExprEval.evaluateManyValueExpression(expr, expected, String.class, contextObjects);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED!");
        }
    }
}

