/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.mapper;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ExprEval;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientTest
extends ServiceEETest {
    private static final System.Logger logger = System.getLogger(ELClientTest.class.getName());
    Properties testProps = System.getProperties();

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static void main(String[] args) {
        ELClientTest theTests = new ELClientTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    public void ELFunctionBindingTest() throws Exception {
        block7: {
            Class<Integer> expectedClass = Integer.class;
            Integer expectedValue = 10;
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            FuncMapperELContext context = new FuncMapperELContext();
            ValueExpression vexp1 = expFactory.createValueExpression((ELContext)context, "${Int:val(10)}", Object.class);
            ValueExpression vexp2 = expFactory.createValueExpression((ELContext)context, "${Int:val(\"string\")}", Object.class);
            Object initialResult = vexp1.getValue((ELContext)context);
            if (!ExprEval.compareClass(initialResult, expectedClass)) {
                throw new Exception("Wrong class for initial Expression evaluation");
            }
            if (!ExprEval.compareValue(initialResult, expectedValue)) {
                throw new Exception("Wrong value for initial Expression evaluation");
            }
            TCKFunctionMapper mapper = (TCKFunctionMapper)context.getFunctionMapper();
            mapper.update();
            Object finalResult = vexp1.getValue((ELContext)context);
            if (!ExprEval.compareClass(finalResult, expectedClass)) {
                throw new Exception("Wrong class for final Expression evaluation");
            }
            if (!ExprEval.compareValue(finalResult, expectedValue)) {
                throw new Exception("Wrong value for final Expression evaluation");
            }
            try {
                vexp2.getValue((ELContext)context);
            }
            catch (Throwable t) {
                if (!(t instanceof ELException)) {
                    TestUtil.logErr((String)"Expected ELException to be thrown");
                    TestUtil.logErr((String)("instead threw " + t.toString()));
                    TestUtil.printStackTrace((Throwable)t);
                    throw new Exception("ELException not thrown");
                }
                Throwable cause = t.getCause();
                if (cause instanceof NumberFormatException) break block7;
                TestUtil.logErr((String)"Expected cause to be NumberFormatException");
                TestUtil.logErr((String)("instead cause is " + cause.toString()));
                TestUtil.printStackTrace((Throwable)cause);
                throw new Exception("NumberFormatException not cause");
            }
        }
    }

    @Test
    public void ELVariableBindingTest() throws Exception {
        Class<Double> expectedClass = Double.class;
        Double expectedValue = 10.0;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        VarMapperELContext context = new VarMapperELContext(this.testProps);
        VariableMapper varMapper = context.getVariableMapper();
        ValueExpression vexp1 = expFactory.createValueExpression((ELContext)context, "#{1e1}", Object.class);
        varMapper.setVariable("ten", vexp1);
        ValueExpression vexp2 = varMapper.resolveVariable("ten");
        Object initialResult = vexp2.getValue((ELContext)context);
        if (!ExprEval.compareClass(initialResult, expectedClass)) {
            throw new Exception("Wrong class for initial Expression evaluation");
        }
        if (!ExprEval.compareValue(initialResult, expectedValue)) {
            throw new Exception("Wrong value for initial Expression evaluation");
        }
        varMapper.setVariable("ten", null);
        Object finalResult = vexp2.getValue((ELContext)context);
        if (!ExprEval.compareClass(finalResult, expectedClass)) {
            throw new Exception("Wrong class for final Expression evaluation");
        }
        if (!ExprEval.compareValue(finalResult, expectedValue)) {
            throw new Exception("Wrong value for final Expression evaluation");
        }
    }
}

