/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.unaryoperator;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "unaryoperator_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    Properties testProps;
    private final boolean[] deferred = new boolean[]{true, false};

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String jsp_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", jsp_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="unaryoperator_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"unaryoperator_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, EmployeeELResolver.class, FunctionELResolver.class, VariableELResolver.class, VectELResolver.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TestNum.class, TypesBean.class, Validator.class, TCKFunctionMapper.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullUnaryTest() throws Exception {
        boolean pass = false;
        String[] symbols = new String[]{"$", "#"};
        Long expectedResult = Long.valueOf("0");
        try {
            for (String prefix : symbols) {
                String expr = prefix + "{-null}";
                TestUtil.logTrace((String)("expression to be evaluated is " + expr));
                Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult, 0);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalUnaryTest() throws Exception {
        boolean pass = false;
        BigDecimal bd = BigDecimal.valueOf(10.0);
        BigDecimal expectedResult = BigDecimal.valueOf(-10.0);
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(bd);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, BigDecimal.class) && ExprEval.compareValue((BigDecimal)result, expectedResult, 0);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerUnaryTest() throws Exception {
        boolean pass = false;
        BigInteger bi = BigInteger.valueOf(100L);
        BigInteger expectedResult = BigInteger.valueOf(-100L);
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(bi);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, BigInteger.class) && ExprEval.compareValue((BigInteger)result, expectedResult, 0);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleStringUnaryTest() throws Exception {
        boolean pass = false;
        String[] values = new String[]{"10.0", "10E0", "10e0"};
        Double expectedResult = Double.valueOf("-10");
        try {
            for (boolean tf : this.deferred) {
                for (String val : values) {
                    NameValuePair[] value = NameValuePair.buildUnaryNameValue(val);
                    String expr = ExprEval.buildElExpr(tf, "unary_minus");
                    Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                    TestUtil.logTrace((String)("result is " + result.toString()));
                    pass = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue((Double)result, expectedResult);
                }
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongStringUnaryTest() throws Exception {
        boolean pass = false;
        String val = "100";
        Long expectedResult = Long.valueOf("-100");
        try {
            for (boolean tf : this.deferred) {
                NameValuePair[] value = NameValuePair.buildUnaryNameValue(val);
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteUnaryTest() throws Exception {
        boolean pass = false;
        byte num = 1;
        byte expectedResult = -1;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Byte.class) && ExprEval.compareValue((Byte)result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortUnaryTest() throws Exception {
        boolean pass = false;
        short num = 1;
        short expectedResult = -1;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Short.class) && ExprEval.compareValue((Short)result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerUnaryTest() throws Exception {
        boolean pass = false;
        int num = 1;
        int expectedResult = -1;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Integer.class) && ExprEval.compareValue((Integer)result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongUnaryTest() throws Exception {
        boolean pass = false;
        long num = 10000L;
        long expectedResult = -10000L;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue((Long)result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatUnaryTest() throws Exception {
        boolean pass = false;
        float num = 10000.0f;
        float expectedResult = -10000.0f;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(Float.valueOf(num));
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Float.class) && ExprEval.compareValue((Float)result, Float.valueOf(expectedResult), 0);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleUnaryTest() throws Exception {
        boolean pass = false;
        double num = 10000.0;
        double expectedResult = -10000.0;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(num);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "unary_minus");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue((Double)result, expectedResult);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBooleanUnaryFalseTest() throws Exception {
        this.testUnary("false", true);
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBooleanUnaryTrueTest() throws Exception {
        this.testUnary("true", false);
    }

    private void testUnary(String testVal, boolean expectedResult) throws Exception {
        boolean pass = false;
        String[] operator = new String[]{"unary_not", "unary_bang"};
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(testVal);
        try {
            for (boolean tf : this.deferred) {
                for (String op : operator) {
                    String expr = ExprEval.buildElExpr(tf, op);
                    Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                    TestUtil.logTrace((String)("result is " + result.toString()));
                    boolean bl = pass = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue((Boolean)result, expectedResult);
                    if (pass) continue;
                    throw new Exception("TEST FAILED: pass = false");
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

