/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.stmt.stmt2;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class stmtClient2
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.stmt.stmt2";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private Statement statemt = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private Properties props = null;
    private PreparedStatement pstmt = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        stmtClient2 theTests = new stmtClient2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testGetResultSet02() throws Exception {
        ResultSet retResSet = null;
        try {
            String sSqlStmt = this.sqlp.getProperty("Upd_Coffee_Tab", "");
            this.msg.setMsg("Query String :  " + sSqlStmt);
            this.msg.setMsg("Calling getResultSet on Statement");
            this.stmt.executeUpdate(sSqlStmt);
            retResSet = this.stmt.getResultSet();
            if (retResSet == null) {
                this.msg.setMsg("getResultSet method returns a Null ResultSet object ");
            } else {
                this.msg.printTestError(" getResultSet method does not return a ResultSet object", "Call to getResultSet is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getResultSet is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getResultSet is Failed!");
        }
    }

    public void testGetResultSetConcurrency01() throws Exception {
        int rsConcur = 0;
        try {
            rsConcur = this.stmt.getResultSetConcurrency();
            if (rsConcur == 1007 || rsConcur == 1008) {
                this.msg.setMsg("getResultSetConcurrency method returns ResultSet Concurrency mode  " + rsConcur);
            } else {
                this.msg.printTestError("getResultSetConcurrency method does not return a valid value", "Call to getResultSetConcurrency is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getResultSetConcurrency is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getResultSetConcurrency is Failed!");
        }
    }

    public void testGetResultSetType01() throws Exception {
        int rsType = 0;
        try {
            rsType = this.stmt.getResultSetType();
            if (rsType == 1003) {
                this.msg.setMsg("getResultSetType method returns TYPE_FORWARD_ONLY" + rsType);
            } else if (rsType == 1004) {
                this.msg.setMsg("getResultSetType method returns TYPE_SCROLL_INSENSITIVE " + rsType);
            } else if (rsType == 1005) {
                this.msg.setMsg("getResultSetType method returns TYPE_SCROLL_SENSITIVE  " + rsType);
            } else {
                this.msg.printTestError(" getResultSetType method does not return a valid value", "Call to getResultSetType is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getResultSetType is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getResultSetType is Failed!");
        }
    }

    public void testGetResultSetType02() throws Exception {
        int rsType = 0;
        Statement statemt = null;
        try {
            this.msg.setMsg("Creating Statement object with the ResultSet Type and Type");
            statemt = this.conn.createStatement(1003, 1007);
            rsType = statemt.getResultSetType();
            if (rsType == 1003) {
                this.msg.setMsg("getResultSetType method returns TYPE_FORWARD_ONLY " + rsType);
            } else {
                statemt.close();
                this.msg.printTestError(" getResultSetType method does not return a valid value", "Call to getResultSetType is Failed!");
            }
            statemt.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getResultSetType is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getResultSetType is Failed!");
        }
    }

    public void testGetResultSetType03() throws Exception {
        int rsType = 0;
        Statement statemt = null;
        try {
            this.msg.setMsg("Creating Statement object with the ResultSet Type and Type");
            this.conn.clearWarnings();
            statemt = this.conn.createStatement(1004, 1007);
            rsType = statemt.getResultSetType();
            if (rsType == 1004) {
                this.msg.setMsg("getResultSetType method returns TYPE_SCROLL_INSENSITIVE " + rsType);
            } else {
                SQLWarning sqlw = this.conn.getWarnings();
                if (sqlw != null) {
                    this.msg.setMsg("TYPE_SCROLL_INSENSITIVE not supported. getResultSetType returned SQLWarnings");
                    this.conn.clearWarnings();
                    statemt.close();
                } else {
                    statemt.close();
                    this.msg.printTestError("TYPE_SCROLL_INSENSITIVE not supported. getResultSetType method did not generate SQLWarning", "Call to getResultSetType is Failed!");
                }
            }
            statemt.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getResultSetType is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getResultSetType is Failed!");
        }
    }

    public void testGetUpdateCount01() throws Exception {
        int updCountVal = 0;
        int rowsAffectVal = 0;
        try {
            String sSqlStmt = this.sqlp.getProperty("Upd_Coffee_Tab", "");
            this.msg.setMsg("Query String : " + sSqlStmt);
            this.stmt.executeUpdate(sSqlStmt);
            this.msg.setMsg("Calling getUpdateCount on Statement");
            updCountVal = this.stmt.getUpdateCount();
            String sQuery = this.sqlp.getProperty("Coffee_Updcount_Query", "");
            this.msg.setMsg("Query String : " + sQuery);
            ResultSet rs1 = this.stmt.executeQuery(sQuery);
            rs1.next();
            rowsAffectVal = rs1.getInt(1);
            this.msg.setMsg("Number of Rows Affected by Update Statement " + rowsAffectVal);
            if (updCountVal == rowsAffectVal) {
                this.msg.setMsg("getUpdateCount method returns :" + updCountVal);
            } else {
                this.msg.printTestError(" getUpdateCount method returns a invalid value", "Call to getUpdateCount is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getUpdateCount is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getUpdateCount is Failed!");
        }
    }

    public void testGetUpdateCount02() throws Exception {
        int updCountVal = 0;
        try {
            String sSqlStmt = this.sqlp.getProperty("SelCoffeeNull", "");
            this.msg.setMsg("Query String : " + sSqlStmt);
            this.stmt.execute(sSqlStmt);
            this.msg.setMsg("Calling getMoreResults on Statement");
            updCountVal = this.stmt.getUpdateCount();
            if (updCountVal == -1) {
                this.msg.setMsg("getUpdateCount method returns :" + updCountVal);
            } else {
                this.msg.printTestError(" getUpdateCount method returns a invalid value", "Call to getUpdateCount is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getUpdateCount is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getUpdateCount is Failed!");
        }
    }

    public void testGetWarnings() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            CallableStatement cstmt = this.conn.prepareCall("{call Integer_Proc(?,?,?)}");
            this.msg.setMsg("The Callable Statement " + cstmt);
            this.msg.setMsg("register the output parameters");
            cstmt.registerOutParameter(1, 4);
            cstmt.registerOutParameter(2, 4);
            cstmt.registerOutParameter(3, 4);
            this.msg.setMsg("execute the procedure");
            cstmt.executeUpdate();
            this.msg.setMsg("invoke getInt method");
            int nRetVal = cstmt.getInt(1);
            CallableStatement state = cstmt;
            this.msg.setMsg("Calling getWarnings method");
            SQLWarning sWarning = state.getWarnings();
            if (sWarning instanceof SQLWarning) {
                this.msg.setMsg("getWarnings method returns a SQLWarning object");
            } else if (sWarning == null) {
                this.msg.setMsg("getWarnings() method returns a null SQLWarning Object");
            }
            this.rsSch.dropTab("Integer_Tab", this.conn);
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getWarnings is Failed!");
        }
        catch (Exception ex) {
            this.msg.printError(ex, "Call to getWarnings is Failed!");
        }
    }

    public void testSetFetchDirection04() throws Exception {
        boolean sqlExceptFlag = false;
        try {
            this.msg.setMsg("Calling setFetchDirection method ");
            try {
                this.stmt.setFetchDirection(-1);
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                sqlExceptFlag = true;
            }
            if (sqlExceptFlag) {
                this.msg.setMsg("setFetchDirection method does not sets the invalid direction for the ResultSet ");
            } else {
                this.msg.printTestError("setFetchDirection method sets the invalid direction for ResultSet", "Call to setFetchDirection is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setFetchDirection is Failed");
        }
    }

    public void testSetFetchSize02() throws Exception {
        int maxFetchSizeVal = 50;
        int maxRowsVal = 0;
        int retVal = 0;
        try {
            this.msg.setMsg("invoking the getMaxRows method");
            this.stmt.setMaxRows(maxFetchSizeVal);
            maxRowsVal = this.stmt.getMaxRows();
            this.msg.setMsg("Maximum Rows that Statement can contain " + maxRowsVal);
            if (maxRowsVal == 0) {
                maxRowsVal = 25;
                this.msg.setMsg("Maximum Rows was 0 (zero) so reset to 25");
            }
            this.msg.setMsg("Calling the setFetchSize method");
            this.stmt.setFetchSize(maxRowsVal);
            this.msg.setMsg("invoke on the getFetchSize");
            retVal = this.stmt.getFetchSize();
            String str1 = "maxFetchSizeVal = " + maxFetchSizeVal + ".   retVal = " + retVal + ".";
            this.msg.setMsg(str1);
            this.msg.setMsg("maxRowsVal = " + maxRowsVal);
            if (maxFetchSizeVal == retVal) {
                this.msg.setMsg("setFetchSize method sets the value as FetchSize for ResultSet");
            } else {
                this.msg.printTestError("setFetchSize method does not set the value as Fetch Size for ResultSet", "Call to setFetchSize is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFetchSize is Failed");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setFetchSize is Failed");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.dbSch.destroyData(this.conn);
            this.stmt.close();
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

