/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.tx.common.web;

import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.io.PrintWriter;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TestServlet
extends HttpTCKServlet {
    private void doTest(HttpServletRequest request, HttpServletResponse response, String servletPath, Integer expectedTxStatus, Integer unexpectedTxStatus, boolean startTx) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        try {
            if (startTx) {
                TestServlet.getUserTransaction().begin();
            }
            RequestDispatcher disp = this.getServletContext().getRequestDispatcher(servletPath);
            disp.include((ServletRequest)request, (ServletResponse)response);
            int status = TestServlet.getUserTransaction().getStatus();
            if (expectedTxStatus == null && unexpectedTxStatus == null) {
                pw.println("Test PASSED, not checking tx status. The actual tx status is " + status);
            } else if (unexpectedTxStatus != null) {
                if (status == unexpectedTxStatus) {
                    pw.println("Test FAILED got unexpected status " + status);
                } else {
                    pw.println("Test PASSED got transaction status  " + status);
                }
            } else if (status == expectedTxStatus) {
                pw.println("Test PASSED got expected transaction status  " + status);
            } else {
                pw.println("Test FAILED expected tx status is " + expectedTxStatus + ", but actual status is " + status);
            }
        }
        catch (NamingException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SystemException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NotSupportedException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (startTx) {
                try {
                    TestServlet.getUserTransaction().rollback();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void newThreadNoTx(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final Boolean[] newThreadNoTxStatus = new Boolean[1];
        try {
            TestServlet.getUserTransaction().begin();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        int status = TestServlet.getUserTransaction().getStatus();
                        if (status != 6) {
                            newThreadNoTxStatus[0] = false;
                            throw new IllegalStateException("In new thread expecting no transaction, but got " + status);
                        }
                        System.out.println("New thread spawned by TestServlet has not transaction, as expected");
                        newThreadNoTxStatus[0] = true;
                    }
                    catch (NamingException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (SystemException e) {
                        throw new IllegalStateException(e);
                    }
                }
            };
            thread.setName("newThreadNoTx");
            thread.start();
            try {
                thread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (int i = 0; i < 99 && newThreadNoTxStatus[0] == null; ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            String msg = null;
            msg = newThreadNoTxStatus[0] == null ? "Test FAILED, timed out, didn't see update from new thread." : (newThreadNoTxStatus[0] != false ? "Test PASSED, no IllegalStateException from new thread." : "Test FAILED, got IllegalStateException from new thread.");
            PrintWriter pw = response.getWriter();
            pw.println(msg);
        }
        catch (NamingException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SystemException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NotSupportedException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                TestServlet.getUserTransaction().rollback();
            }
            catch (Exception exception) {}
        }
    }

    public void servletRemoteCmt(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = null;
        Integer unexpectedTxStatus = 0;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, false);
    }

    public void servletLocalCmt(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = null;
        Integer unexpectedTxStatus = 0;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, false);
    }

    public void servletRemoteCmtRequiresNew(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = 0;
        Integer unexpectedTxStatus = null;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, true);
    }

    public void servletLocalCmtRequiresNew(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = 0;
        Integer unexpectedTxStatus = null;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, true);
    }

    public void servletRemoteCmtMandatory(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = null;
        Integer unexpectedTxStatus = 0;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, false);
    }

    public void servletLocalCmtMandatory(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = null;
        Integer unexpectedTxStatus = 0;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, false);
    }

    public void servletRemoteCmtNever(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = 0;
        Integer unexpectedTxStatus = null;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, true);
    }

    public void servletLocalCmtNever(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = 0;
        Integer unexpectedTxStatus = null;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, true);
    }

    public void servletTxTerminate(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = null;
        Integer unexpectedTxStatus = null;
        this.doTest(request, response, "/foo", expected, unexpectedTxStatus, false);
    }

    public void interServletTxPropagation(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = 0;
        Integer unexpectedTxStatus = null;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, true);
    }

    public void interServletTxPropagation2(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer expected = null;
        Integer unexpectedTxStatus = 0;
        this.doTest(request, response, "/TxServlet", expected, unexpectedTxStatus, true);
    }

    public static UserTransaction getUserTransaction() throws NamingException {
        InitialContext ic = new InitialContext();
        Object obj = ic.lookup("java:comp/UserTransaction");
        return (UserTransaction)obj;
    }
}

