/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.util;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.integration.util.Account;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class DBSupport
implements Serializable {
    private static final String DATASOURCE = "java:comp/env/jdbc/DB1";
    private DataSource ds;
    private String tName;
    private TSNamingContext nctx;
    private transient Connection con = null;
    private String sqlString;
    private transient Statement stmt = null;
    private transient PreparedStatement pStmt = null;
    private Account account;

    public DBSupport() throws Exception {
        this.lookupDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDB(boolean initTab, boolean popTab) throws Exception {
        TestUtil.logTrace((String)"initDB");
        if (!initTab) {
            return;
        }
        TestUtil.logTrace((String)"Perform JDBC connection ...");
        try {
            this.con = this.getDBConnection();
            TestUtil.logTrace((String)"Made the JDBC connection");
        }
        catch (Exception ex) {
            TestUtil.logErr((String)("Unexpected exception getting JDBC connection " + ex.getMessage()));
            TestUtil.printStackTrace((Throwable)ex);
            throw ex;
        }
        try {
            this.sqlString = TestUtil.getProperty((String)"Integration_Tab_Delete");
            this.tName = TestUtil.getTableName((String)this.sqlString);
            this.stmt = this.con.createStatement();
            this.stmt.execute(this.sqlString);
            TestUtil.logTrace((String)("Deleted all rows from table " + this.tName));
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (popTab) {
            this.populateTable();
        }
    }

    private void lookupDataSource() throws Exception {
        try {
            this.nctx = new TSNamingContext();
            TestUtil.logTrace((String)"lookup: java:comp/env/jdbc/DB1");
            this.ds = (DataSource)this.nctx.lookup(DATASOURCE);
            TestUtil.logTrace((String)("ds: " + this.ds));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception in lookupDataSource: " + e);
        }
    }

    private Connection getDBConnection() throws Exception {
        try {
            if (this.con != null) {
                try {
                    this.closeDBConnection();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            this.con = this.ds.getConnection();
            if (this.con != null) {
                return this.con;
            }
            throw new Exception("Unable to get database connection");
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("SQLException caught in getDBConnection");
        }
    }

    private void closeDBConnection() throws Exception {
        if (this.con != null) {
            this.con.close();
            this.con = null;
        }
    }

    private void getAccount(int acct) throws Exception {
        try {
            this.con = this.getDBConnection();
            this.sqlString = TestUtil.getProperty((String)"Integration_Select_Account");
            this.pStmt = this.con.prepareStatement(this.sqlString);
            this.pStmt.setInt(1, acct);
            ResultSet result = this.pStmt.executeQuery();
            result.next();
            this.account = new Account(result.getInt("account"), result.getFloat("balance"));
            this.pStmt.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in getAccount");
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void populateTable() throws Exception {
        TestUtil.logTrace((String)"populateTable");
        TestUtil.logTrace((String)"Perform JDBC connection ...");
        try {
            this.con = this.getDBConnection();
            TestUtil.logTrace((String)"Made the JDBC connection");
        }
        catch (Exception ex) {
            TestUtil.logErr((String)("Unexpected exception getting JDBC connection " + ex.getMessage()));
            TestUtil.printStackTrace((Throwable)ex);
            throw ex;
        }
        try {
            this.stmt = this.con.createStatement();
            this.sqlString = TestUtil.getProperty((String)"Integration_Insert1");
            this.stmt.executeUpdate(this.sqlString);
            this.sqlString = TestUtil.getProperty((String)"Integration_Insert2");
            this.stmt.executeUpdate(this.sqlString);
            this.sqlString = TestUtil.getProperty((String)"Integration_Insert3");
            this.stmt.executeUpdate(this.sqlString);
            this.sqlString = TestUtil.getProperty((String)"Integration_Insert4");
            this.stmt.executeUpdate(this.sqlString);
            this.sqlString = TestUtil.getProperty((String)"Integration_Insert5");
            this.stmt.executeUpdate(this.sqlString);
            TestUtil.logTrace((String)("Successfully created the table " + this.tName));
            TestUtil.logTrace((String)"jdbc connection closed");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception creating table " + this.tName + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void updateAccount() throws Exception {
        try {
            this.con = this.getDBConnection();
            this.sqlString = TestUtil.getProperty((String)"Integration_Update_Account");
            this.pStmt = this.con.prepareStatement(this.sqlString);
            this.pStmt.setFloat(1, (float)this.account.balance());
            this.pStmt.setInt(2, this.account.id());
            this.pStmt.executeUpdate();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in updateAccount");
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void updateAccount(int acct, double balance) throws Exception {
        try {
            this.con = this.getDBConnection();
            this.sqlString = TestUtil.getProperty((String)"Integration_Update_Account");
            this.pStmt = this.con.prepareStatement(this.sqlString);
            this.pStmt.setFloat(1, (float)balance);
            this.pStmt.setInt(2, acct);
            this.pStmt.executeUpdate();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in updateAccount");
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public double balance(int acct) throws Exception {
        try {
            this.getAccount(acct);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in getBalance");
        }
        return this.account.balance();
    }

    public double deposit(int acct, double amt) throws Exception {
        try {
            this.getAccount(acct);
            this.account.deposit(amt);
            this.updateAccount();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in getBalance");
        }
        return this.account.balance();
    }

    public double withdraw(int acct, double amt) throws Exception {
        try {
            this.getAccount(acct);
            this.account.withdraw(amt);
            this.updateAccount();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in getBalance");
        }
        return this.account.balance();
    }

    public String getAllAccounts() throws Exception {
        StringBuffer accounts = new StringBuffer();
        try {
            this.con = this.getDBConnection();
            this.stmt = this.con.createStatement();
            this.sqlString = TestUtil.getProperty((String)"Integration_Select_All");
            ResultSet result = this.stmt.executeQuery(this.sqlString);
            while (result.next()) {
                this.account = new Account(result.getInt("account"), result.getFloat("balance"));
                accounts.append(this.account.id() + "  " + this.account.balance() + "\n");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in getAllAccounts");
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return accounts.toString();
    }

    public void insert(int account, double balance) throws Exception {
        TestUtil.logTrace((String)"insert");
        try {
            this.con = this.getDBConnection();
            this.sqlString = TestUtil.getProperty((String)"Integration_Insert");
            TestUtil.logMsg((String)this.sqlString);
            this.pStmt = this.con.prepareStatement(this.sqlString);
            this.pStmt.setInt(1, account);
            this.pStmt.setFloat(2, (float)balance);
            this.pStmt.executeUpdate();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in insert");
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void delete(int acct) throws Exception {
        TestUtil.logTrace((String)"delete");
        try {
            this.con = this.getDBConnection();
            this.sqlString = TestUtil.getProperty((String)"Integration_Delete_Account");
            TestUtil.logMsg((String)this.sqlString);
            this.pStmt = this.con.prepareStatement(this.sqlString);
            this.pStmt.setInt(1, acct);
            int resultCount = this.pStmt.executeUpdate();
            if (resultCount != 1) {
                throw new Exception("delete failed: resultCount = " + resultCount);
            }
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in delete");
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public boolean keyExists(int acct) throws Exception {
        try {
            this.con = this.getDBConnection();
            this.sqlString = TestUtil.getProperty((String)"Integration_Select_Account");
            this.pStmt = this.con.prepareStatement(this.sqlString);
            this.pStmt.setInt(1, acct);
            ResultSet result = this.pStmt.executeQuery();
            if (!result.next()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception caught in getAccount");
        }
        finally {
            try {
                if (this.pStmt != null) {
                    this.pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }
}

