/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.From;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.List;

public class Client2
extends Util {
    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupCustomerData")
    public void joinStringTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join("work");
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void joinStringJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join("work", JoinType.INNER);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void joinSingularAttributeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join(Customer_.work);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinSingularAttributeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void joinSingularAttributeJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join(Customer_.work, JoinType.INNER);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinSingularAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fromGetCorrelationParentTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.correlate(customer);
            boolean isCorr = sqc.isCorrelated();
            if (isCorr) {
                this.logTrace("From.isCorrelated() return true");
                pass1 = true;
            } else {
                this.logErr("Expected From.isCorrelated() to return true, actual:" + isCorr);
            }
            From f = sqc.getCorrelationParent();
            String name = f.getJavaType().getSimpleName();
            if (name.equals("Customer")) {
                this.logTrace("Received expected parent:" + name);
                pass2 = true;
            } else {
                this.logErr("Expected getCorrelationParent() to return Customer, actual:" + name);
            }
            Join w = sqc.join("work");
            sq.select((Expression)w.get("state"));
            sq.where((Expression)cbuilder.equal((Expression)w.get("state"), (Expression)cbuilder.parameter(String.class, "state")));
            cquery.where((Expression)customer.get("home").get("state").in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("state", (Object)"MA");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "11", "13", "15", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_in:  Did not get expected results.  Expected 11 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass3 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("fromGetCorrelationParentTest failed");
        }
    }
}

