/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.exceptionTopic;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExceptionTopicTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.exceptionTopic.ExceptionTopicTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ExceptionTopicTestsIT.class.getName());
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "In setup");
            this.jmsUser = System.getProperty("user");
            this.jmsPassword = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
            this.connections = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void xInvalidDestinationExceptionTopicTest() throws Exception {
        boolean pass = true;
        TopicPublisher tPublisher = null;
        TopicSubscriber tSubscriber = null;
        Topic dummy = null;
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            logger.log(System.Logger.Level.TRACE, "** Close default TopicSubscriber **");
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Test unsubscribe(invalidSubscriptionName)");
            try {
                this.tool.getDefaultTopicSession().unsubscribe("invalidSubscriptionName");
                logger.log(System.Logger.Level.TRACE, "FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: InvalidDestinationException thrown as expected");
                }
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test createSubscriber(null)");
            try {
                tSubscriber = this.tool.getDefaultTopicSession().createSubscriber(dummy);
                logger.log(System.Logger.Level.TRACE, "FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: InvalidDestinationException thrown as expected");
                }
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test createSubscriber(null,selector,nolocal)");
            try {
                tSubscriber = this.tool.getDefaultTopicSession().createSubscriber(dummy, "TEST", true);
                logger.log(System.Logger.Level.TRACE, "FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: InvalidDestinationException thrown as expected");
                }
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test createDurableSubscriber(null,String)");
            try {
                tSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(dummy, "durable");
                logger.log(System.Logger.Level.TRACE, "FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: InvalidDestinationException thrown as expected");
                }
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test createDurableSubscriber(null,String,selector,nolocal)");
            try {
                tSubscriber = this.tool.getDefaultTopicSession().createDurableSubscriber(dummy, "durable", "TEST", true);
                logger.log(System.Logger.Level.TRACE, "FAIL: expected InvalidDestinationException!");
                pass = false;
            }
            catch (Exception ee) {
                if (ee instanceof InvalidDestinationException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: InvalidDestinationException thrown as expected");
                }
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test createPublisher(null) - This is valid");
            try {
                tPublisher = this.tool.getDefaultTopicSession().createPublisher(dummy);
                if (tPublisher != null) {
                    logger.log(System.Logger.Level.INFO, "tPublisher=" + tPublisher);
                }
                logger.log(System.Logger.Level.TRACE, "PASS: null allowed for unidentified producer");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.ERROR, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during xInvalidDestinationExceptionQTest tests");
            }
        }
        catch (Exception e) {
            throw new Exception("xInvalidDestinationExceptionTopicTest", e);
        }
    }

    @Test
    public void xMessageNotReadableExceptionTopicTest() throws Exception {
        try {
            BytesMessage msg = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            msg = this.tool.getDefaultTopicSession().createBytesMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionTopicTest");
            try {
                msg.readByte();
                logger.log(System.Logger.Level.ERROR, "FAIL --- should not have gotten this far!");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.INFO, "Passed with expected MessageNotReadableException.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Expected MessageNotReadableException did not occur:", (Throwable)e);
            throw new Exception("xMessageNotReadableExceptionTopicTest test failed", e);
        }
    }

    @Test
    public void xMessageNotWriteableExceptionTTestforTextMessage() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionTTestforTextMessage");
            logger.log(System.Logger.Level.TRACE, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.setText("testing...");
            }
            catch (MessageNotWriteableException nr) {
                logger.log(System.Logger.Level.INFO, "Passed with expected MessageNotWriteableException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "xMessageNotWriteableExceptionTTestforTextMessage failed:", (Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionTTestforTextMessage", e);
        }
    }

    @Test
    public void xMessageNotWriteableExceptionTestforBytesMessage() throws Exception {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionTestforBytesMessage");
            logger.log(System.Logger.Level.TRACE, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.writeByte(bValue);
            }
            catch (MessageNotWriteableException nr) {
                logger.log(System.Logger.Level.INFO, "Passed with expected MessageNotWriteableException.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "xMessageNotWriteableExceptionTestforBytesMessage failed: ", (Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionTestforBytesMessage", e);
        }
    }

    @Test
    public void xMessageNotWriteableExceptionTTestforStreamMessage() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionTTestforStreamMessage");
            messageSent.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.writeString("Testing...");
            }
            catch (MessageNotWriteableException nr) {
                logger.log(System.Logger.Level.TRACE, "Passed with expected MessageNotWriteableException");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "xMessageNotWriteableExceptionTTestforStreamMessage failed: ", (Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionTTestforStreamMessage", e);
        }
    }

    @Test
    public void xMessageNotWriteableExceptionTTestforMapMessage() throws Exception {
        try {
            MapMessage messageSent = null;
            MapMessage messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotWriteableExceptionTTestforMapMessage");
            messageSent.setString("aString", "value");
            logger.log(System.Logger.Level.TRACE, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.setString("aString", "value");
            }
            catch (MessageNotWriteableException nr) {
                logger.log(System.Logger.Level.INFO, "Passed with expected MessageNotWriteableException occurred.");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "xMessageNotWriteableExceptionTTestforMapMessage failed: ", (Throwable)e);
            throw new Exception("xMessageNotWriteableExceptionTTestforMapMessage", e);
        }
    }

    @Test
    public void xNullPointerExceptionTopicTest() throws Exception {
        try {
            BytesMessage msg = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            msg = this.tool.getDefaultTopicSession().createBytesMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "xNullPointerExceptionTopicTest");
            msg.writeBytes(null);
        }
        catch (NullPointerException nullp) {
            logger.log(System.Logger.Level.INFO, "Passed with expected NullPointerException.");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Expected NullPointerException did not occur!", (Throwable)e);
            throw new Exception("xNullPointerExceptionTopicTest");
        }
    }

    @Test
    public void xMessageEOFExceptionTTestforBytesMessage() throws Exception {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageEOFExceptionTTestforBytesMessage");
            logger.log(System.Logger.Level.TRACE, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            messageReceived.readByte();
            try {
                messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Failed:  expected MessageEOFException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageEOFException end) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageEOFException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + end.getMessage());
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageEOFExceptionTTestforBytesMessage", e);
        }
    }

    @Test
    public void xMessageEOFExceptionTTestforStreamMessage() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.writeByte(bValue);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageEOFExceptionTTestforStreamMessage");
            logger.log(System.Logger.Level.TRACE, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            messageReceived.readByte();
            try {
                messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Failed:  expected MessageEOFException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageEOFException end) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageEOFException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + end.getMessage());
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageEOFExceptionTTestforStreamMessage", e);
        }
    }

    @Test
    public void xMessageFormatExceptionTTestforBytesMessage() throws Exception {
        try {
            BytesMessage messageSent = null;
            Object messageReceived = null;
            int bValue = 127;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageFormatExceptionTTestforBytesMessage");
            logger.log(System.Logger.Level.TRACE, "try to write an invalid object");
            try {
                messageSent.writeObject((Object)this.tool.getDefaultTopicSession());
                logger.log(System.Logger.Level.TRACE, "Failed:  expected MessageFormatException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageFormatException fe) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageFormatException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + fe.getMessage());
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageFormatExceptionTTestforBytesMessage", e);
        }
    }

    @Test
    public void xMessageFormatExceptionTTestforStreamMessage() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte[] bValues = new byte[]{127, 0, 3};
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.writeBytes(bValues);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageFormatExceptionTTestforStreamMessage");
            logger.log(System.Logger.Level.TRACE, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("getMessage returned null!! - test did not run!");
            }
            logger.log(System.Logger.Level.TRACE, "Got message - OK");
            try {
                messageReceived.readString();
                logger.log(System.Logger.Level.TRACE, "Failed:  expected MessageFormatException not thrown");
                throw new Exception("Fail: Did not throw expected error!!!");
            }
            catch (MessageFormatException fe) {
                logger.log(System.Logger.Level.TRACE, "Passed.\n");
                logger.log(System.Logger.Level.TRACE, "MessageFormatException occurred!");
                logger.log(System.Logger.Level.TRACE, " " + fe.getMessage());
            }
        }
        catch (Exception e) {
            throw new Exception("xMessageFormatExceptionTTestforStreamMessage", e);
        }
    }

    @Test
    public void xInvalidSelectorExceptionTopicTest() throws Exception {
        try {
            TopicSubscriber tSub = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            logger.log(System.Logger.Level.TRACE, "** Close default TopicSubscriber **");
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicConnection().start();
            tSub = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "=TEST 'test'", false);
            logger.log(System.Logger.Level.TRACE, "FAIL --- should not have gotten this far!");
            throw new Exception("xInvalidSelectorException test Failed!");
        }
        catch (InvalidSelectorException es) {
            logger.log(System.Logger.Level.TRACE, "Passed.\n");
            logger.log(System.Logger.Level.INFO, "InvalidSelectorException occurred!");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Got Exception instead: ", (Throwable)e);
            logger.log(System.Logger.Level.TRACE, "Expected InvalidSelectorException did not occur!");
            throw new Exception("xInvalidSelectorExceptionTopicTest eee", e);
        }
    }

    @Test
    public void xIllegalStateExceptionTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Calling session.commit(), an illegal operation.");
            try {
                this.tool.getDefaultTopicSession().commit();
            }
            catch (IllegalStateException iStateE) {
                logger.log(System.Logger.Level.INFO, "Received jakarta.jms.IllegalStateException -- GOOD");
                passed = true;
            }
            if (!passed) {
                throw new Exception("Did not receive IllegalStateException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xIllegalStateExceptionTopicTest");
        }
    }

    @Test
    public void xUnsupportedOperationExceptionTTest1() throws Exception {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            Topic myTopic = null;
            TopicPublisher tPub = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultTopicPublisher().close();
            tPub = this.tool.getDefaultTopicSession().createPublisher(myTopic);
            this.tool.getDefaultTopicConnection().start();
            try {
                messageSent = this.tool.getDefaultTopicSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionTTest1");
                logger.log(System.Logger.Level.TRACE, "sending a Text message");
                tPub.publish((Message)messageSent);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: TopicPublisher.publish(Message) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected UnsupportedOperationException from  TopicPublisher.publish(Message)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error:  TopicPublisher.publish(Message) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                messageSent = this.tool.getDefaultTopicSession().createTextMessage();
                messageSent.setText("sending a Text message");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xUnsupportedOperationExceptionTTest1");
                logger.log(System.Logger.Level.TRACE, "sending a Text message");
                tPub.publish((Message)messageSent, 2, 4, 0L);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: TopicPublisher.publish(Message, int, int, long) didn't throw expected UnsupportedOperationException.");
            }
            catch (UnsupportedOperationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected UnsupportedOperationException from  TopicPublisher.publish(Message, int, int, long)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error:  TopicPublisher.publish(Message, int, int, long) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xUnsupportedOperationExceptionTTest1 Failed!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "xUnsupportedOperationExceptionTTest1 Failed!", (Throwable)e);
            throw new Exception("xUnsupportedOperationExceptionTTest1 Failed!", e);
        }
        finally {
            try {
                if (this.tool.getDefaultTopicConnection() != null) {
                    this.tool.getDefaultTopicConnection().close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception closing TopicConnection and cleanup", (Throwable)e);
            }
        }
    }

    @Test
    public void xInvalidDestinationExceptionTTests() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            boolean pass = true;
            Destination dummy = null;
            Object dummyT = null;
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(dummy);
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'");
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'", true);
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null, String, true)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String, true) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing default Connection", (Throwable)ex);
            }
            if (!pass) {
                throw new Exception("xInvalidDestinationExceptionTTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xInvalidDestinationExceptionTTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void xMessageNotReadableExceptionTBytesMsgTest() throws Exception {
        try {
            BytesMessage messageSent = null;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            String utfValue = "what";
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionTBytesMsgTest");
            logger.log(System.Logger.Level.INFO, "Writing one of each primitive type to the message");
            messageSent.writeBoolean(booleanValue);
            messageSent.writeByte(byteValue);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(doubleValue);
            messageSent.writeFloat(floatValue);
            messageSent.writeInt(intValue);
            messageSent.writeLong(longValue);
            messageSent.writeObject((Object)nInteger);
            messageSent.writeShort(shortValue);
            messageSent.writeUTF(utfValue);
            messageSent.writeBytes(bytesValue);
            messageSent.writeBytes(bytesValue, 0, 1);
            try {
                messageSent.getBodyLength();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: getBodyLength didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "getBodyLength threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "getBodyLength threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBoolean();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBoolean didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBoolean threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBoolean threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readByte();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUnsignedByte();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readUnsignedByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readUnsignedByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readUnsignedByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readShort();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUnsignedShort();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readUnsignedShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readUnsignedShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readUnsignedShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readChar();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readChar didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readChar threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readChar threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readInt();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readInt didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readInt threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readInt threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readLong();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readLong didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readLong threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readLong threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readFloat();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readFloat didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readFloat threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readFloat threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readDouble();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readDouble didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readDouble threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readDouble threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readUTF();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readUTF didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readUTF threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readUTF threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBytes(bytesValueRecvd);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBytes(byte[]) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBytes(byte[]) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBytes(byte[]) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageSent.readBytes(bytesValueRecvd, 1);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBytes(byte[], int) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBytes(byte[], int) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBytes(byte[],int) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xMessageNotReadableExceptionTBytesMsgTest Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotReadableExceptionTBytesMsgTest:");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void xMessageNotReadableExceptionTStreamMsgTest() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            byte[] bValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            this.tool.getDefaultConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "xMessageNotReadableExceptionTStreamMsgTest");
            logger.log(System.Logger.Level.TRACE, "");
            logger.log(System.Logger.Level.INFO, "Writing one of each primitive type to the message");
            messageSent.writeBytes(bValues2, 0, bValues.length);
            messageSent.writeBoolean(abool);
            messageSent.writeByte(bValue);
            messageSent.writeBytes(bValues);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(dValue);
            messageSent.writeFloat(fValue);
            messageSent.writeInt(iValue);
            messageSent.writeLong(lValue);
            messageSent.writeObject((Object)sTesting);
            messageSent.writeShort(sValue);
            messageSent.writeString(myString);
            messageSent.writeObject(null);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultProducer().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "call ClearBody()");
            messageReceived.clearBody();
            try {
                messageReceived.readBoolean();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBoolean didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBoolean threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBoolean threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readByte();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readByte didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readByte threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readByte threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readShort();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readShort didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readShort threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readShort threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readChar();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readChar didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readChar threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readChar threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readInt();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readInt didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readInt threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readInt threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readLong();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readLong didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readLong threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readLong threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readFloat();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readFloat didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readFloat threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readFloat threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readDouble();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readDouble didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readDouble threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readDouble threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readString();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readString didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readString threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readString threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readBytes(bValuesReturned);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readBytes(byte[]) didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readBytes(byte[]) threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readBytes(byte[]) threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            try {
                messageReceived.readObject();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: readObject didn't throw Expected MessageNotReadableException!");
            }
            catch (MessageNotReadableException nr) {
                logger.log(System.Logger.Level.TRACE, "readObject threw Expected MessageNotReadableException!");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "readObject threw Wrong Exception!", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xMessageNotReadableExceptionTStreamMsgTest Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xMessageNotReadableExceptionTStreamMsgTest:");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void xIllegalStateExceptionTestQueueMethodsT() throws Exception {
        try {
            boolean pass = true;
            Queue myQueue = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.lookup, this.mode);
            myQueue = this.tool.createNewQueue("MY_QUEUE");
            try {
                this.tool.getDefaultTopicSession().createBrowser(myQueue);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: TopicSession.createBrowser(Queue) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from TopicSession.createBrowser(Queue)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: TopicSession.createBrowser(Queue) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultTopicSession().createBrowser(myQueue, "TEST = 'test'");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: TopicSession.createBrowser(Queue, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from TopicSession.createBrowser(Queue, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: TopicSession.createBrowser(Queue, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultTopicSession().createTemporaryQueue();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: TopicSession.createTemporayQueue() didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from TopicSession.createTemporayQueue()");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: TopicSession.createTemporayQueue() throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultTopicSession().createQueue("foo");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: TopicSession.createQueue(String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from TopicSession.createQueue(String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: TopicSession.createQueue(String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("xIllegalStateExceptionTestQueueMethodsT Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("xIllegalStateExceptionTestQueueMethodsT");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }
}

