/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.streamMsgTopic;

import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.StreamMessage;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StreamMsgTopicTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.streamMsgTopic.StreamMsgTopicTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(StreamMsgTopicTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
        }
        catch (Exception e) {
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning: ");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsBoolean() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsBoolean");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for boolean primitive type section 3.11.3");
            messageSent.writeBoolean(abool);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a boolean");
            try {
                if (messageReceived.readBoolean() == abool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean to boolean - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a boolean");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Boolean.valueOf(abool).toString())) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read a boolean - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readByte();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readShort();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readChar();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readInt();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readLong();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readFloat();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readDouble();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsBoolean", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsByte() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsByte");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeByte(bValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Byte.toString(bValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read a byte - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to byte - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to short - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                pass = false;
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to int - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to long - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsByte", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsShort() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            short sValue = 1;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsShort");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeShort(sValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a short - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Short.toString(sValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read a short - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a short - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == sValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to short - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a short - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == sValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to int - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)sValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to long - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a short - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read a short - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsShort", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsInt() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsInt");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeInt(iValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read an int - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Integer.toString(iValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read an int - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read an int - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read an int");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read an int - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == iValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to int - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)iValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to long - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read an int - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read an int - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsInt", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsLong() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsLong");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeLong(lValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a long - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Long.toString(lValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: long to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read  a long - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read an long - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a long");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a long - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a long");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == lValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to long - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a long - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read an long - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsLong", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsFloat() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsFloat");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeFloat(fValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a float  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a float");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Float.toString(fValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to string - valid");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read  a float ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a float  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a float");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a long  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a float");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a long");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == fValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to float - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read an float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == (double)fValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to double - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsFloat", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsDouble() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsDouble");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeDouble(dValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a double  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a double");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Double.toString(dValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: double to string");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read  a double ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a double  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a double");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a double  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a double");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a double");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a double  ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read a double  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == dValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: double to double ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsDouble", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsString() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            String myString = "10";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsString");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeString(myString);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: string to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read a String");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == Byte.parseByte(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to byte ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a string");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == Short.parseShort(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to short ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a String ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == Integer.parseInt(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to int ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == Long.parseLong(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to long ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == Float.parseFloat(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to float ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == Double.parseDouble(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to double ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a string ");
            try {
                messageReceived.clearBody();
                messageReceived.writeString("true");
                messageReceived.reset();
                if (messageReceived.readBoolean() == abool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to boolean ");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a string  that is !true ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                if (!b) {
                    logger.log(System.Logger.Level.ERROR, "Fail: !true should return false");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Pass: !true returned false");
                }
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsString", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsChar() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            char charValue = 'a';
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsChar");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeChar(charValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a char - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a char");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                logger.log(System.Logger.Level.TRACE, "char returned for \"a\" is : " + s);
                if (s.equals("a")) {
                    logger.log(System.Logger.Level.TRACE, "Pass: char to string - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read a char - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a char - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a char");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a char ");
            try {
                messageReceived.reset();
                if (messageReceived.readChar() == 'a') {
                    logger.log(System.Logger.Level.TRACE, "Pass: char to char - valid");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a char ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a char");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a char - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read a char - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsChar", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsBytes() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{1, 2, 3};
            byte[] bValues2 = new byte[]{0, 0, 0};
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsBytes");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte[] primitive type section 3.11.3");
            messageSent.writeBytes(bValues);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBytes[] to read a byte[] ");
            boolean nCount = false;
            try {
                messageReceived.reset();
                if (messageReceived.readBytes(bValues2) == 3) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte[] to byte[] - valid");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: count incorrect");
                    pass = false;
                }
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readBoolean to read a byte[]");
            messageReceived.reset();
            try {
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.ERROR, "Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readString to read a byte[]");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                logger.log(System.Logger.Level.ERROR, "Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readChar to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.ERROR, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsBytes", e);
        }
    }

    @Test
    public void streamMessageConversionTopicTestsInvFormatString() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            String myString = "mytest string";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsInvFormatString");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeString(myString);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readByte to read a String that is not valid ");
            try {
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.ERROR, "Fail: java.lang.NumberFormatException expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Verify that the data can be read as a string and pointer did not move");
            try {
                String s = messageReceived.readString();
                logger.log(System.Logger.Level.TRACE, "message read: " + s);
                if (s.equals(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: able to read the string");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: string not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readShort to read a string that is not valid ");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.ERROR, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readInt to read a String that is not valid ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.ERROR, "Fail: NumberFormatException was expected");
            }
            catch (NumberFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readLong to read a String that is not valid ");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.ERROR, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readFloat to read a String that is not valid ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.ERROR, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "--");
            logger.log(System.Logger.Level.INFO, "Use readDouble to read a String that is not valid ");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: Unexpected exception: ", (Throwable)ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageConversionTopicTestsInvFormatString", e);
        }
    }

    @Test
    public void streamMessageTopicTestsFullMsg() throws Exception {
        try {
            int i;
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            byte[] bValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] bValuesReturned2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            boolean pass = true;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageTopicTestsFullMsg");
            logger.log(System.Logger.Level.TRACE, "");
            messageSent.writeBoolean(abool);
            messageSent.writeByte(bValue);
            messageSent.writeBytes(bValues);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(dValue);
            messageSent.writeFloat(fValue);
            messageSent.writeInt(iValue);
            messageSent.writeLong(lValue);
            messageSent.writeObject((Object)sTesting);
            messageSent.writeShort(sValue);
            messageSent.writeString(myString);
            messageSent.writeBytes(bValues2, 0, bValues.length);
            messageSent.writeObject(null);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            try {
                if (messageReceived.readBoolean() == abool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean returned ok");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: boolean not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceived.readByte() == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Byte returned ok");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: Byte not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                int nCount;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned);
                    logger.log(System.Logger.Level.TRACE, "nCount is " + nCount);
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned.length; ++i) {
                        if (bValuesReturned[i] != bValues[i]) {
                            logger.log(System.Logger.Level.INFO, "Fail: byte[] " + i + " is not valid");
                            pass = false;
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "PASS: byte[]" + i + " is valid");
                    }
                } while (nCount >= bValuesReturned.length);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceived.readChar() == charValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct char");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: char not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceived.readDouble() == dValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct double");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: double not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceived.readFloat() == fValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct float");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: float not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceived.readInt() == iValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct int");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: int not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceived.readLong() == lValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct long");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: long not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceived.readObject().equals(sTesting)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct object");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                short tmp = messageReceived.readShort();
                if (tmp == sValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct short");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: short not returned as expected");
                    logger.log(System.Logger.Level.ERROR, "Expecting =" + sValue + ", got =" + tmp + ".");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                String tmp = messageReceived.readString();
                if (tmp.equals(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct string");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: string not returned as expected");
                    logger.log(System.Logger.Level.ERROR, "Expecting =" + myString + ", got =" + tmp + ".");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                int nCount;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned2);
                    logger.log(System.Logger.Level.TRACE, "nCount is " + nCount);
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned2.length; ++i) {
                        if (bValuesReturned2[i] != bValues2[i]) {
                            logger.log(System.Logger.Level.INFO, "Fail: byte[] " + i + " is not valid");
                            pass = false;
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "PASS: byte[]" + i + " is valid");
                    }
                } while (nCount >= bValuesReturned2.length);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            try {
                if (messageReceived.readObject() == null) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct object");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageTopicTestsFullMsg", e);
        }
    }

    @Test
    public void streamMessageTopicTestNull() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageTopicTestNull");
            logger.log(System.Logger.Level.TRACE, "writeString(null) ");
            try {
                messageSent.writeString(null);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception " + e.getClass().getName() + " was thrown");
                throw new Exception("Error: failed to write a null object with writeString", e);
            }
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "  ");
            try {
                if (messageReceived.readObject() == null) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Read a null");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: null value not returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error trying to read a null object");
                logger.log(System.Logger.Level.ERROR, "Error: unexpected exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageTopicTestNull", e);
        }
    }

    @Test
    public void streamMessageQNotWritable() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            short sValue = Short.MAX_VALUE;
            char cValue = '\uffff';
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            float fValue = 0.0f;
            double dValue = -0.0;
            String ssValue = "abc";
            byte[] bbValue = new byte[]{0, 88, 127};
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageQNotWritable");
            try {
                messageSent.writeString("Test Message for streamMessageQNotWritable");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception " + e.getClass().getName() + " was thrown");
                throw new Exception("Error: failed to writeString", e);
            }
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Writing a boolean ... ");
            try {
                messageReceived.writeBoolean(pass);
                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                throw new Exception("Error: test failed to be able to writeBoolean");
            }
            catch (MessageNotWriteableException e) {
                logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeBoolean");
                logger.log(System.Logger.Level.INFO, "Writing a byte ... ");
                try {
                    messageReceived.writeByte(bValue);
                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                    throw new Exception("Error: test failed to be able to writeByte");
                }
                catch (MessageNotWriteableException e2) {
                    logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeByte");
                    logger.log(System.Logger.Level.INFO, "Writing a short ... ");
                    try {
                        messageReceived.writeShort(sValue);
                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                        throw new Exception("Error: test failed to be able to writeShort");
                    }
                    catch (MessageNotWriteableException e3) {
                        logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeShort");
                        logger.log(System.Logger.Level.INFO, "Writing a char ... ");
                        try {
                            messageReceived.writeChar(cValue);
                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                            throw new Exception("Error: test failed to be able to writeChar");
                        }
                        catch (MessageNotWriteableException e4) {
                            logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeChar");
                            logger.log(System.Logger.Level.INFO, "Writing a int ... ");
                            try {
                                messageReceived.writeInt(iValue);
                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                throw new Exception("Error: test failed to be able to writeInt");
                            }
                            catch (MessageNotWriteableException e5) {
                                logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeInt");
                                logger.log(System.Logger.Level.INFO, "Writing a long ... ");
                                try {
                                    messageReceived.writeLong(lValue);
                                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                    throw new Exception("Error: test failed to be able to writeLong");
                                }
                                catch (MessageNotWriteableException e6) {
                                    logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeLong");
                                    logger.log(System.Logger.Level.INFO, "Writing a float ... ");
                                    try {
                                        messageReceived.writeFloat(fValue);
                                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                        throw new Exception("Error: test failed to be able to writeFloat");
                                    }
                                    catch (MessageNotWriteableException e7) {
                                        logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeFloat");
                                        logger.log(System.Logger.Level.INFO, "Writing a double ... ");
                                        try {
                                            messageReceived.writeDouble(dValue);
                                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                            throw new Exception("Error: test failed to be able to writeDouble");
                                        }
                                        catch (MessageNotWriteableException e8) {
                                            logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeDouble");
                                            logger.log(System.Logger.Level.INFO, "Writing a bytes... ");
                                            try {
                                                messageReceived.writeBytes(bbValue);
                                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                throw new Exception("Error: test failed to be able to writeBytes");
                                            }
                                            catch (MessageNotWriteableException e9) {
                                                logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeBytes");
                                                logger.log(System.Logger.Level.INFO, "Writing a string ... ");
                                                try {
                                                    messageReceived.writeString(ssValue);
                                                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                    throw new Exception("Error: test failed to be able to writeString");
                                                }
                                                catch (MessageNotWriteableException e10) {
                                                    logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeString");
                                                    logger.log(System.Logger.Level.INFO, "Writing a object ... ");
                                                    try {
                                                        messageReceived.writeObject((Object)new Integer(iValue));
                                                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                        throw new Exception("Error: test failed to be able to writeObject");
                                                    }
                                                    catch (MessageNotWriteableException e11) {
                                                        logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeObject");
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception("streamMessageQNotWritable", e);
        }
    }
}

