/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.TextMessageTestImpl;
import com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests.MyCompletionListener;
import com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests.MyMessageListener;
import jakarta.jms.CompletionListener;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient Queue queue = null;
    private transient Session session = null;
    private transient Destination destination = null;
    private transient Connection connection = null;
    private transient MessageConsumer consumer = null;
    private transient MessageProducer producer = null;
    private transient JMSContext context = null;
    private transient JMSContext contextToSendMsg = null;
    private transient JMSContext contextToCreateMsg = null;
    private transient JMSConsumer jmsconsumer = null;
    private transient JMSProducer jmsproducer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;
    boolean jmscontextTest = false;

    private void setupForQueue2() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q setup");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            this.tool.getDefaultConnection().close();
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
            this.contextToCreateMsg = this.cf.createContext(this.user, this.password, 1);
            this.jmsconsumer = this.context.createConsumer(this.destination);
            this.jmsproducer = this.contextToSendMsg.createProducer();
            this.jmscontextTest = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("setupForQueue2 failed!", e);
        }
    }

    private void setupForQueue() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q setup");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.consumer = this.tool.getDefaultConsumer();
            this.producer = this.tool.getDefaultProducer();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            this.connection.start();
            this.jmscontextTest = false;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("setupForQueue failed!", e);
        }
    }

    private void setupForQueueWithMultipleSessions() throws Exception {
        Connection newConnection = null;
        Session newSession = null;
        boolean transacted = false;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q setup");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.producer = this.tool.getDefaultProducer();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            newConnection = this.tool.getNewConnection(0, this.user, this.password);
            newSession = newConnection.createSession(transacted, 1);
            this.consumer = newSession.createConsumer(this.destination);
            this.connection.start();
            this.jmscontextTest = false;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("setupForQueue failed!", e);
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(3);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Close Consumer objects");
            if (this.jmscontextTest) {
                if (this.jmsconsumer != null) {
                    this.jmsconsumer.close();
                    this.jmsconsumer = null;
                }
                logger.log(System.Logger.Level.INFO, "Close JMSContext objects");
                if (this.context != null) {
                    this.context.close();
                    this.context = null;
                }
                if (this.contextToSendMsg != null) {
                    this.contextToSendMsg.close();
                    this.contextToSendMsg = null;
                }
                if (this.contextToCreateMsg != null) {
                    this.contextToCreateMsg.close();
                    this.contextToCreateMsg = null;
                }
            } else if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
            this.tool.flushDestination();
            this.tool.closeAllResources();
            this.tool.getDefaultConnection().close();
            this.producer = null;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
    }

    @Test
    public void illegalStateExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Testing Connection.close() from CompletionListener (expect IllegalStateException)");
            try {
                this.setupForQueue();
                MyCompletionListener listener = new MyCompletionListener(this.connection);
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage("Call connection close method");
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest1");
                logger.log(System.Logger.Level.INFO, "Send async message specifying CompletionListener to recieve async message");
                logger.log(System.Logger.Level.INFO, "CompletionListener will call Connection.close() (expect IllegalStateException)");
                this.producer.send((Message)expTextMessage, (CompletionListener)listener);
                Object actTextMessage = null;
                logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                for (int i = 0; i < 30; ++i) {
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        break;
                    }
                    TestUtil.sleepSec((int)2);
                }
                logger.log(System.Logger.Level.INFO, "Check if we got correct exception from Connection.close()");
                if (listener.gotException()) {
                    if (listener.gotCorrectException()) {
                        logger.log(System.Logger.Level.INFO, "Got correct IllegalStateException");
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received: " + listener.getException());
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, got no exception");
                    pass = false;
                }
            }
            catch (IllegalStateException e) {
                logger.log(System.Logger.Level.INFO, "Caught IllegalStateException as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received " + e);
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            try {
                this.cleanup();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Exception during cleanup: " + e);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("illegalStateExceptionTest1", e);
        }
        if (!pass) {
            throw new Exception("illegalStateExceptionTest1 failed");
        }
    }

    @Test
    public void illegalStateExceptionTest2() throws Exception {
        boolean pass;
        block22: {
            pass = true;
            try {
                int i;
                Object actTextMessage;
                TextMessage expTextMessage;
                MyMessageListener listener;
                logger.log(System.Logger.Level.INFO, "Testing Connection.close() from MessageListener (expect IllegalStateException)");
                try {
                    this.setupForQueue();
                    listener = new MyMessageListener(this.connection);
                    logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                    expTextMessage = this.session.createTextMessage("Call connection close method");
                    logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest2");
                    logger.log(System.Logger.Level.INFO, "Set MessageListener to receive async message");
                    this.consumer.setMessageListener((MessageListener)listener);
                    logger.log(System.Logger.Level.INFO, "Send async message to MessageListener");
                    logger.log(System.Logger.Level.INFO, "MessageListener will call Connection.close() (expect IllegalStateException)");
                    this.producer.send((Message)expTextMessage);
                    actTextMessage = null;
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    for (i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    logger.log(System.Logger.Level.INFO, "Check if we got correct exception from Connection.close()");
                    if (listener.gotException()) {
                        if (listener.gotCorrectException()) {
                            logger.log(System.Logger.Level.INFO, "Got correct IllegalStateException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received: " + listener.getException());
                            pass = false;
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, got no exception");
                        pass = false;
                    }
                }
                catch (IllegalStateException e) {
                    logger.log(System.Logger.Level.INFO, "Caught IllegalStateException as expected");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received " + e);
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
                try {
                    this.cleanup();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.INFO, "Exception during cleanup: " + e);
                }
                logger.log(System.Logger.Level.INFO, "Testing Connection.stop() from MessageListener (expect IllegalStateException)");
                try {
                    this.setupForQueue();
                    listener = new MyMessageListener(this.connection);
                    logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                    expTextMessage = this.session.createTextMessage("Call connection stop method");
                    logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest2");
                    logger.log(System.Logger.Level.INFO, "Set MessageListener to receive async message");
                    this.consumer.setMessageListener((MessageListener)listener);
                    logger.log(System.Logger.Level.INFO, "Send async message to MessageListener");
                    logger.log(System.Logger.Level.INFO, "MessageListener will call Connection.stop() (expect IllegalStateException)");
                    this.producer.send((Message)expTextMessage);
                    actTextMessage = null;
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    for (i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    logger.log(System.Logger.Level.INFO, "Check if we got correct exception from Connection.stop()");
                    if (listener.gotException()) {
                        if (listener.gotCorrectException()) {
                            logger.log(System.Logger.Level.INFO, "Got correct IllegalStateException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received: " + listener.getException());
                            pass = false;
                        }
                        break block22;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, got no exception");
                    pass = false;
                }
                catch (IllegalStateException e) {
                    logger.log(System.Logger.Level.INFO, "Caught IllegalStateException as expected");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received " + e);
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("illegalStateExceptionTest2", e);
            }
        }
        if (!pass) {
            throw new Exception("illegalStateExceptionTest2 failed");
        }
    }

    @Test
    public void illegalStateExceptionTest3() throws Exception {
        boolean pass;
        block22: {
            pass = true;
            try {
                int i;
                Object actTextMessage;
                TextMessage expTextMessage;
                Object listener;
                logger.log(System.Logger.Level.INFO, "Testing Session.close() from CompletionListener (expect IllegalStateException)");
                try {
                    this.setupForQueue();
                    listener = new MyCompletionListener(this.session);
                    logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                    expTextMessage = this.session.createTextMessage("Call session close method");
                    logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest3");
                    logger.log(System.Logger.Level.INFO, "Send message specifying CompletionListener");
                    logger.log(System.Logger.Level.INFO, "CompletionListener will call Session.close() (expect IllegalStateException)");
                    this.producer.send((Message)expTextMessage, (CompletionListener)listener);
                    actTextMessage = null;
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    for (i = 0; i < 30; ++i) {
                        if (((MyCompletionListener)listener).isComplete()) {
                            ((MyCompletionListener)listener).setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    logger.log(System.Logger.Level.INFO, "Check if we got correct exception from Session.close()");
                    if (((MyCompletionListener)listener).gotException()) {
                        if (((MyCompletionListener)listener).gotCorrectException()) {
                            logger.log(System.Logger.Level.INFO, "Got correct IllegalStateException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received: " + ((MyCompletionListener)listener).getException());
                            pass = false;
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, got no exception");
                        pass = false;
                    }
                }
                catch (IllegalStateException e) {
                    logger.log(System.Logger.Level.INFO, "Caught IllegalStateException as expected");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received " + e);
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
                try {
                    this.cleanup();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.INFO, "Exception during cleanup: " + e);
                }
                logger.log(System.Logger.Level.INFO, "Testing Session.close() from MessageListener (expect IllegalStateException)");
                try {
                    this.setupForQueue();
                    listener = new MyMessageListener(this.session);
                    logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                    expTextMessage = this.session.createTextMessage("Call session close method");
                    logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest6");
                    logger.log(System.Logger.Level.INFO, "Set MessageListener to receive async message");
                    this.consumer.setMessageListener((MessageListener)listener);
                    logger.log(System.Logger.Level.INFO, "Send async message to MessageListener");
                    logger.log(System.Logger.Level.INFO, "MessageListener will call Session.close() (expect IllegalStateException)");
                    this.producer.send((Message)expTextMessage);
                    actTextMessage = null;
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    for (i = 0; i < 30; ++i) {
                        if (((MyMessageListener)listener).isComplete()) {
                            ((MyMessageListener)listener).setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    logger.log(System.Logger.Level.INFO, "Check if we got correct exception from Session.close()");
                    if (((MyMessageListener)listener).gotException()) {
                        if (((MyMessageListener)listener).gotCorrectException()) {
                            logger.log(System.Logger.Level.INFO, "Got correct IllegalStateException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received: " + ((MyMessageListener)listener).getException());
                            pass = false;
                        }
                        break block22;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, got no exception");
                    pass = false;
                }
                catch (IllegalStateException e) {
                    logger.log(System.Logger.Level.INFO, "Caught IllegalStateException as expected");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received " + e);
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("illegalStateExceptionTest3", e);
            }
        }
        if (!pass) {
            throw new Exception("illegalStateExceptionTest3 failed");
        }
    }

    @Test
    public void callingMessageConsumerCloseIsAllowed() throws Exception {
        boolean pass;
        block8: {
            pass = true;
            try {
                try {
                    this.setupForQueueWithMultipleSessions();
                    MyMessageListener listener = new MyMessageListener(this.consumer);
                    logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                    TextMessageTestImpl expTextMessage = new TextMessageTestImpl();
                    expTextMessage.setText("Call MessageConsumer close method");
                    logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "callingMessageConsumerCloseIsAllowed");
                    logger.log(System.Logger.Level.INFO, "Set MessageListener to receive async message");
                    this.consumer.setMessageListener((MessageListener)listener);
                    logger.log(System.Logger.Level.INFO, "Send async message to MessageListener");
                    logger.log(System.Logger.Level.INFO, "MessageListener will call MessageConsumer.close() which is allowed");
                    this.producer.send((Message)expTextMessage);
                    Object actTextMessage = null;
                    logger.log(System.Logger.Level.INFO, "Poll listener until complete");
                    for (int i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    logger.log(System.Logger.Level.INFO, "Make sure MessageConsumer.close() was allowed");
                    if (!listener.gotException()) {
                        logger.log(System.Logger.Level.INFO, "MessageConsumer.close() was allowed");
                        break block8;
                    }
                    logger.log(System.Logger.Level.ERROR, "MessageConsumer.close() through an exception");
                    pass = false;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("callingMessageConsumerCloseIsAllowed", e);
            }
        }
        if (!pass) {
            throw new Exception("callingMessageConsumerCloseIsAllowed failed");
        }
    }

    @Test
    public void callingJMSConsumerCloseIsAllowed() throws Exception {
        boolean pass;
        block8: {
            pass = true;
            try {
                try {
                    this.setupForQueue2();
                    MyMessageListener listener = new MyMessageListener(this.jmsconsumer);
                    logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                    TextMessage expTextMessage = this.contextToCreateMsg.createTextMessage("Call JMSConsumer close method");
                    logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "callingJMSConsumerCloseIsAllowed");
                    logger.log(System.Logger.Level.INFO, "Set MessageListener to receive async message");
                    this.jmsconsumer.setMessageListener((MessageListener)listener);
                    logger.log(System.Logger.Level.INFO, "Send async message to MessageListener");
                    logger.log(System.Logger.Level.INFO, "MessageListener will call JMSConsumer.close() which is allowed");
                    this.jmsproducer.send(this.destination, (Message)expTextMessage);
                    Object actTextMessage = null;
                    logger.log(System.Logger.Level.INFO, "Poll listener until complete");
                    for (int i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    logger.log(System.Logger.Level.INFO, "Make sure JMSConsumer.close() was allowed");
                    if (!listener.gotException()) {
                        logger.log(System.Logger.Level.INFO, "JMSConsumer.close() was allowed");
                        break block8;
                    }
                    logger.log(System.Logger.Level.ERROR, "JMSConsumer.close() through an exception");
                    pass = false;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("callingJMSConsumerCloseIsAllowed", e);
            }
        }
        if (!pass) {
            throw new Exception("callingJMSConsumerCloseIsAllowed failed");
        }
    }
}

