/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.jmsconsumertests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.jmsconsumertests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient Queue queue = null;
    private transient Topic topic = null;
    private transient Destination destination = null;
    private transient JMSContext context = null;
    private transient JMSConsumer consumer = null;
    private transient JMSProducer producer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList queues = null;
    ArrayList connections = null;
    boolean queueTest = false;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(3);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Close JMSContext");
            if (this.context != null) {
                this.context.close();
            }
            if (this.queueTest) {
                logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            logger.log(System.Logger.Level.INFO, "Close all connections and resources");
            this.tool.closeAllConnections(this.connections);
            this.tool.closeAllResources();
            this.producer = null;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
    }

    @Test
    public void queueReceiveTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive() to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive();
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage again");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long timeout) to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage again");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveNoWait() to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receiveNoWait();
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message (THIS IS OK)");
                logger.log(System.Logger.Level.INFO, "Now block and wait for message via JMSConsumer.receive()");
                actTextMessage = (TextMessage)this.consumer.receive();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage on blocking receive");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Now don't send a message at all");
            logger.log(System.Logger.Level.INFO, "Calling receiveNoWait() again to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receiveNoWait();
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "actTextMessage != NULL (expected actTextMessage=NULL)");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueReceiveTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueReceiveTests failed");
        }
    }

    @Test
    public void queueReceiveBodyTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(String.class) to receive message as a String");
            String actMessage = (String)this.consumer.receiveBody(String.class);
            if (actMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in String");
            if (actMessage.equals(message)) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + message + ", received " + actMessage);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(StringBuffer.class, long) to receive message as a StringBuffer");
            StringBuffer actSbuffer = (StringBuffer)this.consumer.receiveBody(StringBuffer.class, this.timeout);
            if (actSbuffer == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in StringBuffer");
            if (actSbuffer.toString().equals(expSbuffer.toString())) {
                logger.log(System.Logger.Level.INFO, "ObjectMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage is incorrect expected " + expSbuffer + ", received " + actSbuffer);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            logger.log(System.Logger.Level.INFO, "Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(byte[].class, long) to receive message as a byte array");
            byte[] bytes = (byte[])this.consumer.receiveBody(byte[].class, this.timeout);
            if (bytes == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            try {
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(bytes));
                logger.log(System.Logger.Level.INFO, "Check the values in BytesMessage");
                if (di.readByte() == 1) {
                    logger.log(System.Logger.Level.INFO, "bytevalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "bytevalue is incorrect");
                    pass = false;
                }
                if (di.readInt() == 22) {
                    logger.log(System.Logger.Level.INFO, "intvalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                    pass = false;
                }
                try {
                    byte by = di.readByte();
                }
                catch (EOFException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected EOFException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            logger.log(System.Logger.Level.INFO, "Send and receive the MapMessage");
            this.producer.send(this.destination, (Message)mMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBodyNoWait(Map.class) to receive message as a Map");
            Map map = (Map)this.consumer.receiveBodyNoWait(Map.class);
            if (map == null) {
                for (int i = 0; i < 5; ++i) {
                    TestUtil.sleepSec((int)1);
                    map = (Map)this.consumer.receiveBodyNoWait(Map.class);
                    if (map != null) break;
                }
            }
            if (map == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive MapMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in MapMessage");
                logger.log(System.Logger.Level.INFO, "map.size()=" + map.size());
                if (map.size() != 2) {
                    logger.log(System.Logger.Level.ERROR, "Map size is " + map.size() + ", expected 2");
                    pass = false;
                }
                Iterator it = map.keySet().iterator();
                String name = null;
                while (it.hasNext()) {
                    name = (String)it.next();
                    if (name.equals("booleanvalue")) {
                        if (((Boolean)map.get(name)).booleanValue()) {
                            logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if ((Integer)map.get(name) == 10) {
                            logger.log(System.Logger.Level.INFO, "intvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Unexpected name of [" + name + "] in MapMessage");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueReceiveBodyTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueReceiveBodyTests failed");
        }
    }

    @Test
    public void queueReceiveBodyExceptionTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(Class<T>) to receive message as wrong type");
            logger.log(System.Logger.Level.INFO, "Pass Boolean.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create ObjectMessage of type StringBuffer");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(Class<T>) to receive message as wrong type");
            logger.log(System.Logger.Level.INFO, "Pass HashMap.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            logger.log(System.Logger.Level.INFO, "Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBodyNoWait(Class<T>) to receive message as wrong type");
            logger.log(System.Logger.Level.INFO, "Pass Boolean.class as parameter to receiveBodyNoWait() expect MessageFormatRuntimeException");
            try {
                for (int i = 0; i < 5; ++i) {
                    TestUtil.sleepSec((int)1);
                    if (this.consumer.receiveBodyNoWait(Boolean.class) != null) break;
                }
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(Map.class, long) to receive message as wrong type");
            logger.log(System.Logger.Level.INFO, "Pass Boolean.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send StreamMessage");
            StreamMessage sMsg = this.context.createStreamMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send(this.destination, (Message)sMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody() on a StreamMessage expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send Message");
            Message msg = this.context.createMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(this.destination, msg);
            long deliveryTime = msg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody() on a Message expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueReceiveBodyExceptionTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueReceiveBodyExceptionTests failed");
        }
    }

    @Test
    public void queueGetMessageSelectorTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Get message selector expression by calling getMessageSelector() API");
            String msgsel = this.consumer.getMessageSelector();
            logger.log(System.Logger.Level.INFO, "Expecting message selector to be NULL since we didn't set it");
            if (msgsel != null) {
                logger.log(System.Logger.Level.ERROR, "Message selector is NOT NULL (unexpected): <msgsel=" + msgsel + ">, expected NULL");
                pass = false;
            }
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer with message selector 'lastMessage = TRUE'");
            this.consumer = this.context.createConsumer(this.destination, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Get message selector expression by calling getMessageSelector() API");
            msgsel = this.consumer.getMessageSelector();
            logger.log(System.Logger.Level.INFO, "Expecting message selector to be NOT NULL since we set it to 'lastMessage = TRUE'");
            if (msgsel == null) {
                logger.log(System.Logger.Level.ERROR, "Message selector is NULL (unexpected): <msgsel=null>, expected 'lastMessage = TRUE'");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueGetMessageSelectorTest", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueGetMessageSelectorTest failed");
        }
    }

    @Test
    public void queueCloseTest() throws Exception {
        boolean pass;
        block6: {
            pass = true;
            String message = "Where are you!";
            try {
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.cf = this.tool.getConnectionFactory();
                this.destination = this.tool.getDefaultDestination();
                this.queue = (Queue)this.destination;
                logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
                this.context = this.cf.createContext(this.user, this.password, 1);
                this.queueTest = true;
                logger.log(System.Logger.Level.INFO, "Create JMSProducer");
                this.producer = this.context.createProducer();
                logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                logger.log(System.Logger.Level.INFO, "Create TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueCloseTest");
                logger.log(System.Logger.Level.INFO, "Send the TextMessage");
                logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
                this.producer.send(this.destination, (Message)expTextMessage);
                logger.log(System.Logger.Level.INFO, "Close the JMSConsumer");
                this.consumer.close();
                logger.log(System.Logger.Level.INFO, "Try receiving a message on a closed JMSConsumer (expect JMSRuntimeException or no message)");
                try {
                    TextMessage actTextMessage = (TextMessage)this.consumer.receive();
                    if (actTextMessage != null) {
                        logger.log(System.Logger.Level.ERROR, "Received a message (expected no message), <recvdMsg=" + actTextMessage + ">");
                        pass = false;
                        break block6;
                    }
                    logger.log(System.Logger.Level.INFO, "Did not receive a message (correct)");
                }
                catch (JMSRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeException: " + e);
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("queueCloseTest", e);
            }
        }
        if (!pass) {
            throw new Exception("queueCloseTest failed");
        }
    }

    @Test
    public void topicReceiveTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_T");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive() to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive();
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage again");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long timeout) to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage again");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveNoWait() to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receiveNoWait();
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message (THIS IS OK)");
                logger.log(System.Logger.Level.INFO, "Now block and wait for message via JMSConsumer.receive()");
                actTextMessage = (TextMessage)this.consumer.receive();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage on blocking receive");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Now don't send a message at all");
            logger.log(System.Logger.Level.INFO, "Calling receiveNoWait() again to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receiveNoWait();
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "actTextMessage != NULL (expected actTextMessage=NULL)");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicReceiveTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicReceiveTests failed");
        }
    }

    @Test
    public void topicReceiveBodyTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_T");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(String.class) to receive message as a String");
            String actMessage = (String)this.consumer.receiveBody(String.class);
            if (actMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in String");
            if (actMessage.equals(message)) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + message + ", received " + actMessage);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(StringBuffer.class, long) to receive message as a StringBuffer");
            StringBuffer actSbuffer = (StringBuffer)this.consumer.receiveBody(StringBuffer.class, this.timeout);
            if (actSbuffer == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in StringBuffer");
            if (actSbuffer.toString().equals(expSbuffer.toString())) {
                logger.log(System.Logger.Level.INFO, "ObjectMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage is incorrect expected " + expSbuffer + ", received " + actSbuffer);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            logger.log(System.Logger.Level.INFO, "Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(byte[].class, long) to receive message as a byte array");
            byte[] bytes = (byte[])this.consumer.receiveBody(byte[].class, this.timeout);
            if (bytes == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            try {
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(bytes));
                logger.log(System.Logger.Level.INFO, "Check the values in BytesMessage");
                if (di.readByte() == 1) {
                    logger.log(System.Logger.Level.INFO, "bytevalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "bytevalue is incorrect");
                    pass = false;
                }
                if (di.readInt() == 22) {
                    logger.log(System.Logger.Level.INFO, "intvalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                    pass = false;
                }
                try {
                    byte by = di.readByte();
                }
                catch (EOFException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected EOFException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            logger.log(System.Logger.Level.INFO, "Send and receive the MapMessage");
            this.producer.send(this.destination, (Message)mMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBodyNoWait(Map.class) to receive message as a Map");
            Map map = (Map)this.consumer.receiveBodyNoWait(Map.class);
            if (map == null) {
                for (int i = 0; i < 5; ++i) {
                    TestUtil.sleepSec((int)1);
                    map = (Map)this.consumer.receiveBodyNoWait(Map.class);
                    if (map != null) break;
                }
            }
            if (map == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive MapMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in MapMessage");
                logger.log(System.Logger.Level.INFO, "map.size()=" + map.size());
                if (map.size() != 2) {
                    logger.log(System.Logger.Level.ERROR, "Map size is " + map.size() + ", expected 2");
                    pass = false;
                }
                Iterator it = map.keySet().iterator();
                String name = null;
                while (it.hasNext()) {
                    name = (String)it.next();
                    if (name.equals("booleanvalue")) {
                        if (((Boolean)map.get(name)).booleanValue()) {
                            logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if ((Integer)map.get(name) == 10) {
                            logger.log(System.Logger.Level.INFO, "intvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Unexpected name of [" + name + "] in MapMessage");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicReceiveBodyTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicReceiveBodyTests failed");
        }
    }

    @Test
    public void topicReceiveBodyExceptionTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_T");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(Class<T>) to receive message as wrong type");
            logger.log(System.Logger.Level.INFO, "Pass Boolean.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create ObjectMessage of type StringBuffer");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(Class<T>) to receive message as wrong type");
            logger.log(System.Logger.Level.INFO, "Pass HashMap.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            logger.log(System.Logger.Level.INFO, "Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBodyNoWait(Class<T>) to receive message as wrong type");
            logger.log(System.Logger.Level.INFO, "Pass Boolean.class as parameter to receiveBodyNoWait() expect MessageFormatRuntimeException");
            try {
                for (int i = 0; i < 5; ++i) {
                    TestUtil.sleepSec((int)1);
                    if (this.consumer.receiveBodyNoWait(Boolean.class) != null) break;
                }
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody(Map.class, long) to receive message as wrong type");
            logger.log(System.Logger.Level.INFO, "Pass Boolean.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send StreamMessage");
            StreamMessage sMsg = this.context.createStreamMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send(this.destination, (Message)sMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody() on a StreamMessage expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send Message");
            Message msg = this.context.createMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(this.destination, msg);
            long deliveryTime = msg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receiveBody() on a Message expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                logger.log(System.Logger.Level.ERROR, "Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicReceiveBodyExceptionTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicReceiveBodyExceptionTests failed");
        }
    }

    @Test
    public void topicGetMessageSelectorTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_T");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Get message selector expression by calling getMessageSelector() API");
            String msgsel = this.consumer.getMessageSelector();
            logger.log(System.Logger.Level.INFO, "Expecting message selector to be NULL since we didn't set it");
            if (msgsel != null) {
                logger.log(System.Logger.Level.ERROR, "Message selector is NOT NULL (unexpected): <msgsel=" + msgsel + ">, expected NULL");
                pass = false;
            }
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer with message selector 'lastMessage = TRUE'");
            this.consumer = this.context.createConsumer(this.destination, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Get message selector expression by calling getMessageSelector() API");
            msgsel = this.consumer.getMessageSelector();
            logger.log(System.Logger.Level.INFO, "Expecting message selector to be NOT NULL since we set it to 'lastMessage = TRUE'");
            if (msgsel == null) {
                logger.log(System.Logger.Level.ERROR, "Message selector is NULL (unexpected): <msgsel=null>, expected 'lastMessage = TRUE'");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicGetMessageSelectorTest", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicGetMessageSelectorTest failed");
        }
    }

    @Test
    public void topicCloseTest() throws Exception {
        boolean pass;
        block6: {
            pass = true;
            String message = "Where are you!";
            try {
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_T");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.cf = this.tool.getConnectionFactory();
                this.destination = this.tool.getDefaultDestination();
                this.topic = (Topic)this.destination;
                logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
                this.context = this.cf.createContext(this.user, this.password, 1);
                this.queueTest = false;
                logger.log(System.Logger.Level.INFO, "Create JMSProducer");
                this.producer = this.context.createProducer();
                logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                logger.log(System.Logger.Level.INFO, "Create TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicCloseTest");
                logger.log(System.Logger.Level.INFO, "Send the TextMessage");
                logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
                this.producer.send(this.destination, (Message)expTextMessage);
                logger.log(System.Logger.Level.INFO, "Close the JMSConsumer");
                this.consumer.close();
                logger.log(System.Logger.Level.INFO, "Try receiving a message on a closed JMSConsumer (expect JMSRuntimeException or no message)");
                try {
                    TextMessage actTextMessage = (TextMessage)this.consumer.receive();
                    if (actTextMessage != null) {
                        logger.log(System.Logger.Level.ERROR, "Received a message (expected no message), <recvdMsg=" + actTextMessage + ">");
                        pass = false;
                        break block6;
                    }
                    logger.log(System.Logger.Level.INFO, "Did not receive a message (correct)");
                }
                catch (JMSRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeException: " + e);
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("topicCloseTest", e);
            }
        }
        if (!pass) {
            throw new Exception("topicCloseTest failed");
        }
    }
}

