/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndToTopic;

import com.sun.ts.tests.jms.commonee.MDB_T_Test;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    @EJB(name="ejb/MDB_SNDToTopic_Test")
    private static MDB_T_Test hr;
    private Properties props = new Properties();
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        try {
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            this.props.put("jms_timeout", System.getProperty("jms_property"));
            this.props.put("user", System.getProperty("user"));
            this.props.put("password", System.getProperty("password"));
            hr.setup(this.props);
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void mdbSendTextMsgToTopicTest() throws Exception {
        String messageType = "TextMessage";
        String matchMe = "TextMessageFromMsgBean";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a text message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendBytesMsgToTopicTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "mdbSendTextMsgToTopicTest passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendBytesMsgToTopicTest() throws Exception {
        String messageType = "BytesMessage";
        String matchMe = "BytesMessageFromMsgBean";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a Bytes message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendBytesMsgToTopicTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendMapMsgToTopicTest() throws Exception {
        String matchMe = "MapMessageFromMsgBean";
        String messageType = "MapMessage";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a map message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendMapMsgToTopicTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendStreamMsgToTopicTest() throws Exception {
        String matchMe = "StreamMessageFromMsgBean";
        String messageType = "StreamMessage";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a stream message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendStreamMsgToTopicTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendObjectMsgToTopicTest() throws Exception {
        String matchMe = "ObjectMessageFromMsgBean";
        String messageType = "ObjectMessage";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send an object message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendObjectMsgToTopicTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
    }

    static {
        logger = System.getLogger(MDBClientIT.class.getName());
    }
}

