/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.resourcedefs.annotations;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.resourcedefs.annotations.EjbClientIF;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.Stateful;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactoryDefinition;
import jakarta.jms.JMSConnectionFactoryDefinitions;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSDestinationDefinition;
import jakarta.jms.JMSDestinationDefinitions;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import java.util.Properties;

@JMSDestinationDefinitions(value={@JMSDestinationDefinition(description="Define Queue EJBMyTestQueue", interfaceName="jakarta.jms.Queue", name="java:global/env/EJBMyTestQueue", destinationName="EJBMyTestQueue"), @JMSDestinationDefinition(description="Define Topic EJBMyTestTopic", interfaceName="jakarta.jms.Topic", name="java:app/env/EJBMyTestTopic", destinationName="EJBMyTestTopic")})
@JMSConnectionFactoryDefinitions(value={@JMSConnectionFactoryDefinition(description="Define ConnectionFactory EJBMyTestConnectionFactory", interfaceName="jakarta.jms.ConnectionFactory", name="java:global/EJBMyTestConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define QueueConnectionFactory EJBMyTestQueueConnectionFactory", interfaceName="jakarta.jms.QueueConnectionFactory", name="java:app/EJBMyTestQueueConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define TopicConnectionFactory EJBMyTestTopicConnectionFactory", interfaceName="jakarta.jms.TopicConnectionFactory", name="java:module/EJBMyTestTopicConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define Durable TopicConnectionFactory EJBMyTestDurableTopicConnectionFactory", interfaceName="jakarta.jms.TopicConnectionFactory", name="java:comp/env/jms/EJBMyTestDurableTopicConnectionFactory", user="j2ee", password="j2ee", clientId="MyClientID", properties={"Property1=10", "Property2=20"}, transactional=false, maxPoolSize=30, minPoolSize=20)})
@Stateful(name="JMSResourceDefsEjbClientBean")
@Remote(value={EjbClientIF.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class EjbClient
implements EjbClientIF {
    private static final long serialVersionUID = 1L;
    protected transient ConnectionFactory cf = null;
    protected transient ConnectionFactory dcf = null;
    protected transient ConnectionFactory cfra = null;
    protected transient QueueConnectionFactory qcf = null;
    protected transient TopicConnectionFactory tcf = null;
    protected transient TopicConnectionFactory dtcf = null;
    protected transient Topic topic = null;
    protected transient Topic topica = null;
    protected transient Queue queue = null;
    protected transient JMSContext context = null;
    protected transient JMSConsumer consumerQ = null;
    protected transient JMSProducer producerQ = null;
    protected transient JMSConsumer consumerT = null;
    protected transient JMSProducer producerT = null;
    protected boolean queueTest = false;
    protected Properties props = null;
    protected long timeout;
    protected String user;
    protected String password;
    protected String mode;
    private static final System.Logger logger = System.getLogger(EjbClient.class.getName());

    private void doCleanup() throws Exception {
        try {
            if (this.queueTest && this.consumerQ != null) {
                logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                Message rmsg = this.consumerQ.receive(this.timeout);
                while (rmsg != null) {
                    rmsg = this.consumerQ.receiveNoWait();
                    if (rmsg != null) continue;
                    rmsg = this.consumerQ.receiveNoWait();
                }
                this.consumerQ.close();
            }
            if (this.consumerT != null) {
                this.consumerT.close();
            }
            logger.log(System.Logger.Level.INFO, "Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("doCleanup failed!", e);
        }
    }

    @Override
    public void init(Properties p) {
        try {
            TestUtil.init((Properties)p);
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.doLookupJMSObjects();
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
    }

    @Override
    public boolean echo(String testName) {
        boolean pass = false;
        if (testName.equals("sendAndRecvQueueTestFromEjbClient")) {
            pass = this.sendAndRecvQueueTestFromEjbClient();
        } else if (testName.equals("sendAndRecvTopicTestFromEjbClient")) {
            pass = this.sendAndRecvTopicTestFromEjbClient();
        } else if (testName.equals("checkClientIDTestFromEjbClient")) {
            pass = this.checkClientIDTestFromEjbClient();
        }
        try {
            this.doCleanup();
        }
        catch (Exception e) {
            pass = false;
        }
        return pass;
    }

    private void doLookupJMSObjects() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Lookup JMS factories defined in @JMSConnectionFactoryDefinitions");
            logger.log(System.Logger.Level.INFO, "Lookup JMS destinations defined in @JMSDestinationDefinitions");
            TSNamingContext namingctx = new TSNamingContext();
            logger.log(System.Logger.Level.INFO, "Lookup java:comp/DefaultJMSConnectionFactory");
            this.dcf = (ConnectionFactory)namingctx.lookup("java:comp/DefaultJMSConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:global/EJBMyTestConnectionFactory");
            this.cf = (ConnectionFactory)namingctx.lookup("java:global/EJBMyTestConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:app/EJBMyTestQueueConnectionFactory");
            this.qcf = (QueueConnectionFactory)namingctx.lookup("java:app/EJBMyTestQueueConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:module/EJBMyTestTopicConnectionFactory");
            this.tcf = (TopicConnectionFactory)namingctx.lookup("java:module/EJBMyTestTopicConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:comp/env/jms/EJBMyTestDurableTopicConnectionFactory");
            this.dtcf = (TopicConnectionFactory)namingctx.lookup("java:comp/env/jms/EJBMyTestDurableTopicConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:global/env/EJBMyTestQueue");
            this.queue = (Queue)namingctx.lookup("java:global/env/EJBMyTestQueue");
            logger.log(System.Logger.Level.INFO, "Lookup java:app/env/EJBMyTestTopic");
            this.topic = (Topic)namingctx.lookup("java:app/env/EJBMyTestTopic");
            logger.log(System.Logger.Level.INFO, "Create JMSContext, JMSProducer's and JMSConsumer's");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.producerQ = this.context.createProducer();
            this.consumerQ = this.context.createConsumer((Destination)this.queue);
            this.producerT = this.context.createProducer();
            this.consumerT = this.context.createConsumer((Destination)this.topic);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw e;
        }
    }

    public boolean sendAndRecvQueueTestFromEjbClient() {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvQueueTestFromEjbClient");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerQ.send((Destination)this.queue, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerQ.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        return pass;
    }

    public boolean sendAndRecvTopicTestFromEjbClient() {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvTopicTestFromEjbClient");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerT.send((Destination)this.topic, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerT.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkClientIDTestFromEjbClient() {
        boolean pass = true;
        JMSContext context = null;
        try {
            this.queueTest = false;
            this.doLookupJMSObjects();
            logger.log(System.Logger.Level.INFO, "Create JMSContext from durable topic connection factory");
            logger.log(System.Logger.Level.INFO, "Check the client id which is configured as MyClientID in the JMSConnectionFactoryDefinition annotation");
            context = this.dtcf.createContext(this.user, this.password, 1);
            String clientid = context.getClientID();
            if (clientid == null) {
                logger.log(System.Logger.Level.ERROR, "Client ID value is null (expected MyClientID)");
                pass = false;
            } else if (clientid.equals("MyClientID")) {
                logger.log(System.Logger.Level.INFO, "Client ID value is correct (MyClientID)");
            } else {
                logger.log(System.Logger.Level.ERROR, "Client ID value is incorrect (expected MyClientID, got " + clientid + ")");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception exception) {}
        }
        return pass;
    }
}

