/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgHdrT;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class MsgBeanMsgTestHdrT
implements MessageDrivenBean,
MessageListener {
    private Properties props = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private QueueSession qSession = null;
    private QueueSender mSender;
    private Topic topic;
    private TopicConnection tConnection;
    private TopicSession tSession;
    private TopicConnectionFactory tFactory;
    private TopicPublisher tSender;
    private TextMessage messageSent = null;
    private StreamMessage messageSentStreamMessage = null;
    private BytesMessage messageSentBytesMessage = null;
    private MapMessage messageSentMapMessage = null;
    private ObjectMessage messageSentObjectMsg = null;

    public MsgBeanMsgTestHdrT() {
        TestUtil.logTrace((String)"@MsgBeanMsgTestHdrT()!");
    }

    public void ejbCreate() {
        this.props = new Properties();
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgHdrT  - @MsgBeanMsgTestHdrT-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                TestUtil.logTrace((String)"qFactory error");
            }
            TestUtil.logTrace((String)"got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                TestUtil.logTrace((String)"queueR error");
            }
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            this.topic = (Topic)this.context.lookup("java:comp/env/jms/MDB_TOPIC");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        TestUtil.logTrace((String)("from jms.ee.mdb.mdb_msgHdrT @onMessage!" + String.valueOf(msg)));
        try {
            JmsUtil.initHarnessProps((Message)msg, (Properties)this.props);
            TestUtil.logTrace((String)("from jms.ee.mdb.mdb_msgHdrT @onMessage!" + String.valueOf(msg)));
            TestUtil.logTrace((String)("onMessage will run TestCase: " + msg.getStringProperty("TestCase")));
            this.tConnection = this.tFactory.createTopicConnection();
            if (this.tConnection == null) {
                TestUtil.logTrace((String)"connection error");
            } else {
                this.tConnection.start();
                this.tSession = this.tConnection.createTopicSession(true, 0);
            }
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                System.out.println("connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            Vector<Object> mVec = new Vector<Object>();
            this.messageSent = this.tSession.createTextMessage();
            mVec.addElement(this.messageSent);
            this.messageSentStreamMessage = this.tSession.createStreamMessage();
            mVec.addElement(this.messageSentStreamMessage);
            this.messageSentBytesMessage = this.tSession.createBytesMessage();
            mVec.addElement(this.messageSentBytesMessage);
            this.messageSentMapMessage = this.tSession.createMapMessage();
            mVec.addElement(this.messageSentMapMessage);
            this.messageSentObjectMsg = this.tSession.createObjectMessage();
            mVec.addElement(this.messageSentObjectMsg);
            Enumeration vNum = mVec.elements();
            while (vNum.hasMoreElements()) {
                JmsUtil.addPropsToMessage((Message)((Message)vNum.nextElement()), (Properties)this.props);
            }
            if (msg.getStringProperty("TestCase").equals("msgHdrTimeStampTTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgHdrTimeStampTTest - create the message");
                this.msgHdrTimeStampTTest();
            } else if (msg.getStringProperty("TestCase").equals("dummy")) {
                TestUtil.logTrace((String)"@onMessage - ignore this!");
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTTextTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdTTextTestCreate!");
                this.msgHdrCorlIdTTextTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTTextTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdTTextTest!");
                this.msgHdrCorlIdTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTBytesTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdTBytesTestCreate!");
                this.msgHdrCorlIdTBytesTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTBytesTest")) {
                TestUtil.logTrace((String)"@onMessage -msgHdrCorlIdTBytesTest!");
                this.msgHdrCorlIdTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTMapTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdTMapTestCreate!");
                this.msgHdrCorlIdTMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTMapTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdTMapTest!");
                this.msgHdrCorlIdTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTStreamTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdTStreamTestCreate!");
                this.msgHdrCorlIdTStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTStreamTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdTStreamTest!");
                this.msgHdrCorlIdTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTObjectTestCreate")) {
                TestUtil.logTrace((String)"@onMessage -msgHdrCorlIdTObjectTestCreate!");
                this.msgHdrCorlIdTObjectTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdTObjectTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrCorlIdTObjectTest!");
                this.msgHdrCorlIdTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrReplyToTTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrReplyToTTestCreate!");
                this.msgHdrReplyToTTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrReplyToTTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrReplyToTTest!");
                this.msgHdrReplyToTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSTypeTTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSTypeTTestCreate!");
                this.msgHdrJMSTypeTTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSTypeTTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSTypeTTest!");
                this.msgHdrJMSTypeTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSPriorityTTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSPriorityTTestCreate!");
                this.msgHdrJMSPriorityTTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSPriorityTTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSPriorityTTest!");
                this.msgHdrJMSPriorityTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSExpirationTopicTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSExpirationTopicTestCreate!");
                this.msgHdrJMSExpirationTopicTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSExpirationTopicTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSExpirationTopicTest!");
                this.msgHdrJMSExpirationTopicTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDestinationTTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSDestinationTTestCreate!");
                this.msgHdrJMSDestinationTTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDestinationTTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSDestinationTTest!");
                this.msgHdrJMSDestinationTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDeliveryModeTTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSDeliveryModeTTestCreate!");
                this.msgHdrJMSDeliveryModeTTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDeliveryModeTTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrJMSDeliveryModeTTest!");
                this.msgHdrJMSDeliveryModeTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrIDTTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrIDTTestCreate!");
                this.msgHdrIDTTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrIDTTest")) {
                TestUtil.logTrace((String)"@onMessage - msgHdrIDTTest!");
                this.msgHdrIDTTest(msg);
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
                TestUtil.logTrace((String)("Do not have a method for this testcase: " + msg.getStringProperty("TestCase")));
            }
            TestUtil.logTrace((String)"@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            if (this.tConnection != null) {
                try {
                    this.tConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrTimeStampTTest() {
        boolean pass = true;
        int bValue = 127;
        Object id = null;
        String testCase = "msgHdrTimeStampTTest";
        try {
            this.messageSent.setText("sending a Text message");
            this.messageSent.setStringProperty("TestCase", "dummy");
            TestUtil.logTrace((String)"sending a Text message");
            long timeBeforeSend = System.currentTimeMillis();
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSent);
            long timeAfterSend = System.currentTimeMillis();
            TestUtil.logTrace((String)" getJMSTimestamp");
            TestUtil.logTrace((String)(" " + this.messageSent.getJMSTimestamp()));
            TestUtil.logTrace((String)("Time at send is: " + timeBeforeSend));
            TestUtil.logTrace((String)("Time after return fromsend is:" + timeAfterSend));
            if (timeBeforeSend <= this.messageSent.getJMSTimestamp() && timeAfterSend >= this.messageSent.getJMSTimestamp()) {
                TestUtil.logTrace((String)"TextMessage TimeStamp pass");
            } else {
                TestUtil.logMsg((String)"Error: invalid timestamp from TextMessage");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void msgHdrCorlIdTTextTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrCorlIdTTextTest");
            TestUtil.logTrace((String)"Send Text Message to Topic.");
            this.messageSent.setJMSCorrelationID(jmsCorrelationID);
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdTStreamTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            this.messageSentStreamMessage.setStringProperty("TestCase", "msgHdrCorlIdTStreamTest");
            this.messageSentStreamMessage.setJMSCorrelationID(jmsCorrelationID);
            this.messageSentStreamMessage.writeString("Testing...");
            TestUtil.logTrace((String)"Sending Stream message");
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSentStreamMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdTBytesTestCreate() {
        byte bValue = 127;
        String jmsCorrelationID = "test Correlation id";
        try {
            TestUtil.logTrace((String)"Send BytesMessage to Topic.");
            this.messageSentBytesMessage.setStringProperty("TestCase", "msgHdrCorlIdTBytesTest");
            this.messageSentBytesMessage.setJMSCorrelationID(jmsCorrelationID);
            this.messageSentBytesMessage.writeByte(bValue);
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSentBytesMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdTMapTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            TestUtil.logTrace((String)"Send MapMessage to Topic.");
            this.messageSentMapMessage.setStringProperty("TestCase", "msgHdrCorlIdTMapTest");
            this.messageSentMapMessage.setJMSCorrelationID(jmsCorrelationID);
            this.messageSentMapMessage.setString("aString", "value");
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSentMapMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdTObjectTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            TestUtil.logTrace((String)"Send ObjectMessage to Topic.");
            this.messageSentObjectMsg.setObject((Serializable)((Object)"msgHdrIDTObjectTest for Object Message"));
            this.messageSentObjectMsg.setStringProperty("TestCase", "msgHdrCorlIdTObjectTest");
            this.messageSentObjectMsg.setJMSCorrelationID(jmsCorrelationID);
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSentObjectMsg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrCorlIdTTest(Message messageReceived) {
        boolean pass = true;
        String jmsCorrelationID = "test Correlation id";
        try {
            TestUtil.logTrace((String)("jmsCorrelationID:  " + messageReceived.getJMSCorrelationID()));
            if (messageReceived.getJMSCorrelationID() == null) {
                pass = false;
                TestUtil.logMsg((String)"Text Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceived.getJMSCorrelationID().equals(jmsCorrelationID)) {
                TestUtil.logTrace((String)"pass");
            } else {
                pass = false;
                TestUtil.logMsg((String)"Text Message Error: JMSCorrelationID is incorrect");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                this.sendTestResults(messageReceived.getStringProperty("TestCase"), pass);
            }
            catch (Exception j) {
                TestUtil.printStackTrace((Throwable)j);
            }
        }
    }

    public void msgHdrReplyToTTestCreate() {
        Object replyTopic = null;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrReplyToTTest");
            this.messageSent.setJMSReplyTo((Destination)this.topic);
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrReplyToTTest(Message messageReceived) {
        boolean pass = true;
        Topic replyTopic = null;
        String testCase = "msgHdrReplyToTTest";
        try {
            replyTopic = (Topic)messageReceived.getJMSReplyTo();
            TestUtil.logTrace((String)("Topic name is " + replyTopic.getTopicName()));
            if (replyTopic.getTopicName().equals(this.topic.getTopicName())) {
                TestUtil.logTrace((String)"Pass ");
            } else {
                TestUtil.logMsg((String)"ReplyTo Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSTypeTTestCreate() {
        boolean pass = true;
        int bValue = 127;
        String type = "TESTMSG";
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSTypeTTest");
            TestUtil.logTrace((String)"JMSType test - Send a Text message");
            this.messageSent.setJMSType(type);
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSTypeTTest(Message messageReceived) {
        boolean pass = true;
        String type = "TESTMSG";
        String testCase = "msgHdrJMSTypeTTest";
        try {
            TestUtil.logTrace((String)("JMSType is " + messageReceived.getJMSType()));
            if (messageReceived.getJMSType().equals(type)) {
                TestUtil.logTrace((String)"Pass");
            } else {
                TestUtil.logMsg((String)"Text Message Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSPriorityTTestCreate() {
        boolean pass = true;
        int bValue = 127;
        int priority = 2;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSPriorityTTest");
            TestUtil.logTrace((String)"JMSPriority test - Send a Text message");
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.setPriority(priority);
            this.tSender.publish((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSPriorityTTest(Message messageReceived) {
        boolean pass = true;
        int priority = 2;
        String testCase = "msgHdrJMSPriorityTTest";
        try {
            TestUtil.logTrace((String)("JMSPriority is " + messageReceived.getJMSPriority()));
            if (messageReceived.getJMSPriority() == priority) {
                TestUtil.logTrace((String)"Pass ");
            } else {
                TestUtil.logMsg((String)"JMSPriority test Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSExpirationTopicTestCreate() {
        boolean pass = true;
        long forever = 0L;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSExpirationTopicTest");
            TestUtil.logTrace((String)"JMSExpiration test - Send a Text message");
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.setTimeToLive(forever);
            this.tSender.publish((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSExpirationTopicTest(Message messageReceived) {
        boolean pass = true;
        long forever = 0L;
        String testCase = "msgHdrJMSExpirationTopicTest";
        try {
            TestUtil.logTrace((String)("JMSExpiration is " + messageReceived.getJMSExpiration()));
            if (messageReceived.getJMSExpiration() == forever) {
                TestUtil.logTrace((String)"Pass ");
            } else {
                TestUtil.logMsg((String)"Text Message Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSDestinationTTestCreate() {
        Object replyDestination = null;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSDestinationTTest");
            TestUtil.logTrace((String)"send msg for JMSDestination test.");
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSDestinationTTest(Message messageReceived) {
        boolean pass = true;
        Topic replyDestination = null;
        String testCase = "msgHdrJMSDestinationTTest";
        try {
            TestUtil.logTrace((String)("JMSDestination:  " + String.valueOf(messageReceived.getJMSDestination())));
            replyDestination = (Topic)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                TestUtil.logTrace((String)("Topic name is " + replyDestination.getTopicName()));
            }
            if (replyDestination == null) {
                pass = false;
                TestUtil.logMsg((String)"Text Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getTopicName().equals(this.topic.getTopicName())) {
                TestUtil.logTrace((String)"Pass ");
            } else {
                TestUtil.logMsg((String)"Text Message Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in msgHdrJMSDestinationTTest:", (Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSDeliveryModeTTestCreate() {
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSDeliveryModeTTest");
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSDeliveryModeTTest(Message messageReceived) {
        boolean pass = true;
        String testCase = "msgHdrJMSDeliveryModeTTest";
        try {
            TestUtil.logTrace((String)("JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode()));
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                TestUtil.logMsg((String)"Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                TestUtil.logTrace((String)"Pass: Default delivery mode is persistent");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrIDTTestCreate() {
        Object id = null;
        try {
            this.messageSent.setText("sending a Text message");
            this.messageSent.setStringProperty("TestCase", "msgHdrIDTTest");
            this.tSender = this.tSession.createPublisher(this.topic);
            this.tSender.publish((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrIDTTest(Message messageReceived) {
        boolean pass = true;
        String id = null;
        String testCase = "msgHdrIDTTest";
        try {
            TestUtil.logTrace((String)"getJMSMessageID ");
            TestUtil.logTrace((String)(" " + messageReceived.getJMSMessageID()));
            id = messageReceived.getJMSMessageID();
            if (id.startsWith("ID:")) {
                TestUtil.logTrace((String)"Pass: JMSMessageID start with ID:");
            } else {
                TestUtil.logMsg((String)"Error: JMSMessageID does not start with ID:");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            TestUtil.logTrace((String)"Sending response message");
            TestUtil.logTrace((String)("==================================Test Results from: " + testCase));
            TestUtil.logTrace((String)("==================================Status: " + results));
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            TestUtil.logTrace((String)("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown"));
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logTrace((String)("Error: " + ee.getClass().getName() + " was thrown"));
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgHdrT  In MsgBeanMsgTestHdrT::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgHdrT  In MsgBeanMsgTestHdrT::remove()!!");
    }
}

