/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.strquery;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Attribute;

public class Client1
extends Util {
    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void joinTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            this.logMsg("Testing default getJoinType");
            JoinType jt = customer.join("aliases").getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                this.logTrace("Received expected:" + jt.name());
                pass1 = true;
            } else {
                this.logErr("Expected:" + JoinType.INNER.name() + ", actual:" + String.valueOf(jt));
            }
            cquery = null;
            this.logMsg("Testing INNER getJoinType");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            jt = customer.join("aliases", JoinType.INNER).getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                this.logTrace("Received expected:" + jt.name());
                pass2 = true;
            } else {
                this.logErr("Expected:" + JoinType.INNER.name() + ", actual:" + String.valueOf(jt));
            }
            cquery = null;
            this.logMsg("Testing LEFT getJoinType");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            jt = customer.join("aliases", JoinType.LEFT).getJoinType();
            if (jt.equals((Object)JoinType.LEFT)) {
                this.logTrace("Received expected:" + jt.name());
                pass3 = true;
            } else {
                this.logErr("Expected:" + JoinType.LEFT.name() + ", actual:" + String.valueOf(jt));
            }
            cquery = null;
            this.logMsg("Testing INNER getAttribute");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            Attribute attr = customer.join("aliases").getAttribute();
            if (attr.getName().equals("aliases")) {
                this.logTrace("Received expected:" + attr.getName());
                pass4 = true;
            } else {
                this.logErr("Expected:aliases, actual:" + attr.getName());
            }
            cquery = null;
            this.logMsg("Testing getParent");
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            From from = customer.join("aliases").getParent();
            if (from.getClass().getName().equals(customer.getClass().getName())) {
                this.logTrace("Received expected:" + from.getClass().getName());
                pass5 = true;
            } else {
                this.logErr("Expected:" + customer.getClass().getName() + ", actual:" + from.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("joinTest failed");
        }
    }

    public void fetchStringAndStringJoinTypeIllegalArgumentException() throws Exception {
        Root customer;
        CriteriaQuery cquery;
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.logMsg("Testing String");
        try {
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            customer.fetch("doesnotexist");
            this.logErr("did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        this.logMsg("Testing String, JoinType");
        try {
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            customer.fetch("doesnotexist", JoinType.INNER);
            this.logErr("did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception:", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fetchStringAndStringJoinTypeIllegalArgumentException failed");
        }
    }
}

