/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.config;

import com.sun.enterprise.config.modularity.annotation.HasNoDefaultConfiguration;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.loadbalancer.config.LbConfig;
import org.glassfish.loadbalancer.config.LbConfigs;
import org.glassfish.loadbalancer.config.LoadBalancers;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
@HasNoDefaultConfiguration
public interface LoadBalancer
extends ConfigBeanProxy,
PropertyBag {
    @Attribute(key=true)
    @NotNull
    public String getName();

    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getLbConfigName();

    public void setLbConfigName(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getDeviceHost();

    public void setDeviceHost(String var1) throws PropertyVetoException;

    @Attribute
    @NotNull
    public String getDevicePort();

    public void setDevicePort(String var1) throws PropertyVetoException;

    @Attribute(dataType=Boolean.class)
    @Deprecated
    public String getAutoApplyEnabled();

    @Deprecated
    public void setAutoApplyEnabled(String var1) throws PropertyVetoException;

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Service
    @PerLookup
    public static class DeleteDecorator
    implements DeletionDecorator<LoadBalancers, LoadBalancer> {
        @Inject
        private Domain domain;

        public void decorate(AdminCommandContext context, LoadBalancers parent, LoadBalancer child) throws PropertyVetoException, TransactionFailure {
            ActionReport report = context.getActionReport();
            Logger logger = LogDomains.getLogger(LoadBalancer.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LoadBalancer.class);
            Transaction t = Transaction.getTransaction((ConfigBeanProxy)parent);
            String lbName = child.getName();
            String lbConfigName = child.getLbConfigName();
            LbConfig lbConfig = ((LbConfigs)this.domain.getExtensionByType(LbConfigs.class)).getLbConfig(lbConfigName);
            for (LoadBalancer lb : ((LoadBalancers)this.domain.getExtensionByType(LoadBalancers.class)).getLoadBalancer()) {
                if (lb.getName().equals(lbName) || !lb.getLbConfigName().equals(lbConfigName)) continue;
                String msg = localStrings.getLocalString("LbConfigIsInUse", lbConfigName);
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                throw new TransactionFailure(msg);
            }
            LbConfigs configs = (LbConfigs)this.domain.getExtensionByType(LbConfigs.class);
            try {
                if (t != null) {
                    LbConfigs c = (LbConfigs)t.enroll((ConfigBeanProxy)configs);
                    List<LbConfig> configList = c.getLbConfig();
                    configList.remove(lbConfig);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.WARNING, localStrings.getLocalString("DeleteLbConfigFailed", "Unable to remove lb config {0}", new Object[]{lbConfigName}), ex);
                String msg = ex.getMessage() != null ? ex.getMessage() : localStrings.getLocalString("DeleteLbConfigFailed", "Unable to remove lb config {0}", new Object[]{lbConfigName});
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)ex);
                throw ex;
            }
        }
    }
}

