/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.StreamOutputSink;
import org.glassfish.grizzly.http2.Termination;

public class UpgradeOutputSink
implements StreamOutputSink {
    private final Http2Session connection;
    private boolean isClosed;

    public UpgradeOutputSink(Http2Session connection) {
        this.connection = connection;
    }

    @Override
    public boolean canWrite() {
        return this.connection.getConnection().canWrite();
    }

    @Override
    public void notifyWritePossible(WriteHandler writeHandler) {
        this.connection.getConnection().notifyCanWrite(writeHandler);
    }

    @Override
    public void onPeerWindowUpdate(int delta) throws Http2StreamException {
    }

    @Override
    public void writeDownStream(HttpPacket httpPacket, FilterChainContext ctx, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void flush(CompletionHandler<Http2Stream> completionHandler) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getUnflushedWritesCount() {
        return 0;
    }

    @Override
    public void close() {
        this.terminate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate(Termination termination) {
        UpgradeOutputSink upgradeOutputSink = this;
        synchronized (upgradeOutputSink) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        termination.doTask();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }
}

