/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.callback;

import com.ibm.jbatch.container.callback.IJobEndCallbackService;
import com.ibm.jbatch.container.callback.JobEndCallback;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;

public class JobEndCallbackManagerImpl
implements IJobEndCallbackService {
    private static final String sourceClass = JobEndCallbackManagerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Set<JobEndCallback> callbacks = new HashSet<JobEndCallback>();
    private long sleepTime = 500L;
    private Set<Long> completedExecutions = new HashSet<Long>();

    @Override
    public synchronized void registerJobEndCallback(JobEndCallback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public synchronized void deregisterJobEndCallback(JobEndCallback callback) {
        this.callbacks.remove(callback);
    }

    @Override
    public synchronized void done(long jobExecutionId) {
        JobEndCallback[] arr;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Firing callbacks for job execution id: " + jobExecutionId);
        }
        this.completedExecutions.add(jobExecutionId);
        for (JobEndCallback callback : arr = this.callbacks.toArray(new JobEndCallback[0])) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Next registered callback: " + callback);
            }
            callback.done(jobExecutionId);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Done firing callbacks for job execution id: " + jobExecutionId);
        }
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCallbackOnTermination(long execID, JobEndCallback callback) throws NoSuchJobExecutionException, JobSecurityException {
        JobEndCallback jobEndCallback = callback;
        synchronized (jobEndCallback) {
            if (!this.completedExecutions.contains(execID)) {
                callback.setExecutionId(execID);
                try {
                    callback.wait(this.sleepTime);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                if (!this.completedExecutions.contains(execID)) {
                    throw new IllegalStateException("Still didn't see a result for executionId: " + execID + ".  Perhaps try increasing timeout.  Or, something else may have gone wrong.");
                }
            }
        }
        this.deregisterJobEndCallback(callback);
        return execID;
    }

    private class JobEndCallbackImpl
    implements JobEndCallback {
        private Long executionIdObj = null;

        private JobEndCallbackImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(long jobExecutionId) {
            JobEndCallbackImpl jobEndCallbackImpl = this;
            synchronized (jobEndCallbackImpl) {
                if (this.executionIdObj != null && this.executionIdObj == jobExecutionId) {
                    this.notify();
                }
            }
        }

        public long getExecutionId() {
            return this.executionIdObj;
        }

        @Override
        public void setExecutionId(long jobExecutionId) {
            this.executionIdObj = jobExecutionId;
        }
    }
}

