/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.ibanno;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.XidImpl;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class IBAnnoMessageListener
implements WorkListener {
    private XidImpl xid;
    private BootstrapContext bsc;

    public IBAnnoMessageListener(XidImpl xid, BootstrapContext bsc) {
        this.xid = xid;
        this.bsc = bsc;
    }

    public void workAccepted(WorkEvent e) {
        ConnectorStatus.getConnectorStatus().logState("IBAnnoMessageListener.workAccepted");
        if (this.xid != null) {
            System.out.println("IBAnnoMessageListener.workAccepted() for XID = " + this.xid.getFormatId());
        } else {
            System.out.println("IBAnnoMessageListener.workAccepted() for XID = null");
        }
    }

    public void workRejected(WorkEvent e) {
        ConnectorStatus.getConnectorStatus().logState("IBAnnoMessageListener.workRejected");
        if (this.xid != null) {
            System.out.println("IBAnnoMessageListener.workRejected() for XID = " + this.xid.getFormatId());
        } else {
            System.out.println("IBAnnoMessageListener.workRejected() for XID = null");
        }
    }

    public void workStarted(WorkEvent e) {
        ConnectorStatus.getConnectorStatus().logState("IBAnnoMessageListener.workStarted");
        System.out.println("IBAnnoMessageListener.workStarted");
    }

    public void workCompleted(WorkEvent e) {
        try {
            XATerminator xt = this.bsc.getXATerminator();
            System.out.println("IBAnnoMessageListener.workCompleted and about to call XATerminator.commit()");
            System.out.println("XID getting used in XATerminator [ " + this.xid.getFormatId() + " ]");
            xt.commit((Xid)this.xid, true);
            ConnectorStatus.getConnectorStatus().logState("IBAnnoMessageListener committed Xid");
        }
        catch (XAException ex) {
            Debug.trace((String)"IBAnnoMessageListener.workCompleted() got XAException");
            Debug.trace((String)("XAException.toString() = " + ex.toString()));
            ex.printStackTrace();
        }
    }
}

