/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-connection-definition-properties-and-defaults")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-connection-definition-properties-and-defaults", description="Get Connection Definition Properties and Defaults")})
public class GetConnectionDefinitionPropertiesAndDefaults
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Param
    private String connectionDefinitionClass;
    @Param
    private String resType;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Map connectionDefinitionPropertiesAndDefaults = this.connectorRuntime.getConnectionDefinitionPropertiesAndDefaults(this.connectionDefinitionClass, this.resType);
            Properties extraProperties = new Properties();
            extraProperties.put("connectionDefinitionPropertiesAndDefaults", connectionDefinitionPropertiesAndDefaults);
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-connection-definition-properties-and-defaults failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

