/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.weld.util.reflection.Reflections;

public class TypeEqualitySpecializationUtils {
    private TypeEqualitySpecializationUtils() {
    }

    public static boolean areTheSame(Type type1, Type type2) {
        if (type1.equals(type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && type2 instanceof ParameterizedType) {
            return TypeEqualitySpecializationUtils.areTheSame((ParameterizedType)type1, (ParameterizedType)type2);
        }
        if (type1 instanceof TypeVariable && type2 instanceof TypeVariable) {
            return TypeEqualitySpecializationUtils.areTheSame((TypeVariable)type1, (TypeVariable)type2);
        }
        return false;
    }

    protected static boolean areTheSame(ParameterizedType type1, ParameterizedType type2) {
        if (!type1.getRawType().equals(type2.getRawType())) {
            return false;
        }
        return TypeEqualitySpecializationUtils.areTheSame(type1.getActualTypeArguments(), type2.getActualTypeArguments());
    }

    protected static boolean areTheSame(TypeVariable<?> type1, TypeVariable<?> type2) {
        List<Type> bounds1 = TypeEqualitySpecializationUtils.removeRedundantBounds(type1.getBounds());
        List<Type> bounds2 = TypeEqualitySpecializationUtils.removeRedundantBounds(type2.getBounds());
        if (bounds1.size() != bounds2.size()) {
            return false;
        }
        for (Type type : bounds1) {
            if (TypeEqualitySpecializationUtils.isTheSameAsSomeOf(type, bounds2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTheSameAsSomeOf(Type bound1, List<Type> bounds2) {
        for (Type type : bounds2) {
            if (!TypeEqualitySpecializationUtils.areTheSame(bound1, type)) continue;
            return true;
        }
        return false;
    }

    private static List<Type> removeRedundantBounds(Type[] bounds) {
        if (bounds.length == 1) {
            return Collections.singletonList(bounds[0]);
        }
        LinkedList<Type> result = new LinkedList<Type>();
        for (int i = 0; i < bounds.length; ++i) {
            boolean isRedundant = false;
            for (int j = 0; j < bounds.length && i != j; ++j) {
                if (!Reflections.getRawType(bounds[i]).isAssignableFrom(Reflections.getRawType(bounds[j]))) continue;
                isRedundant = true;
                break;
            }
            if (isRedundant) continue;
            result.add(bounds[i]);
        }
        return result;
    }

    protected static boolean areTheSame(Type[] types1, Type[] types2) {
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            if (TypeEqualitySpecializationUtils.areTheSame(types1[i], types2[i])) continue;
            return false;
        }
        return true;
    }
}

