/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.jsl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class JSLLoader {
    private static final Logger logger = Logger.getLogger(JSLLoader.class.getName());
    private Set<URI> jobFilelist = Collections.synchronizedSet(new LinkedHashSet());
    public static final String JOBS_FOLDER = "META-INF/jobs";

    public void traverseJobPath() {
    }

    public Set<URI> getArtifacts(URL rootURL) throws FileNotFoundException, IOException, URISyntaxException {
        JarFile jarfile = new JarFile(new File(rootURL.toURI()));
        Enumeration<JarEntry> jarEntries = jarfile.entries();
        if (jarEntries == null) {
            throw new IllegalArgumentException();
        }
        while (jarEntries.hasMoreElements()) {
            String entry = jarEntries.nextElement().getName();
            if (!entry.startsWith(JOBS_FOLDER) || entry.endsWith("/")) continue;
            this.jobFilelist.add(new URI(null, entry, null));
        }
        return this.jobFilelist;
    }

    private Set<URI> getFolderArtifacts(File directory) throws FileNotFoundException, IOException, URISyntaxException {
        File[] xmlFiles;
        for (File file : xmlFiles = directory.listFiles(new XMLFilenameFilter())) {
            this.jobFilelist.add(file.toURI());
        }
        return this.jobFilelist;
    }

    private class XMLFilenameFilter
    implements FilenameFilter {
        private XMLFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String fileName) {
            return fileName.endsWith(".xml");
        }
    }
}

