/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class LoggingXMLReader
implements XMLReader {
    PrintWriter log;
    XMLReader reader;

    public LoggingXMLReader(OutputStream log, XMLReader reader) {
        this(new PrintWriter(log), reader);
    }

    public LoggingXMLReader(PrintWriter log, XMLReader reader) {
        this.log = log;
        this.reader = reader;
    }

    @Override
    public int next() {
        int nextState = this.reader.next();
        this.log.println("Next state: " + XMLReaderUtil.getStateName(this.reader));
        return nextState;
    }

    @Override
    public int nextContent() {
        int nextState = this.reader.nextContent();
        this.log.println("Next content state: " + XMLReaderUtil.getStateName(this.reader));
        return nextState;
    }

    @Override
    public int nextElementContent() {
        int nextState = this.reader.nextElementContent();
        this.log.println("Next element content state: " + XMLReaderUtil.getStateName(this.reader));
        return nextState;
    }

    @Override
    public int getState() {
        int currentState = this.reader.getState();
        this.log.println("Current state: " + XMLReaderUtil.getStateName(this.reader));
        return currentState;
    }

    @Override
    public QName getName() {
        QName name = this.reader.getName();
        this.log.println("name: " + name);
        return name;
    }

    @Override
    public String getURI() {
        String uri = this.reader.getURI();
        this.log.println("uri: " + uri);
        return uri;
    }

    @Override
    public String getLocalName() {
        String localName = this.reader.getLocalName();
        this.log.println("localName: " + localName);
        return localName;
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = this.reader.getAttributes();
        this.log.println("attributes: " + attributes);
        return attributes;
    }

    @Override
    public String getValue() {
        String value = this.reader.getValue();
        this.log.println("value: " + value);
        return value;
    }

    @Override
    public int getElementId() {
        int id = this.reader.getElementId();
        this.log.println("id: " + id);
        return id;
    }

    @Override
    public int getLineNumber() {
        int lineNumber = this.reader.getLineNumber();
        this.log.println("lineNumber: " + lineNumber);
        return lineNumber;
    }

    @Override
    public String getURI(String prefix) {
        String uri = this.reader.getURI(prefix);
        this.log.println("uri for: " + prefix + ": " + uri);
        return uri;
    }

    @Override
    public Iterator getPrefixes() {
        return this.reader.getPrefixes();
    }

    @Override
    public XMLReader recordElement() {
        return this.reader.recordElement();
    }

    @Override
    public void skipElement() {
        this.reader.skipElement();
        this.log.println("Skipped to: " + XMLReaderUtil.getStateName(this.reader));
    }

    @Override
    public void skipElement(int elementId) {
        this.reader.skipElement(elementId);
        this.log.println("Skipped to: " + XMLReaderUtil.getStateName(this.reader));
    }

    @Override
    public void close() {
        this.reader.close();
        this.log.println("reader closed");
    }
}

