/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.embedded;

import java.io.File;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PreDestroy;

public class EmbeddedFileSystem
implements PreDestroy {
    public final boolean autoDelete;
    public final boolean readOnlyConfigFile;
    public final boolean cookedMode;
    public final File installRoot;
    public final File instanceRoot;
    public final File configFile;

    private EmbeddedFileSystem(Builder builder) {
        this.autoDelete = builder.autoDelete;
        this.readOnlyConfigFile = builder.readOnly;
        this.installRoot = builder.installRoot;
        this.instanceRoot = builder.instanceRoot;
        this.configFile = builder.configFile;
        this.cookedMode = builder.cookedMode;
    }

    public void preDestroy() {
        Logger.getAnonymousLogger().finer("delete " + this.instanceRoot + " = " + this.autoDelete);
        if (this.autoDelete && this.instanceRoot != null) {
            Logger.getAnonymousLogger().finer("Deleting recursively" + this.instanceRoot);
            this.deleteAll(this.instanceRoot);
        }
    }

    private void deleteAll(File f) {
        for (File child : f.listFiles()) {
            if (child.isDirectory()) {
                this.deleteAll(child);
                continue;
            }
            child.delete();
        }
        f.delete();
    }

    void copy(Builder that) {
        that.autoDelete(this.autoDelete);
        that.configurationFile(this.configFile, this.readOnlyConfigFile);
        that.installRoot(this.installRoot, this.cookedMode);
        that.instanceRoot(this.instanceRoot);
    }

    public static class Builder {
        boolean autoDelete = false;
        boolean readOnly = true;
        boolean cookedMode = false;
        File configFile = null;
        File installRoot = null;
        File instanceRoot = null;

        public Builder autoDelete(boolean b) {
            this.autoDelete = b;
            return this;
        }

        public Builder configurationFile(File f) {
            return this.configurationFile(f, true);
        }

        public Builder configurationFile(File f, boolean readOnly) {
            this.configFile = f;
            this.readOnly = readOnly;
            return this;
        }

        public Builder installRoot(File f) {
            return this.installRoot(f, false);
        }

        public Builder installRoot(File f, boolean cookedMode) {
            this.installRoot = f;
            this.cookedMode = cookedMode;
            return this;
        }

        public Builder instanceRoot(File f) {
            this.instanceRoot = f;
            if (this.configFile == null) {
                File tmp = new File(this.instanceRoot, "config");
                this.configFile = new File(tmp, "domain.xml");
                if (!this.configFile.exists()) {
                    this.configFile = null;
                }
            }
            return this;
        }

        public EmbeddedFileSystem build() {
            return new EmbeddedFileSystem(this);
        }

        public String toString() {
            return "EmbeddedFileSystem>>installRoot = " + this.installRoot + ", instanceRoot=" + this.instanceRoot + ",configFile=" + this.configFile + ",autoDelete=" + this.autoDelete;
        }
    }
}

