/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.enterprise.transaction.api.TransactionImport;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TopCoordinator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Vote;

public class XATerminatorImpl
implements XATerminator {
    private static final TransactionImport tim = XATerminatorImpl.getTransactionImportManager();
    private static final String AS_TXN_MGR_JNDI_NAME = "java:appserver/TransactionManager";

    private static void check(Xid xid) throws XAException {
        if (xid == null || xid.getFormatId() == 0 || xid.getBranchQualifier() == null || xid.getGlobalTransactionId() == null) {
            throw new XAException(-4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XATerminatorImpl.check(xid);
        tid = new GlobalTID(xid);
        if (onePhase) {
            try {
                XATerminatorImpl.recreate(xid, 0);
            }
            catch (Throwable e) {
                xaExc = new XAException(-6);
                xaExc.initCause(e);
                throw xaExc;
            }
        } else if (!RecoveryManager.readAndUpdateTxMap(tid)) {
            throw new XAException(-6);
        }
        exceptionFlag = false;
        errorCode = -6;
        try {
            RecoveryManager.waitForRecovery();
            coord = (TopCoordinator)RecoveryManager.getCoordinator(tid);
            if (coord == null) {
                errorCode = -6;
                throw new XAException(errorCode);
            }
            var7_11 = coord;
            synchronized (var7_11) {
                if (onePhase) {
                    coord.beforeCompletion();
                    if (coord.getParticipantCount() == 1) {
                        coord.commitOnePhase();
                    } else {
                        try {
                            vote = coord.prepare();
                        }
                        catch (HeuristicMixed exc) {
                            errorCode = 8;
                            throw new XAException(errorCode);
                        }
                        if (vote == Vote.VoteCommit) {
                            coord.commit();
                        } else if (vote == Vote.VoteRollback) {
                            coord.rollback(true);
                        }
                    }
                } else {
                    coord.commit();
                }
            }
        }
        catch (Throwable exc) {
            exceptionFlag = true;
            xaExc = new XAException(errorCode);
            xaExc.initCause(exc);
            throw xaExc;
        }
        finally {
            if (onePhase) {
                try {
                    XATerminatorImpl.release(xid);
                }
                catch (Throwable t) {
                    if (exceptionFlag) ** GOTO lbl67
                    xaExc = new XAException(-6);
                    xaExc.initCause(t);
                    throw xaExc;
                }
            } else {
                thread = RecoveryManager.removeFromTxMap(tid);
                if (!(thread != null && thread == Thread.currentThread() || exceptionFlag)) {
                    throw new XAException(-3);
                }
            }
lbl67:
            // 4 sources

        }
    }

    public void forget(Xid xid) throws XAException {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int prepare(Xid xid) throws XAException {
        int errorCode;
        boolean exceptionFlag;
        block19: {
            Vote vote;
            block20: {
                XATerminatorImpl.check(xid);
                GlobalTID tid = new GlobalTID(xid);
                try {
                    XATerminatorImpl.recreate(xid, 0);
                }
                catch (Throwable e) {
                    XAException xaExc = new XAException(-6);
                    xaExc.initCause(e);
                    throw xaExc;
                }
                exceptionFlag = false;
                errorCode = -6;
                RecoveryManager.waitForRecovery();
                TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(tid);
                if (coord == null) {
                    errorCode = -6;
                    throw new XAException(errorCode);
                }
                TopCoordinator topCoordinator = coord;
                // MONITORENTER : topCoordinator
                coord.beforeCompletion();
                vote = coord.prepare();
                if (vote == Vote.VoteRollback) {
                    errorCode = 100;
                    break block19;
                }
                if (vote != Vote.VoteCommit) break block20;
                int n = 0;
                // MONITOREXIT : topCoordinator
                try {
                    XATerminatorImpl.release(xid);
                    return n;
                }
                catch (Throwable t) {
                    if (exceptionFlag) return n;
                    errorCode = -6;
                    XAException xaExc = new XAException(errorCode);
                    xaExc.initCause(t);
                    throw xaExc;
                }
            }
            if (vote != Vote.VoteReadOnly) break block19;
            int n = 3;
            // MONITOREXIT : topCoordinator
            {
                catch (Throwable exc) {
                    exceptionFlag = true;
                    XAException xaExc = new XAException(errorCode);
                    xaExc.initCause(exc);
                    throw xaExc;
                }
            }
            try {
                XATerminatorImpl.release(xid);
                return n;
            }
            catch (Throwable t) {
                if (exceptionFlag) return n;
                errorCode = -6;
                XAException xaExc = new XAException(errorCode);
                xaExc.initCause(t);
                throw xaExc;
            }
        }
        try {
            throw new XAException(errorCode);
        }
        catch (Throwable throwable) {
            try {
                XATerminatorImpl.release(xid);
                throw throwable;
            }
            catch (Throwable t) {
                if (exceptionFlag) throw throwable;
                errorCode = -6;
                XAException xaExc = new XAException(errorCode);
                xaExc.initCause(t);
                throw xaExc;
            }
        }
    }

    public Xid[] recover(int flag) throws XAException {
        RecoveryManager.waitForResync();
        return TimeoutManager.getInDoubtXids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        XATerminatorImpl.check(xid);
        GlobalTID tid = new GlobalTID(xid);
        if (!RecoveryManager.readAndUpdateTxMap(tid)) {
            throw new XAException(-6);
        }
        boolean exceptionFlag = false;
        int errorCode = -6;
        try {
            RecoveryManager.waitForRecovery();
            TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(tid);
            if (coord == null) {
                errorCode = -6;
                throw new XAException(errorCode);
            }
            TopCoordinator topCoordinator = coord;
            synchronized (topCoordinator) {
                coord.rollback(true);
            }
        }
        catch (Throwable exc) {
            exceptionFlag = true;
            XAException xaExc = new XAException(errorCode);
            xaExc.initCause(exc);
            throw xaExc;
        }
        finally {
            Thread thread = RecoveryManager.removeFromTxMap(tid);
            if (!(thread != null && thread == Thread.currentThread() || exceptionFlag)) {
                throw new XAException(-3);
            }
        }
    }

    private static Object jndiLookup(String jndiName) {
        Object result = null;
        try {
            InitialContext ctx = new InitialContext();
            result = ctx.lookup(jndiName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return result;
    }

    private static TransactionImport getTransactionImportManager() {
        return (TransactionImport)XATerminatorImpl.jndiLookup(AS_TXN_MGR_JNDI_NAME);
    }

    private static void recreate(Xid xid, int timeout) {
        if (tim != null) {
            tim.recreate(xid, (long)timeout);
        }
    }

    private static void release(Xid xid) {
        if (tim != null) {
            tim.release(xid);
        }
    }
}

