/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.datastructure;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.enterprise.resource.pool.datastructure.ListDataStructure;
import com.sun.enterprise.resource.pool.datastructure.RWLockDataStructure;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataStructureFactory {
    protected static final Logger _logger = LogDomains.getLogger(DataStructureFactory.class, (String)"javax.enterprise.resource.resourceadapter");

    public static DataStructure getDataStructure(String className, String parameters, int maxPoolSize, ResourceHandler handler, String strategyClass) throws PoolingException {
        DataStructure ds;
        if (className != null) {
            ds = className.equals(ListDataStructure.class.getName()) ? new ListDataStructure(parameters, maxPoolSize, handler, strategyClass) : (className.equals(RWLockDataStructure.class.getName()) ? new RWLockDataStructure(parameters, maxPoolSize, handler, strategyClass) : DataStructureFactory.initializeCustomDataStructureInPrivilegedMode(className, parameters, maxPoolSize, handler, strategyClass));
        } else {
            DataStructureFactory.debug("Initializing RWLock DataStructure");
            ds = new RWLockDataStructure(parameters, maxPoolSize, handler, strategyClass);
        }
        return ds;
    }

    private static DataStructure initializeCustomDataStructureInPrivilegedMode(final String className, final String parameters, final int maxPoolSize, final ResourceHandler handler, final String strategyClass) throws PoolingException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DataStructure result = null;
                try {
                    result = DataStructureFactory.initializeDataStructure(className, parameters, maxPoolSize, handler, strategyClass);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "pool.datastructure.init.failure", className);
                    _logger.log(Level.WARNING, "pool.datastructure.init.failure.exception", e);
                }
                return result;
            }
        });
        if (result != null) {
            return (DataStructure)result;
        }
        throw new PoolingException("Unable to initalize custom DataStructure : " + className);
    }

    private static DataStructure initializeDataStructure(String className, String parameters, int maxPoolSize, ResourceHandler handler, String strategyClass) throws Exception {
        Object[] constructorParameters = new Object[]{parameters, maxPoolSize, handler, strategyClass};
        Class<?> class1 = Thread.currentThread().getContextClassLoader().loadClass(className);
        Constructor<?> constructor = class1.getConstructor(String.class, Integer.TYPE, ResourceHandler.class, String.class);
        DataStructure ds = (DataStructure)constructor.newInstance(constructorParameters);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Using Pool Data Structure : ", className);
        }
        return ds;
    }

    private static void debug(String debugStatement) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, debugStatement);
        }
    }
}

