/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.logging.LogDomains;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RWLock {
    int currentReaders;
    int pendingReaders;
    int currentWriters;
    static Logger _logger = LogDomains.getLogger(RWLock.class, (String)"javax.enterprise.system.core.transaction");
    Queue writerQueue = new Queue();

    public synchronized void acquireReadLock() {
        if (this.currentWriters == 0 && this.writerQueue.size() == 0) {
            ++this.currentReaders;
        } else {
            ++this.pendingReaders;
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                _logger.log(Level.FINE, "Error in acquireReadLock", ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWriteLock() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            RWLock rWLock = this;
            synchronized (rWLock) {
                if (this.writerQueue.size() == 0 && this.currentReaders == 0 && this.currentWriters == 0) {
                    ++this.currentWriters;
                    return;
                }
                this.writerQueue.enQueue(lock);
            }
            try {
                lock.wait();
            }
            catch (InterruptedException ie) {
                _logger.log(Level.FINE, "Error in acquireWriteLock", ie);
            }
        }
    }

    public boolean isWriteLocked() {
        return this.currentWriters > 0;
    }

    public synchronized void releaseReadLock() {
        if (--this.currentReaders == 0) {
            this.notifyWriters();
        }
    }

    public synchronized void releaseWriteLock() {
        --this.currentWriters;
        if (this.pendingReaders > 0) {
            this.notifyReaders();
        } else {
            this.notifyWriters();
        }
    }

    private void notifyReaders() {
        this.currentReaders += this.pendingReaders;
        this.pendingReaders = 0;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWriters() {
        if (this.writerQueue.size() > 0) {
            Object lock = this.writerQueue.deQueueFirst();
            ++this.currentWriters;
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
        }
    }

    class Queue
    extends LinkedList {
        public void enQueue(Object o) {
            super.addLast(o);
        }

        public Object deQueueFirst() {
            return super.removeFirst();
        }
    }
}

