/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Qualifier;
import org.glassfish.jersey.ext.cdi1x.internal.DefaultBeanManagerProvider;
import org.glassfish.jersey.ext.cdi1x.internal.SingleInjectionManagerStore;
import org.glassfish.jersey.ext.cdi1x.internal.spi.BeanManagerProvider;
import org.glassfish.jersey.ext.cdi1x.internal.spi.InjectionManagerStore;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;

public final class CdiUtil {
    private static final BeanManagerProvider BEAN_MANAGER_PROVIDER = new DefaultBeanManagerProvider();

    private CdiUtil() {
        throw new AssertionError((Object)"No instances allowed.");
    }

    public static Annotation[] getQualifiers(Annotation[] annotations) {
        ArrayList<Annotation> result = new ArrayList<Annotation>(annotations.length);
        for (Annotation a : annotations) {
            if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            result.add(a);
        }
        return result.toArray(new Annotation[result.size()]);
    }

    public static BeanManager getBeanManager() {
        BeanManagerProvider provider = CdiUtil.lookupService(BeanManagerProvider.class);
        if (provider != null) {
            return provider.getBeanManager();
        }
        return BEAN_MANAGER_PROVIDER.getBeanManager();
    }

    static InjectionManagerStore createHk2InjectionManagerStore() {
        InjectionManagerStore manager = CdiUtil.lookupService(InjectionManagerStore.class);
        return manager != null ? manager : new SingleInjectionManagerStore();
    }

    static <T> T lookupService(Class<T> clazz) {
        LinkedList<RankedProvider> providers = new LinkedList<RankedProvider>();
        for (Object provider : ServiceFinder.find(clazz)) {
            providers.add(new RankedProvider(provider));
        }
        Collections.sort(providers, new RankedComparator(RankedComparator.Order.ASCENDING));
        return (T)(providers.isEmpty() ? null : ((RankedProvider)providers.get(0)).getProvider());
    }

    static <T> T getBeanReference(Class<T> clazz, Bean bean, BeanManager beanManager) {
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        Object result = beanManager.getReference(bean, clazz, creationalContext);
        return clazz.cast(result);
    }

    public static Class<? extends Annotation> getBeanScope(Class<?> beanClass, BeanManager beanManager) {
        Set beans = beanManager.getBeans(beanClass, new Annotation[0]);
        if (beans.isEmpty()) {
            return null;
        }
        Iterator iterator = beans.iterator();
        if (iterator.hasNext()) {
            Bean b = (Bean)iterator.next();
            return b.getScope();
        }
        return null;
    }
}

