/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.security.webservices.CommonServerSecurityPipe;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import java.util.HashMap;
import javax.inject.Singleton;
import javax.xml.namespace.QName;
import org.glassfish.webservices.ServerPipeCreator;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class GFServerPipeCreator
extends ServerPipeCreator {
    private static final String SECURITY_POLICY_NAMESPACE_URI_SUBMISSION = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy";
    private static final String SECURITY_POLICY_NAMESPACE_URI_SPECVERSION = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";

    public void init(WebServiceEndpoint ep) {
        super.init(ep);
    }

    public Pipe createSecurityPipe(PolicyMap map, SEIModel sei, WSDLPort port, WSEndpoint owner, Pipe tail) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("POLICY", map);
        props.put("SEI_MODEL", sei);
        props.put("WSDL_MODEL", port);
        props.put("ENDPOINT", owner);
        props.put("SERVICE_ENDPOINT", this.endpoint);
        props.put("NEXT_PIPE", tail);
        props.put("CONTAINER", owner.getContainer());
        if (GFServerPipeCreator.isSecurityEnabled(map, port)) {
            this.endpoint.setSecurePipeline();
        }
        return new CommonServerSecurityPipe(props, tail, this.isHttpBinding);
    }

    public static boolean isSecurityEnabled(PolicyMap policyMap, WSDLPort wsdlPort) {
        if (policyMap == null || wsdlPort == null) {
            return false;
        }
        try {
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey((QName)wsdlPort.getOwner().getName(), (QName)wsdlPort.getName());
            Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
            if (policy != null && (policy.contains(SECURITY_POLICY_NAMESPACE_URI_SPECVERSION) || policy.contains(SECURITY_POLICY_NAMESPACE_URI_SUBMISSION))) {
                return true;
            }
            for (WSDLBoundOperation wbo : wsdlPort.getBinding().getBindingOperations()) {
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey((QName)wsdlPort.getOwner().getName(), (QName)wsdlPort.getName(), (QName)wbo.getName());
                policy = policyMap.getOperationEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SECURITY_POLICY_NAMESPACE_URI_SPECVERSION) || policy.contains(SECURITY_POLICY_NAMESPACE_URI_SUBMISSION))) {
                    return true;
                }
                policy = policyMap.getInputMessageEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SECURITY_POLICY_NAMESPACE_URI_SPECVERSION) || policy.contains(SECURITY_POLICY_NAMESPACE_URI_SUBMISSION))) {
                    return true;
                }
                policy = policyMap.getOutputMessageEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SECURITY_POLICY_NAMESPACE_URI_SPECVERSION) || policy.contains(SECURITY_POLICY_NAMESPACE_URI_SUBMISSION))) {
                    return true;
                }
                policy = policyMap.getFaultMessageEffectivePolicy(operationKey);
                if (policy == null || !policy.contains(SECURITY_POLICY_NAMESPACE_URI_SPECVERSION) && !policy.contains(SECURITY_POLICY_NAMESPACE_URI_SUBMISSION)) continue;
                return true;
            }
        }
        catch (PolicyException e) {
            return false;
        }
        return false;
    }
}

