/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.util.AnnotationLiteral;
import javax.transaction.TransactionScoped;
import org.glassfish.jms.injection.InjectableJMSContext;
import org.glassfish.jms.injection.RequestedJMSContextManager;
import org.glassfish.jms.injection.TransactedJMSContextManager;

public class JMSCDIExtension
implements Extension {
    private Bean createLocalBean(BeanManager beanManager, Class beanClass) {
        AnnotatedType annotatedType = beanManager.createAnnotatedType(beanClass);
        LocalPassivationCapableBean localBean = new LocalPassivationCapableBean(beanClass);
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        localBean.setInjectionTarget(injectionTargetFactory.createInjectionTarget((Bean)localBean));
        return localBean;
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscoveryEvent, BeanManager beanManager) {
        Bean requestManagerBean = this.createLocalBean(beanManager, RequestedJMSContextManager.class);
        afterBeanDiscoveryEvent.addBean(requestManagerBean);
        Bean transactionManagerBean = this.createLocalBean(beanManager, TransactedJMSContextManager.class);
        afterBeanDiscoveryEvent.addBean(transactionManagerBean);
        Bean contextBean = this.createLocalBean(beanManager, InjectableJMSContext.class);
        afterBeanDiscoveryEvent.addBean(contextBean);
    }

    void addScope(@Observes BeforeBeanDiscovery event) {
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event) {
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
    }

    public void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
    }

    public <T> void processInjectionTarget(@Observes ProcessInjectionTarget<T> pit) {
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
    }

    public <T, X> void processProducer(@Observes ProcessProducer<T, X> event) {
    }

    static AnnotationLiteral<Default> getDefaultAnnotationLiteral() {
        return new AnnotationLiteral<Default>(){};
    }

    static AnnotationLiteral<Any> getAnyAnnotationLiteral() {
        return new AnnotationLiteral<Any>(){};
    }

    public static class LocalPassivationCapableBean
    implements Bean,
    PassivationCapable {
        private String id = UUID.randomUUID().toString();
        private Class beanClass;
        private InjectionTarget injectionTarget;

        public LocalPassivationCapableBean(Class beanClass) {
            this.beanClass = beanClass;
        }

        public LocalPassivationCapableBean(Class beanClass, InjectionTarget injectionTarget) {
            this.beanClass = beanClass;
            this.injectionTarget = injectionTarget;
        }

        public void setInjectionTarget(InjectionTarget injectionTarget) {
            this.injectionTarget = injectionTarget;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionTarget.getInjectionPoints();
        }

        public String getName() {
            return this.beanClass.getName();
        }

        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            qualifiers.add((Annotation)JMSCDIExtension.getDefaultAnnotationLiteral());
            qualifiers.add((Annotation)JMSCDIExtension.getAnyAnnotationLiteral());
            return qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            if (this.beanClass.isAnnotationPresent(RequestScoped.class)) {
                return RequestScoped.class;
            }
            if (this.beanClass.isAnnotationPresent(TransactionScoped.class)) {
                return TransactionScoped.class;
            }
            return Dependent.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            HashSet<Type> types = new HashSet<Type>();
            types.add(this.beanClass);
            boolean loop = true;
            Class clazz = this.beanClass;
            while (loop) {
                Class<?>[] interfaces;
                for (Class<?> t : interfaces = clazz.getInterfaces()) {
                    types.add(t);
                }
                if ((clazz = clazz.getSuperclass()) == null) {
                    loop = false;
                    break;
                }
                types.add(clazz);
            }
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }

        public Object create(CreationalContext ctx) {
            Object instance = this.injectionTarget.produce(ctx);
            this.injectionTarget.inject(instance, ctx);
            this.injectionTarget.postConstruct(instance);
            return instance;
        }

        public void destroy(Object instance, CreationalContext ctx) {
            this.injectionTarget.preDestroy(instance);
            this.injectionTarget.dispose(instance);
            ctx.release();
        }

        public String getId() {
            return this.id;
        }
    }
}

