/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.artifact.proxy.BatchletProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.SingleThreadedStepControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Batchlet;
import com.ibm.jbatch.jsl.model.Partition;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

public class BatchletStepControllerImpl
extends SingleThreadedStepControllerImpl {
    private static final String sourceClass = BatchletStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private BatchletProxy batchletProxy;

    public BatchletStepControllerImpl(RuntimeJobExecution jobExecutionImpl, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerStatusQueue) {
        super(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerStatusQueue);
    }

    private void invokeBatchlet(Batchlet batchlet) throws BatchContainerServiceException {
        String batchletId = batchlet.getRef();
        List<Property> propList = batchlet.getProperties() == null ? null : batchlet.getProperties().getPropertyList();
        String sourceMethod = "invokeBatchlet";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod, batchletId);
        }
        Object exitStatus = null;
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
        try {
            this.batchletProxy = ProxyFactory.createBatchletProxy(batchletId, injectionRef, this.stepContext);
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the batchlet [" + batchletId + "]", e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Batchlet is loaded and validated: " + this.batchletProxy);
        }
        if (this.wasStopIssued()) {
            logger.fine("Exit without executing batchlet since stop() request has been received.");
        } else {
            logger.fine("Starting process() for the Batchlet Artifact");
            String processRetVal = this.batchletProxy.process();
            logger.fine("Set process() return value = " + processRetVal + " for possible use as exitStatus");
            this.stepContext.setBatchletProcessRetVal(processRetVal);
            logger.exiting(sourceClass, sourceMethod, exitStatus == null ? "<null>" : exitStatus);
        }
    }

    protected synchronized boolean wasStopIssued() {
        if (this.jobExecutionImpl.getJobContext().getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
            this.stepContext.setBatchStatus(BatchStatus.STOPPING);
            return true;
        }
        return false;
    }

    @Override
    protected void invokeCoreStep() throws BatchContainerServiceException {
        Partition partition = this.step.getPartition();
        if (partition != null) {
            // empty if block
        }
        try {
            this.invokeBatchlet(this.step.getBatchlet());
        }
        finally {
            this.invokeCollectorIfPresent();
        }
    }

    @Override
    public synchronized void stop() {
        if (BatchStatus.STARTING.equals((Object)this.stepContext.getBatchStatus()) || BatchStatus.STARTED.equals((Object)this.stepContext.getBatchStatus())) {
            this.stepContext.setBatchStatus(BatchStatus.STOPPING);
            if (this.batchletProxy != null) {
                this.batchletProxy.stop();
            }
        }
    }
}

