/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="runtime-mon", group="monitoring")
@ManagedObject
@Description(value="JVM Runtime Statistics")
public class JVMRuntimeStatsProvider {
    private RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
    private StringStatisticImpl bootClassPath = new StringStatisticImpl("BootClassPath", "String", "Boot class path that is used by the bootstrap class loader to search for class files");
    private StringStatisticImpl classPath = new StringStatisticImpl("ClassPath", "String", "Java class path that is used by the system class loader to search for class files");
    private StringStatisticImpl inputArguments = new StringStatisticImpl("InputArguments", "String", "Input arguments passed to the Java virtual machine which does not include the arguments to the main method");
    private StringStatisticImpl libraryPath = new StringStatisticImpl("LibraryPath", "String", "Java library path");
    private StringStatisticImpl mgmtSpecVersion = new StringStatisticImpl("ManagementSpecVersion", "String", "Version of the specification for the management interface implemented by the running Java virtual machine");
    private StringStatisticImpl runtimeName = new StringStatisticImpl("Name", "String", "Name representing the running Java virtual machine");
    private StringStatisticImpl specName = new StringStatisticImpl("SpecName", "String", "Java virtual machine specification name");
    private StringStatisticImpl specVendor = new StringStatisticImpl("SpecVendor", "String", "Java virtual machine specification vendor");
    private StringStatisticImpl specVersion = new StringStatisticImpl("SpecVersion", "String", "Java virtual machine specification version");
    private CountStatisticImpl uptime = new CountStatisticImpl("Uptime", "millisecond", "Uptime of the Java virtual machine in milliseconds");
    private StringStatisticImpl vmName = new StringStatisticImpl("VmName", "String", "Java virtual machine implementation name");
    private StringStatisticImpl vmVendor = new StringStatisticImpl("VmVendor", "String", "Java virtual machine implementation vendor");
    private StringStatisticImpl vmVersion = new StringStatisticImpl("VmVersion", "String", "Java virtual machine implementation version");

    @ManagedAttribute(id="bootclasspath-current")
    @Description(value="boot class path that is used by the bootstrap class loader to search for class files")
    public StringStatistic getBootClassPath() {
        this.bootClassPath.setCurrent(this.rtBean.getBootClassPath());
        return this.bootClassPath;
    }

    @ManagedAttribute(id="classpath-current")
    @Description(value="Java class path that is used by the system class loader to search for class files")
    public StringStatistic getClassPath() {
        this.classPath.setCurrent(this.rtBean.getClassPath());
        return this.classPath;
    }

    @ManagedAttribute(id="inputarguments-current")
    @Description(value="input arguments passed to the Java virtual machine which does not include the arguments to the main method")
    public StringStatistic getInputArguments() {
        List<String> inputList = this.rtBean.getInputArguments();
        StringBuffer sb = new StringBuffer();
        for (String arg : inputList) {
            sb.append(arg);
            sb.append(", ");
        }
        String finalString = sb.substring(0, sb.lastIndexOf(","));
        this.inputArguments.setCurrent(finalString);
        return this.inputArguments;
    }

    @ManagedAttribute(id="librarypath-current")
    @Description(value="Java library path")
    public StringStatistic getLibraryPath() {
        this.libraryPath.setCurrent(this.rtBean.getLibraryPath());
        return this.libraryPath;
    }

    @ManagedAttribute(id="managementspecversion-current")
    @Description(value="version of the specification for the management interface implemented by the running Java virtual machine")
    public StringStatistic getManagementSpecVersion() {
        this.mgmtSpecVersion.setCurrent(this.rtBean.getManagementSpecVersion());
        return this.mgmtSpecVersion;
    }

    @ManagedAttribute(id="name-current")
    @Description(value="name representing the running Java virtual machine")
    public StringStatistic getRuntimeName() {
        this.runtimeName.setCurrent(this.rtBean.getName());
        return this.runtimeName;
    }

    @ManagedAttribute(id="specname-current")
    @Description(value="Java virtual machine specification name")
    public StringStatistic getSpecName() {
        this.specName.setCurrent(this.rtBean.getSpecName());
        return this.specName;
    }

    @ManagedAttribute(id="specvendor-current")
    @Description(value="Java virtual machine specification vendor")
    public StringStatistic getSpecVendor() {
        this.specVendor.setCurrent(this.rtBean.getSpecVendor());
        return this.specVendor;
    }

    @ManagedAttribute(id="specversion-current")
    @Description(value="Java virtual machine specification version")
    public StringStatistic getSpecVersion() {
        this.specVersion.setCurrent(this.rtBean.getSpecVersion());
        return this.specVersion;
    }

    @ManagedAttribute(id="uptime-count")
    @Description(value="uptime of the Java virtual machine in milliseconds")
    public CountStatistic getUptime() {
        this.uptime.setCount(this.rtBean.getUptime());
        return this.uptime;
    }

    @ManagedAttribute(id="vmname-current")
    @Description(value="Java virtual machine implementation name")
    public StringStatistic getVmName() {
        this.vmName.setCurrent(this.rtBean.getVmName());
        return this.vmName;
    }

    @ManagedAttribute(id="vmvendor-current")
    @Description(value="Java virtual machine implementation vendor")
    public StringStatistic getVmVendor() {
        this.vmVendor.setCurrent(this.rtBean.getVmVendor());
        return this.vmVendor;
    }

    @ManagedAttribute(id="vmversion-current")
    @Description(value="Java virtual machine implementation version")
    public StringStatistic getVmVersion() {
        this.vmVersion.setCurrent(this.rtBean.getVmVersion());
        return this.vmVersion;
    }
}

