/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.inject.ClassUtils;
import org.apache.felix.scr.impl.inject.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.metadata.DSVersion;

public abstract class BaseMethod<P, T> {
    private final DSVersion dsVersion;
    private final boolean configurableServiceProperties;
    private final String m_methodName;
    private final Class<?> m_componentClass;
    private volatile Method m_method;
    private final boolean m_methodRequired;
    private volatile State m_state;

    protected BaseMethod(String methodName, Class<?> componentClass, DSVersion dsVersion, boolean configurableServiceProperties) {
        this(methodName, methodName != null, componentClass, dsVersion, configurableServiceProperties);
    }

    protected BaseMethod(String methodName, boolean methodRequired, Class<?> componentClass, DSVersion dsVersion, boolean configurableServiceProperties) {
        this.m_methodName = methodName;
        this.m_methodRequired = methodRequired;
        this.m_componentClass = componentClass;
        this.dsVersion = dsVersion;
        this.configurableServiceProperties = configurableServiceProperties;
        this.m_state = this.m_methodName == null ? NotApplicable.INSTANCE : NotResolved.INSTANCE;
    }

    protected final DSVersion getDSVersion() {
        return this.dsVersion;
    }

    protected final boolean isDS12Felix() {
        return this.configurableServiceProperties;
    }

    protected final String getMethodName() {
        return this.m_methodName;
    }

    final Method getMethod() {
        return this.m_method;
    }

    protected final Class<?> getComponentClass() {
        return this.m_componentClass;
    }

    protected abstract void setTypes(T var1);

    synchronized void setMethod(MethodInfo<T> methodInfo, SimpleLogger logger) {
        Method method = this.m_method = methodInfo == null ? null : methodInfo.getMethod();
        if (this.m_method != null) {
            this.setTypes(methodInfo.getTypes());
            this.m_state = Resolved.INSTANCE;
            logger.log(4, "Found {0} method: {1}", new Object[]{this.getMethodNamePrefix(), this.m_method}, null);
        } else if (this.m_methodRequired) {
            this.m_state = NotFound.INSTANCE;
            logger.log(1, "{0} method [{1}] not found; Component will fail", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
        } else {
            logger.log(4, "{0} method [{1}] not found, ignoring", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
            this.m_state = NotApplicable.INSTANCE;
        }
    }

    State getState() {
        return this.m_state;
    }

    private MethodInfo<T> findMethod(SimpleLogger logger) throws InvocationTargetException {
        boolean acceptPrivate = this.getDSVersion().isDS11();
        boolean acceptPackage = this.getDSVersion().isDS11();
        Class<?> targetClass = this.getComponentClass();
        ClassLoader targetClasslLoader = targetClass.getClassLoader();
        String targetPackage = BaseMethod.getPackageName(targetClass);
        Class<?> theClass = targetClass;
        while (true) {
            if (logger.isLogEnabled(4)) {
                logger.log(4, "Locating method " + this.getMethodName() + " in class " + theClass.getName(), null);
            }
            try {
                MethodInfo<T> method = this.doFindMethod(theClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                logger.log(1, "findMethod: Suitable but non-accessible method {0} found in class {1}, subclass of {2}", new Object[]{this.getMethodName(), theClass.getName(), targetClass.getName()}, null);
                break;
            }
            theClass = theClass.getSuperclass();
            if (theClass == null) break;
            acceptPackage &= targetClasslLoader == theClass.getClassLoader() && targetPackage.equals(BaseMethod.getPackageName(theClass));
            acceptPrivate = false;
        }
        return null;
    }

    protected abstract MethodInfo<T> doFindMethod(Class<?> var1, boolean var2, boolean var3, SimpleLogger var4) throws SuitableMethodNotAccessibleException, InvocationTargetException;

    private MethodResult invokeMethod(Object componentInstance, P rawParameter, SimpleLogger logger) throws InvocationTargetException {
        try {
            if (componentInstance != null) {
                Object[] params = this.getParameters(this.m_method, rawParameter);
                logger.log(4, "invoking {0}: {1}: parameters {2}", new Object[]{this.getMethodNamePrefix(), this.getMethodName(), Arrays.asList(params)}, null);
                Object result = this.m_method.invoke(componentInstance, params);
                logger.log(4, "invoked {0}: {1}", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
                return new MethodResult(this.m_method.getReturnType() != Void.TYPE, (Map)result);
            }
            logger.log(2, "Method {0}: {1} cannot be called on null object", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
        }
        catch (IllegalStateException ise) {
            logger.log(4, ise.getMessage(), null);
            return null;
        }
        catch (IllegalAccessException ex) {
            logger.log(4, "Method {0} cannot be called", new Object[]{this.getMethodName()}, ex);
        }
        catch (InvocationTargetException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
        return MethodResult.VOID;
    }

    protected boolean returnValue() {
        return this.isDS12Felix();
    }

    protected abstract Object[] getParameters(Method var1, P var2);

    protected String getMethodNamePrefix() {
        return "";
    }

    public Method getMethod(Class<?> clazz, String name, Class[] parameterTypes, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            if (BaseMethod.accept(method, acceptPrivate, acceptPackage, this.returnValue())) {
                return method;
            }
            throw new SuitableMethodNotAccessibleException();
        }
        catch (NoSuchMethodException nsme) {
            if (logger.isLogEnabled(4)) {
                String argList = parameterTypes != null ? Arrays.asList(parameterTypes).toString() : "";
                logger.log(4, "Declared Method {0}.{1}({2}) not found", new Object[]{clazz.getName(), name, argList}, null);
            }
        }
        catch (NoClassDefFoundError cdfe) {
            if (logger.isLogEnabled(2)) {
                StringBuffer buf = new StringBuffer();
                buf.append("Failure loooking up method ").append(name).append('(');
                for (int i = 0; parameterTypes != null && i < parameterTypes.length; ++i) {
                    buf.append(parameterTypes[i].getName());
                    if (i <= 0) continue;
                    buf.append(", ");
                }
                buf.append(") in class class ").append(clazz.getName()).append(". Assuming no such method.");
                logger.log(2, buf.toString(), cdfe);
            }
        }
        catch (SuitableMethodNotAccessibleException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable, "Unexpected problem trying to get method " + name);
        }
        return null;
    }

    protected static boolean accept(Method method, boolean acceptPrivate, boolean acceptPackage, boolean allowReturnValue) {
        if (!(Void.TYPE == method.getReturnType() || ClassUtils.MAP_CLASS == method.getReturnType() && allowReturnValue)) {
            return false;
        }
        int mod = method.getModifiers();
        if (Modifier.isStatic(mod)) {
            return false;
        }
        if (Modifier.isPublic(mod) || Modifier.isProtected(mod)) {
            BaseMethod.setAccessible(method);
            return true;
        }
        if (Modifier.isPrivate(mod)) {
            if (acceptPrivate) {
                BaseMethod.setAccessible(method);
                return true;
            }
            return false;
        }
        if (acceptPackage) {
            BaseMethod.setAccessible(method);
            return true;
        }
        return false;
    }

    private static void setAccessible(final Method method) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
    }

    public static String getPackageName(Class<?> clazz) {
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        return dot > 0 ? name.substring(0, dot) : "";
    }

    public MethodResult invoke(Object componentInstance, P rawParameter, MethodResult methodCallFailureResult, SimpleLogger logger) {
        try {
            return this.m_state.invoke(this, componentInstance, rawParameter, logger);
        }
        catch (InvocationTargetException ite) {
            logger.log(1, "The {0} method has thrown an exception", new Object[]{this.getMethodName()}, ite.getCause());
            return methodCallFailureResult;
        }
    }

    public boolean methodExists(SimpleLogger logger) {
        return this.m_state.methodExists(this, logger);
    }

    private static class Resolved
    implements State {
        private static final State INSTANCE = new Resolved();

        private Resolved() {
        }

        @Override
        public <P, T> MethodResult invoke(BaseMethod<P, T> baseMethod, Object componentInstance, P rawParameter, SimpleLogger logger) throws InvocationTargetException {
            return ((BaseMethod)baseMethod).invokeMethod(componentInstance, rawParameter, logger);
        }

        @Override
        public <P, T> boolean methodExists(BaseMethod<P, T> baseMethod, SimpleLogger logger) {
            return true;
        }
    }

    private static class NotFound
    implements State {
        private static final State INSTANCE = new NotFound();

        private NotFound() {
        }

        @Override
        public <P, T> MethodResult invoke(BaseMethod<P, T> baseMethod, Object componentInstance, P rawParameter, SimpleLogger logger) {
            logger.log(1, "{0} method [{1}] not found", new Object[]{baseMethod.getMethodNamePrefix(), baseMethod.getMethodName()}, null);
            return null;
        }

        @Override
        public <P, T> boolean methodExists(BaseMethod<P, T> baseMethod, SimpleLogger logger) {
            return false;
        }
    }

    private static class NotResolved
    implements State {
        private static final State INSTANCE = new NotResolved();

        private NotResolved() {
        }

        private <P, T> void resolve(BaseMethod<P, T> baseMethod, SimpleLogger logger) {
            logger.log(4, "getting {0}: {1}", new Object[]{baseMethod.getMethodNamePrefix(), baseMethod.getMethodName()}, null);
            MethodInfo method = null;
            try {
                method = ((BaseMethod)baseMethod).findMethod(logger);
            }
            catch (InvocationTargetException ex) {
                logger.log(2, "{0} cannot be found", new Object[]{baseMethod.getMethodName()}, ex.getTargetException());
            }
            baseMethod.setMethod(method, logger);
        }

        @Override
        public <P, T> MethodResult invoke(BaseMethod<P, T> baseMethod, Object componentInstance, P rawParameter, SimpleLogger logger) throws InvocationTargetException {
            this.resolve(baseMethod, logger);
            return baseMethod.getState().invoke(baseMethod, componentInstance, rawParameter, logger);
        }

        @Override
        public <P, T> boolean methodExists(BaseMethod<P, T> baseMethod, SimpleLogger logger) {
            this.resolve(baseMethod, logger);
            return baseMethod.getState().methodExists(baseMethod, logger);
        }
    }

    private static class NotApplicable
    implements State {
        private static final State INSTANCE = new NotApplicable();

        private NotApplicable() {
        }

        @Override
        public <P, T> MethodResult invoke(BaseMethod<P, T> baseMethod, Object componentInstance, P rawParameter, SimpleLogger logger) {
            return MethodResult.VOID;
        }

        @Override
        public <P, T> boolean methodExists(BaseMethod<P, T> baseMethod, SimpleLogger logger) {
            return true;
        }
    }

    private static interface State {
        public <P, T> MethodResult invoke(BaseMethod<P, T> var1, Object var2, P var3, SimpleLogger var4) throws InvocationTargetException;

        public <P, T> boolean methodExists(BaseMethod<P, T> var1, SimpleLogger var2);
    }

    protected static final class MethodInfo<T> {
        private final Method m_method;
        private final T m_types;

        public MethodInfo(Method m) {
            this(m, null);
        }

        public MethodInfo(Method m, T types) {
            this.m_method = m;
            this.m_types = types;
        }

        public Method getMethod() {
            return this.m_method;
        }

        public T getTypes() {
            return this.m_types;
        }
    }
}

