/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.security.cli.CreateFileUser;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="update-file-user")
@PerLookup
@I18n(value="update.file.user")
@ExecuteOn(value={RuntimeType.ALL})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=AuthRealm.class, opType=RestEndpoint.OpType.POST, path="update-user", description="Update Users", params={@RestParam(name="authrealmname", value="$parent")})})
public class UpdateFileUser
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UpdateFileUser.class);
    @Param(name="groups", optional=true, separator=58)
    private List<String> groups = null;
    @Param(name="userpassword", optional=true, password=true)
    private String userpassword;
    @Param(name="authrealmname", optional=true)
    private String authRealmName;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Param(name="username", primary=true)
    private String userName;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;
    @Inject
    private AdminService adminService;
    private SecureAdmin secureAdmin = null;
    @AccessRequired.To(value={"update"})
    private AuthRealm fileAuthRealm;
    private SecurityService securityService;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        this.fileAuthRealm = CLIUtil.findRealm(this.securityService, this.authRealmName);
        if (this.fileAuthRealm == null) {
            ActionReport report = context.getActionReport();
            report.setMessage(localStrings.getLocalString("update.file.user.filerealmnotfound", "File realm {0} does not exist", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        this.authRealmName = this.fileAuthRealm.getName();
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String fileRealmClassName = this.fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("update.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{fileRealmClassName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : this.fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("update.file.user.keyfilenotfound", "There is no physical file associated with file realm {0}", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        boolean exists = new File(keyFile).exists();
        if (!exists) {
            report.setMessage(localStrings.getLocalString("file.realm.keyfilenonexistent", "The specified physical file {0} associated with the file realm {1} does not exist.", new Object[]{keyFile, this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String password = this.userpassword;
        if (password == null && this.groups == null) {
            report.setMessage(localStrings.getLocalString("update.file.user.keyfilenotreadable", "None of password or groups have been specified for update,Password for user {0} has to be specifiedthrough AS_ADMIN_USERPASSWORD property in the file specified in --passwordfile option", new Object[]{this.userName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (password != null) {
            this.secureAdmin = this.domain.getSecureAdmin();
            if (SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin) && this.adminService.getAuthRealmName().equals(this.authRealmName) && password.isEmpty()) {
                report.setMessage(localStrings.getLocalString("null_empty_password", "The admin user password is empty"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        FileRealm fr = null;
        try {
            this.realmsManager.createRealms(this.config);
            fr = (FileRealm)this.realmsManager.getFromLoadedRealms(this.config.getName(), this.authRealmName);
            if (fr == null) {
                throw new NoSuchRealmException(this.authRealmName);
            }
        }
        catch (NoSuchRealmException e) {
            report.setMessage(localStrings.getLocalString("update.file.user.realmnotsupported", "Configured file realm {0} does not exist.", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        try {
            CreateFileUser.handleAdminGroup(this.authRealmName, this.groups);
            String[] groups1 = this.groups == null ? null : this.groups.toArray(new String[this.groups.size()]);
            fr.updateUser(this.userName, this.userName, password, groups1);
            fr.persist();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("update.file.user.userupdatefailed", "Updating user {0} in file realm {1} failed", new Object[]{this.userName, this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

