/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProperties;
import org.eclipse.persistence.internal.jpa.modelgen.LoggerContext;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnitReader;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.TypeVisitor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.LogCategory;
import org.eclipse.persistence.logging.LogLevel;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;

@SupportedOptions(value={"eclipselink.canonicalmodel.prefix", "eclipselink.canonicalmodel.suffix", "eclipselink.canonicalmodel.subpackage", "eclipselink.canonicalmodel.load_xml", "eclipselink.canonicalmodel.use_static_factory", "eclipselink.canonicalmodel.generate_timestamp", "eclipselink.persistencexml", "eclipselink.logging.level.processor", "eclipselink.logging.level"})
@SupportedAnnotationTypes(value={"javax.persistence.*", "org.eclipse.persistence.annotations.*"})
public class CanonicalModelProcessor
extends AbstractProcessor {
    protected MetadataMirrorFactory nonStaticFactory;
    protected static MetadataMirrorFactory staticFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCanonicalModelClass(MetadataClass metadataClass, Element element, PersistenceUnit persistenceUnit) throws IOException {
        Writer writer = null;
        try {
            ClassAccessor accessor = persistenceUnit.getClassAccessor(metadataClass);
            String qualifiedName = accessor.getAccessibleObjectName();
            String className = this.getName(qualifiedName);
            String classPackage = this.getPackage(qualifiedName);
            String qualifiedCanonicalName = persistenceUnit.getQualifiedCanonicalName(qualifiedName);
            String canonicalName = this.getName(qualifiedCanonicalName);
            String canonicalpackage = this.getPackage(qualifiedCanonicalName);
            boolean isNewJava = SourceVersion.RELEASE_8.compareTo(this.processingEnv.getSourceVersion()) < 0;
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(qualifiedCanonicalName, element);
            writer = file.openWriter();
            if (!canonicalpackage.equals("")) {
                writer.append("package " + canonicalpackage + ";\n\n");
            }
            ArrayList<String> attributes = new ArrayList<String>();
            HashMap<String, String> imports = new HashMap<String, String>();
            if (isNewJava) {
                imports.put("Generated", "javax.annotation.processing.Generated");
            } else {
                imports.put("Generated", "javax.annotation.Generated");
            }
            if (!classPackage.equals(canonicalpackage)) {
                imports.put(className, qualifiedName);
            }
            for (MappingAccessor mappingAccessor : accessor.getDescriptor().getMappingAccessors()) {
                String attributeType;
                if (mappingAccessor.isTransient()) continue;
                MetadataAnnotatedElement annotatedElement = mappingAccessor.getAnnotatedElement();
                MetadataClass rawClass = mappingAccessor.getRawClass();
                String types = className;
                if (mappingAccessor.isBasic()) {
                    types = types + ", " + this.getUnqualifiedType(this.getBoxedType(annotatedElement, rawClass), imports);
                    attributeType = AttributeType.SingularAttribute.name();
                    imports.put(attributeType, "javax.persistence.metamodel.SingularAttribute");
                } else {
                    if (rawClass.isList()) {
                        attributeType = AttributeType.ListAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.ListAttribute");
                    } else if (rawClass.isSet()) {
                        attributeType = AttributeType.SetAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.SetAttribute");
                    } else if (rawClass.isMap()) {
                        attributeType = AttributeType.MapAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.MapAttribute");
                    } else if (rawClass.isCollection()) {
                        attributeType = AttributeType.CollectionAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.CollectionAttribute");
                    } else {
                        attributeType = AttributeType.SingularAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.SingularAttribute");
                    }
                    if (mappingAccessor.isMapAccessor()) {
                        if (mappingAccessor.isMappedKeyMapAccessor()) {
                            MetadataClass mapKeyClass = ((MappedKeyMapAccessor)mappingAccessor).getMapKeyClass();
                            types = types + ", " + this.getUnqualifiedType(mapKeyClass.getName(), imports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                        } else {
                            String mapKeyType;
                            if (annotatedElement.isGenericCollectionType()) {
                                mapKeyType = (String)annotatedElement.getGenericType().get(1);
                            } else if (mappingAccessor.getReferenceDescriptor().hasIdAccessor()) {
                                MappingAccessor idAccessor = (MappingAccessor)mappingAccessor.getReferenceDescriptor().getIdAccessors().values().iterator().next();
                                mapKeyType = idAccessor.getReferenceClassName();
                            } else {
                                mapKeyType = TypeVisitor.GENERIC_TYPE;
                            }
                            types = types + ", " + this.getUnqualifiedType(mapKeyType, imports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                        }
                    } else {
                        types = types + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                    }
                }
                attributes.add("    public static volatile " + attributeType + "<" + types + "> " + annotatedElement.getAttributeName() + ";\n");
            }
            String parent = this.writeImportStatements(imports, accessor, writer, persistenceUnit, canonicalpackage);
            String elVersion = "EclipseLink-" + Version.getVersion() + ".v" + Version.getBuildDate() + "-r" + Version.getBuildRevision();
            writer.append("@Generated(value=\"");
            if (isNewJava) {
                writer.append(CanonicalModelProcessor.class.getName());
            } else {
                writer.append(elVersion);
            }
            writer.append("\"");
            if (Boolean.valueOf(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.generate_timestamp", "true", this.processingEnv.getOptions())).booleanValue()) {
                Date date = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                writer.append(", date=\"" + sdf.format(date) + "\"");
            }
            if (isNewJava && Boolean.valueOf(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.generate_comments", "true", this.processingEnv.getOptions())).booleanValue()) {
                writer.append(", comments=\"");
                writer.append(elVersion);
                writer.append("\"");
            }
            writer.append(")\n");
            writer.append("@StaticMetamodel(" + className + ".class)\n");
            int modifier = accessor.getAccessibleObject().getModifiers();
            writer.append(Modifier.toString(modifier) + " class " + canonicalName);
            if (parent == null) {
                writer.append(" { \n\n");
            } else {
                writer.append(" extends " + parent + " {\n\n");
            }
            for (String str : attributes) {
                writer.append(str);
            }
            writer.append("\n}");
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
                writer = null;
            }
        }
    }

    protected void generateCanonicalModelClasses(MetadataMirrorFactory factory, PersistenceUnit persistenceUnit) throws IOException {
        Map<Element, MetadataClass> roundElements = factory.getRoundElements();
        for (Element roundElement : roundElements.keySet()) {
            MetadataClass roundClass = roundElements.get(roundElement);
            if (!persistenceUnit.containsClass(roundClass)) continue;
            if (factory.getLogger().shouldLog(LogLevel.FINEST, LogCategory.PROCESSOR)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating class: " + roundClass.getName());
            }
            this.generateCanonicalModelClass(roundClass, roundElement, persistenceUnit);
        }
    }

    protected String getBoxedType(MetadataAnnotatedElement annotatedElement, MetadataClass rawClass) {
        PrimitiveType primitiveType = (PrimitiveType)annotatedElement.getPrimitiveType();
        if (primitiveType != null) {
            return this.processingEnv.getTypeUtils().boxedClass(primitiveType).toString();
        }
        String type = annotatedElement.getType();
        return type == null ? rawClass.getType() : type;
    }

    protected String getName(String qualifiedName) {
        if (qualifiedName.indexOf(".") > -1) {
            return qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        }
        return qualifiedName;
    }

    protected String getPackage(String qualifiedName) {
        if (qualifiedName.indexOf(".") > -1) {
            return qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
        }
        return "";
    }

    protected String getUnqualifiedType(String type, HashMap<String, String> imports) {
        type = type.trim();
        if ((type = type.replace("$", ".")).contains("void")) {
            return TypeVisitor.GENERIC_TYPE;
        }
        if (type.startsWith("java.lang")) {
            return type.substring(type.lastIndexOf(".") + 1);
        }
        if (type.indexOf("<") > -1) {
            String raw = type.substring(0, type.indexOf("<"));
            String generic = type.substring(type.indexOf("<") + 1, type.length() - 1);
            if (raw.contains("Map")) {
                String key = generic.substring(0, generic.indexOf(","));
                String value = generic.substring(generic.indexOf(",") + 1);
                return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(key, imports) + ", " + this.getUnqualifiedType(value, imports) + ">";
            }
            return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(generic, imports) + ">";
        }
        if (type.indexOf(".") > -1) {
            String shortClassName = type.substring(type.lastIndexOf(".") + 1);
            if (imports.containsKey(shortClassName)) {
                if (imports.get(shortClassName).equals(type)) {
                    return type.substring(type.lastIndexOf(".") + 1);
                }
                return type;
            }
            if (shortClassName.indexOf("[") > 1) {
                imports.put(shortClassName, type.substring(0, type.indexOf("[")));
            } else {
                imports.put(shortClassName, type);
            }
            return shortClassName;
        }
        return type;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver() && !roundEnv.errorRaised()) {
            MetadataMirrorFactory factory = null;
            try {
                MetadataLogger logger;
                if (Boolean.valueOf(CanonicalModelProperties.getOption("eclipselink.canonicalmodel.use_static_factory", "true", this.processingEnv.getOptions())).booleanValue()) {
                    if (staticFactory == null) {
                        logger = new MetadataLogger((AbstractSession)new ServerSession(new Project(new DatabaseLogin())));
                        staticFactory = new MetadataMirrorFactory(logger, LoggerContext.buildContext(this.processingEnv.getOptions()), Thread.currentThread().getContextClassLoader());
                        staticFactory.getLoggerContext().updateMetadataLogger(logger);
                        if (logger.shouldLog(LogLevel.INFO, LogCategory.PROCESSOR)) {
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Creating static metadata factory ...");
                        }
                    }
                    factory = staticFactory;
                } else {
                    if (this.nonStaticFactory == null) {
                        logger = new MetadataLogger((AbstractSession)new ServerSession(new Project(new DatabaseLogin())));
                        this.nonStaticFactory = new MetadataMirrorFactory(logger, LoggerContext.buildContext(this.processingEnv.getOptions()), Thread.currentThread().getContextClassLoader());
                        this.nonStaticFactory.getLoggerContext().updateMetadataLogger(logger);
                        if (logger.shouldLog(LogLevel.INFO, LogCategory.PROCESSOR)) {
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Creating non-static metadata factory ...");
                        }
                    }
                    factory = this.nonStaticFactory;
                }
                logger = factory.getLogger();
                LoggerContext logCtx = factory.getLoggerContext();
                if (logger.shouldLog(LogLevel.CONFIG, LogCategory.PROCESSOR)) {
                    for (String optionKey : this.processingEnv.getOptions().keySet()) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, "Found Option : " + optionKey + ", with value: " + this.processingEnv.getOptions().get(optionKey));
                    }
                }
                factory.setEnvironments(this.processingEnv, roundEnv);
                PersistenceUnitReader puReader = new PersistenceUnitReader(logger, this.processingEnv);
                puReader.initPersistenceUnits(factory);
                for (PersistenceUnit persistenceUnit : factory.getPersistenceUnits()) {
                    boolean updateLogger;
                    boolean bl = updateLogger = logger != null && !logCtx.isAny();
                    if (updateLogger) {
                        LoggerContext.updateMetadataLogger(logger, persistenceUnit);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(Entity.class)) {
                        persistenceUnit.addEntityAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(Embeddable.class)) {
                        persistenceUnit.addEmbeddableAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(MappedSuperclass.class)) {
                        persistenceUnit.addMappedSuperclassAccessor(element);
                    }
                    persistenceUnit.preProcessForCanonicalModel();
                    this.generateCanonicalModelClasses(factory, persistenceUnit);
                    if (!updateLogger) continue;
                    logCtx.updateMetadataLogger(logger);
                }
            }
            catch (Exception e) {
                MetadataLogger logger;
                MetadataLogger metadataLogger = logger = factory != null ? factory.getLogger() : null;
                if (logger == null || logger.shouldLog(LogLevel.SEVERE, LogCategory.PROCESSOR)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString());
                }
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    protected String writeImportStatements(HashMap<String, String> typeImports, ClassAccessor accessor, Writer writer, PersistenceUnit persistenceUnit, String childCanonicalpackage) throws IOException {
        String parentCanonicalName = null;
        ArrayList<String> imps = new ArrayList<String>();
        imps.addAll(typeImports.values());
        imps.add("javax.persistence.metamodel.StaticMetamodel");
        MetadataClass parentCls = accessor.getJavaClass().getSuperclass();
        MetadataProject project = accessor.getProject();
        if (project.hasEntity(parentCls) || project.hasEmbeddable(parentCls) || project.hasMappedSuperclass(parentCls)) {
            String qualifiedParentCanonicalName = persistenceUnit.getQualifiedCanonicalName(parentCls.getName());
            parentCanonicalName = this.getName(qualifiedParentCanonicalName);
            String parentCanonicalPackage = this.getPackage(qualifiedParentCanonicalName);
            if (!parentCanonicalPackage.equals(childCanonicalpackage)) {
                imps.add(qualifiedParentCanonicalName);
            }
        }
        Collections.sort(imps);
        for (String typeImport : imps) {
            writer.append("import " + typeImport + ";\n");
        }
        writer.append("\n");
        return parentCanonicalName;
    }

    protected static enum AttributeType {
        CollectionAttribute,
        ListAttribute,
        MapAttribute,
        SetAttribute,
        SingularAttribute;

    }
}

