/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.InstanceCommand;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(mode=0, value=10)
public class CommandThreadPool
implements PostConstruct {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private Domain domain;
    @Inject
    private Logger logger;
    private ExecutorService svc = null;

    public void postConstruct() {
        List lss;
        NetworkConfig nwc;
        if (this.serverEnv.isInstance()) {
            return;
        }
        int poolSize = 5;
        Config svrConfig = this.domain.getConfigNamed("server-config");
        if (svrConfig != null && (nwc = svrConfig.getNetworkConfig()) != null && (lss = nwc.getNetworkListeners().getNetworkListener()) != null && !lss.isEmpty()) {
            for (NetworkListener ls : lss) {
                if (!"admin-listener".equals(ls.getName()) || ls.findThreadPool() == null) continue;
                poolSize = Integer.parseInt(ls.findThreadPool().getMaxThreadPoolSize());
            }
        }
        this.svc = Executors.newFixedThreadPool(poolSize, new InstanceStateThreadFactory());
    }

    public Future<InstanceCommandResult> submitJob(InstanceCommand ice, InstanceCommandResult r) {
        FutureTask<InstanceCommandResult> t = new FutureTask<InstanceCommandResult>((Runnable)ice, r);
        return this.svc.submit(t, r);
    }

    private static class InstanceStateThreadFactory
    implements ThreadFactory {
        private InstanceStateThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnableObj) {
            Thread t = new Thread(runnableObj);
            t.setDaemon(true);
            return t;
        }
    }
}

